/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.FlatDependencyContainer;
import com.android.build.gradle.internal.dependency.MutableDependencyDataMap;
import com.android.builder.dependency.level2.AndroidDependency;
import com.android.builder.dependency.level2.AtomDependency;
import com.android.builder.dependency.level2.Dependency;
import com.android.builder.dependency.level2.DependencyContainer;
import com.android.builder.dependency.level2.DependencyNode;
import com.android.builder.dependency.level2.JavaDependency;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DependencyGraph {
    private final ImmutableMap<Object, Dependency> dependencyMap;
    private final ImmutableList<DependencyNode> dependencies;
    private final MutableDependencyDataMap mutableDependencyDataMap;
    private static DependencyGraph EMPTY = new DependencyGraph((Map<Object, Dependency>)ImmutableMap.of(), (List<DependencyNode>)ImmutableList.of(), MutableDependencyDataMap.EMPTY);

    public DependencyGraph(Map<Object, Dependency> dependencyMap, List<DependencyNode> dependencies, MutableDependencyDataMap mutableDependencyDataMap) {
        this.dependencyMap = ImmutableMap.copyOf(dependencyMap);
        this.dependencies = ImmutableList.copyOf(dependencies);
        this.mutableDependencyDataMap = mutableDependencyDataMap;
    }

    public static DependencyGraph getEmpty() {
        return EMPTY;
    }

    public ImmutableMap<Object, Dependency> getDependencyMap() {
        return this.dependencyMap;
    }

    public ImmutableList<DependencyNode> getDependencies() {
        return this.dependencies;
    }

    public MutableDependencyDataMap getMutableDependencyDataMap() {
        return this.mutableDependencyDataMap;
    }

    public List<Dependency> flatten(Predicate<DependencyNode> filter) {
        LinkedHashSet<Dependency> flatDependencies = new LinkedHashSet<Dependency>();
        this.computeFlatList(this.dependencies, flatDependencies, filter, null);
        return Lists.reverse(new ArrayList<Dependency>(flatDependencies));
    }

    public FlatDependencyContainer flatten(AndroidDependency testedLibrary, DependencyContainer testedDependencyGraph) {
        ImmutableList testedLocalJars = testedDependencyGraph != null ? testedDependencyGraph.getDirectLocalJavaDependencies() : null;
        LinkedHashSet<Dependency> flatDependencies = new LinkedHashSet<Dependency>();
        this.computeFlatList(this.dependencies, flatDependencies, null, (List<JavaDependency>)testedLocalJars);
        if (testedLibrary != null && !flatDependencies.contains(testedLibrary)) {
            flatDependencies.add((Dependency)testedLibrary);
        }
        LinkedHashSet<Dependency> directDependencies = new LinkedHashSet<Dependency>();
        for (int i = this.dependencies.size() - 1; i >= 0; --i) {
            DependencyNode node = (DependencyNode)this.dependencies.get(i);
            Dependency dependency = (Dependency)this.dependencyMap.get(node.getAddress());
            assert (dependency != null);
            DependencyGraph.addDependencyToSet(dependency, node, directDependencies, (List<JavaDependency>)testedLocalJars);
        }
        return new FlatDependencyContainer(this, Lists.reverse(new ArrayList<Dependency>(flatDependencies)), Lists.reverse(new ArrayList(directDependencies)), this.getBaseAtom(), this.mutableDependencyDataMap);
    }

    private AtomDependency getBaseAtom() {
        List<DependencyNode> atomList = this.dependencies.stream().filter(node -> node.getNodeType() == DependencyNode.NodeType.ATOM).collect(Collectors.toList());
        if (atomList.isEmpty()) {
            return null;
        }
        ArrayList baseAtoms = Lists.newArrayList();
        this.collectAtomLeaves(atomList, baseAtoms);
        assert (baseAtoms.size() == 1);
        return (AtomDependency)baseAtoms.get(0);
    }

    private void collectAtomLeaves(Collection<DependencyNode> nodes, List<AtomDependency> outLeaves) {
        for (DependencyNode node : nodes) {
            List<DependencyNode> atomList = node.getDependencies().stream().filter(n -> n.getNodeType() == DependencyNode.NodeType.ATOM).collect(Collectors.toList());
            if (atomList.isEmpty()) {
                outLeaves.add((AtomDependency)this.dependencyMap.get(node.getAddress()));
                continue;
            }
            this.collectAtomLeaves(atomList, outLeaves);
        }
    }

    private void computeFlatList(ImmutableList<DependencyNode> dependencyNodes, Set<Dependency> outFlatDependencies, Predicate<DependencyNode> filter, List<JavaDependency> testedLocalJars) {
        for (int i = dependencyNodes.size() - 1; i >= 0; --i) {
            DependencyNode node = (DependencyNode)dependencyNodes.get(i);
            if (filter != null && !filter.test(node)) continue;
            Dependency dependency = (Dependency)this.dependencyMap.get(node.getAddress());
            assert (dependency != null);
            if (outFlatDependencies.contains(dependency)) continue;
            this.computeFlatList((ImmutableList<DependencyNode>)node.getDependencies(), outFlatDependencies, filter, null);
            DependencyGraph.addDependencyToSet(dependency, node, outFlatDependencies, testedLocalJars);
        }
    }

    private static void addDependencyToSet(Dependency dependency, DependencyNode node, Set<Dependency> outFlatDependencies, List<JavaDependency> testedLocalJars) {
        if (testedLocalJars == null || node.getNodeType() != DependencyNode.NodeType.JAVA || !testedLocalJars.contains(dependency)) {
            outFlatDependencies.add(dependency);
        }
    }
}

