/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.DependencyContainerImpl;
import com.android.build.gradle.internal.dependency.DependencyGraph;
import com.android.build.gradle.internal.dependency.MutableDependencyDataMap;
import com.android.builder.dependency.level2.AtomDependency;
import com.android.builder.dependency.level2.Dependency;
import com.android.builder.dependency.level2.DependencyContainer;
import com.android.builder.dependency.level2.DependencyNode;
import com.android.utils.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

final class FlatDependencyContainer {
    private final DependencyGraph dependencyGraph;
    private final ImmutableList<Dependency> allDependencies;
    private final ImmutableList<Dependency> directDependencies;
    private final AtomDependency baseAtom;
    private final MutableDependencyDataMap mutableDependencyDataMap;

    FlatDependencyContainer(DependencyGraph dependencyGraph, List<Dependency> allDependencies, List<Dependency> directDependencies, AtomDependency baseAtom, MutableDependencyDataMap mutableDependencyDataMap) {
        this.dependencyGraph = dependencyGraph;
        this.allDependencies = ImmutableList.copyOf(allDependencies);
        this.directDependencies = ImmutableList.copyOf(directDependencies);
        this.baseAtom = baseAtom;
        this.mutableDependencyDataMap = mutableDependencyDataMap;
    }

    public ImmutableList<Dependency> getAllDependencies() {
        return this.allDependencies;
    }

    ImmutableList<Dependency> getDirectDependencies() {
        return this.directDependencies;
    }

    public MutableDependencyDataMap getMutableDependencyDataMap() {
        return this.mutableDependencyDataMap;
    }

    DependencyContainer filterSkippedLibraries() {
        return new DependencyContainerImpl((Map<Object, Dependency>)this.dependencyGraph.getDependencyMap(), (List<DependencyNode>)this.dependencyGraph.getDependencies(), this.mutableDependencyDataMap, (List)this.allDependencies.stream().filter(dependency -> !this.mutableDependencyDataMap.isSkipped((Dependency)dependency)).collect(ImmutableCollectors.toImmutableList()), (List)this.directDependencies.stream().filter(dependency -> !this.mutableDependencyDataMap.isSkipped((Dependency)dependency)).collect(ImmutableCollectors.toImmutableList()), this.baseAtom);
    }
}

