/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.ConfigurationProvider;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.DependencyChecker;
import com.android.build.gradle.internal.dependency.DependencyGraph;
import com.android.build.gradle.internal.dependency.FlatDependencyContainer;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.SyncIssueHandler;
import com.android.builder.core.VariantType;
import com.android.builder.dependency.level2.AndroidDependency;
import com.android.builder.dependency.level2.DependencyContainer;
import com.android.builder.dependency.level2.DependencyNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedConfiguration;

public class VariantDependencies {
    public static final String CONFIGURATION_METADATA = "-metadata";
    public static final String CONFIGURATION_MAPPING = "-mapping";
    public static final String CONFIGURATION_CLASSES = "-classes";
    public static final String CONFIGURATION_MANIFEST = "-manifest";
    private final String variantName;
    private final Configuration compileConfiguration;
    private final Configuration packageConfiguration;
    private final Configuration publishConfiguration;
    private final Configuration annotationProcessorConfiguration;
    private final Configuration jackPluginConfiguration;
    private final Configuration mappingConfiguration;
    private final Configuration classesConfiguration;
    private final Configuration metadataConfiguration;
    private final VariantDependencies testedVariantDependencies;
    private final AndroidDependency testedVariantOutput;
    private Configuration manifestConfiguration;
    private DependencyGraph compileGraph;
    private DependencyGraph packageGraph;
    private DependencyContainer compileContainer;
    private DependencyContainer packageContainer;
    private boolean annotationsPresent;
    private DependencyChecker checker;

    public static Builder builder(Project project, ErrorReporter errorReporter, String variantName, VariantType variantType) {
        return new Builder(project, errorReporter, variantName, variantType);
    }

    private VariantDependencies(String variantName, DependencyChecker dependencyChecker, Configuration compileConfiguration, Configuration packageConfiguration, Configuration publishConfiguration, Configuration annotationProcessorConfiguration, Configuration jackPluginConfiguration, Configuration mappingConfiguration, Configuration classesConfiguration, Configuration metadataConfiguration, Configuration manifestConfiguration, VariantDependencies testedVariantDependencies, AndroidDependency testedVariantOutput) {
        this.variantName = variantName;
        this.checker = dependencyChecker;
        this.compileConfiguration = compileConfiguration;
        this.packageConfiguration = packageConfiguration;
        this.publishConfiguration = publishConfiguration;
        this.annotationProcessorConfiguration = annotationProcessorConfiguration;
        this.jackPluginConfiguration = jackPluginConfiguration;
        this.mappingConfiguration = mappingConfiguration;
        this.classesConfiguration = classesConfiguration;
        this.metadataConfiguration = metadataConfiguration;
        this.manifestConfiguration = manifestConfiguration;
        this.testedVariantDependencies = testedVariantDependencies;
        this.testedVariantOutput = testedVariantOutput;
    }

    public String getName() {
        return this.variantName;
    }

    public Configuration getCompileConfiguration() {
        return this.compileConfiguration;
    }

    public Configuration getPackageConfiguration() {
        return this.packageConfiguration;
    }

    public Configuration getPublishConfiguration() {
        return this.publishConfiguration;
    }

    public Configuration getAnnotationProcessorConfiguration() {
        return this.annotationProcessorConfiguration;
    }

    public Configuration getJackPluginConfiguration() {
        return this.jackPluginConfiguration;
    }

    public Configuration getMappingConfiguration() {
        return this.mappingConfiguration;
    }

    public Configuration getClassesConfiguration() {
        return this.classesConfiguration;
    }

    public Configuration getMetadataConfiguration() {
        return this.metadataConfiguration;
    }

    public Configuration getManifestConfiguration() {
        return this.manifestConfiguration;
    }

    public void setDependencies(DependencyGraph compileGraph, DependencyGraph packageGraph, boolean validate) {
        this.compileGraph = compileGraph;
        this.packageGraph = packageGraph;
        FlatDependencyContainer flatCompileContainer = compileGraph.flatten(this.testedVariantOutput, this.testedVariantDependencies != null ? this.testedVariantDependencies.getCompileDependencies() : null);
        FlatDependencyContainer flatPackageContainer = packageGraph.flatten(this.testedVariantOutput, this.testedVariantDependencies != null ? this.testedVariantDependencies.getPackageDependencies() : null);
        if (validate) {
            if (this.testedVariantOutput != null) {
                this.checker.validate(flatCompileContainer, flatPackageContainer, null);
            } else {
                this.checker.validate(flatCompileContainer, flatPackageContainer, this.testedVariantDependencies);
            }
        }
        this.compileContainer = flatCompileContainer.filterSkippedLibraries();
        this.packageContainer = flatPackageContainer.filterSkippedLibraries();
    }

    DependencyGraph getCompileGraph() {
        return this.compileGraph;
    }

    DependencyGraph getPackageGraph() {
        return this.packageGraph;
    }

    public DependencyContainer getCompileDependencies() {
        return this.compileContainer;
    }

    public DependencyContainer getPackageDependencies() {
        return this.packageContainer;
    }

    public Set<File> resolveAndGetAnnotationProcessorClassPath(boolean includeClasspath, ErrorReporter errorReporter) {
        ResolvedConfiguration resolvedConfiguration;
        if (this.getAnnotationProcessorConfiguration().getAllDependencies().isEmpty()) {
            return Collections.emptySet();
        }
        if (this.getAnnotationProcessorConfiguration().getState() != Configuration.State.RESOLVED && includeClasspath) {
            this.getAnnotationProcessorConfiguration().extendsFrom(new Configuration[]{this.getCompileConfiguration(), this.getPackageConfiguration()});
        }
        if ((resolvedConfiguration = this.getAnnotationProcessorConfiguration().getResolvedConfiguration()).hasError()) {
            try {
                resolvedConfiguration.rethrowFailure();
            }
            catch (Exception e) {
                errorReporter.handleSyncError("annotationProcessor", 2, e.getMessage());
                return Collections.emptySet();
            }
        }
        return this.getAnnotationProcessorConfiguration().getFiles().stream().filter(file -> !file.getPath().endsWith(".aar")).collect(Collectors.toSet());
    }

    public Set<File> resolveAndGetJackPluginClassPath(ErrorReporter errorReporter) {
        if (this.getJackPluginConfiguration().getAllDependencies().isEmpty()) {
            return Collections.emptySet();
        }
        ResolvedConfiguration resolvedConfiguration = this.getJackPluginConfiguration().getResolvedConfiguration();
        if (resolvedConfiguration.hasError()) {
            try {
                resolvedConfiguration.rethrowFailure();
            }
            catch (Exception e) {
                errorReporter.handleSyncError("jackPlugin", 2, "Unable to find Jack plugin. " + e.getMessage());
                return Collections.emptySet();
            }
        }
        return this.getJackPluginConfiguration().getFiles();
    }

    public DependencyChecker getChecker() {
        return this.checker;
    }

    public void setAnnotationsPresent(boolean annotationsPresent) {
        this.annotationsPresent = annotationsPresent;
    }

    public boolean isAnnotationsPresent() {
        return this.annotationsPresent;
    }

    public boolean hasNonOptionalLibraries() {
        return this.packageGraph.getDependencies().stream().anyMatch(node -> node.getNodeType() == DependencyNode.NodeType.ANDROID);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.variantName).toString();
    }

    public static final class Builder {
        private final Project project;
        private final ErrorReporter errorReporter;
        private final String variantName;
        private final VariantType variantType;
        private boolean publishVariant = false;
        private VariantType testedVariantType = null;
        private VariantDependencies testedVariantDependencies = null;
        private AndroidDependency testedVariantOutput = null;
        private final Set<Configuration> compileConfigs = Sets.newHashSet();
        private final Set<Configuration> apkConfigs = Sets.newHashSet();
        private final Set<Configuration> annotationConfigs = Sets.newHashSet();
        private final Set<Configuration> jackPluginConfigs = Sets.newHashSet();

        protected Builder(Project project, ErrorReporter errorReporter, String variantName, VariantType variantType) {
            this.project = project;
            this.errorReporter = errorReporter;
            this.variantName = variantName;
            this.variantType = variantType;
        }

        public Builder setPublishVariant(boolean publishVariant) {
            this.publishVariant = publishVariant;
            return this;
        }

        public Builder setTestedVariantType(VariantType testedVariantType) {
            this.testedVariantType = testedVariantType;
            return this;
        }

        public Builder addProviders(ConfigurationProvider ... providers) {
            for (ConfigurationProvider provider : providers) {
                this.addProvider(provider);
            }
            return this;
        }

        public Builder addProviders(Collection<ConfigurationProvider> providers) {
            for (ConfigurationProvider provider : providers) {
                this.addProvider(provider);
            }
            return this;
        }

        public Builder addProvider(ConfigurationProvider provider) {
            if (provider != null) {
                this.compileConfigs.add(provider.getCompileConfiguration());
                if (provider.getProvidedConfiguration() != null) {
                    this.compileConfigs.add(provider.getProvidedConfiguration());
                }
                this.apkConfigs.add(provider.getCompileConfiguration());
                this.apkConfigs.add(provider.getPackageConfiguration());
                this.annotationConfigs.add(provider.getAnnotationProcessorConfiguration());
                this.jackPluginConfigs.add(provider.getJackPluginConfiguration());
            }
            return this;
        }

        public Builder addTestedVariant(GradleVariantConfiguration testedConfig, VariantDependencies testedVariant) {
            Preconditions.checkNotNull((Object)this.testedVariantType, (Object)"cannot call addTestedVariant before setTestedVariantType");
            if (this.testedVariantType == VariantType.LIBRARY) {
                this.compileConfigs.add(testedVariant.getCompileConfiguration());
                this.apkConfigs.add(testedVariant.getPackageConfiguration());
                this.annotationConfigs.add(testedVariant.getAnnotationProcessorConfiguration());
                this.jackPluginConfigs.add(testedVariant.getJackPluginConfiguration());
                this.testedVariantOutput = testedConfig.getOutput();
            }
            this.testedVariantDependencies = testedVariant;
            return this;
        }

        public VariantDependencies build() {
            Configuration compile = (Configuration)this.project.getConfigurations().maybeCreate("_" + this.variantName + "Compile");
            compile.setVisible(false);
            compile.setDescription("## Internal use, do not manually configure ##");
            compile.setExtendsFrom(this.compileConfigs);
            Configuration annotationProcessor = (Configuration)this.project.getConfigurations().maybeCreate("_" + this.variantName + "AnnotationProcessor");
            annotationProcessor.setVisible(false);
            annotationProcessor.setDescription("## Internal use, do not manually configure ##");
            annotationProcessor.setExtendsFrom(this.annotationConfigs);
            Configuration jackPlugin = (Configuration)this.project.getConfigurations().maybeCreate("_" + this.variantName + "JackPlugin");
            jackPlugin.setVisible(false);
            jackPlugin.setDescription("## Internal use, do not manually configure ##");
            jackPlugin.setExtendsFrom(this.jackPluginConfigs);
            Configuration apk = (Configuration)this.project.getConfigurations().maybeCreate(this.variantType == VariantType.LIBRARY ? "_" + this.variantName + "Publish" : "_" + this.variantName + "Apk");
            apk.setVisible(false);
            apk.setDescription("## Internal use, do not manually configure ##");
            apk.setExtendsFrom(this.apkConfigs);
            Configuration publish = null;
            Configuration mapping = null;
            Configuration classes = null;
            Configuration metadata = null;
            Configuration manifest = null;
            if (this.publishVariant) {
                publish = (Configuration)this.project.getConfigurations().maybeCreate(this.variantName);
                publish.setDescription("Published Configuration for Variant " + this.variantName);
                if (this.variantType == VariantType.LIBRARY) {
                    publish.setExtendsFrom(this.apkConfigs);
                }
                metadata = (Configuration)this.project.getConfigurations().create(this.variantName + VariantDependencies.CONFIGURATION_METADATA);
                metadata.setDescription("Published APKs metadata for Variant " + this.variantName);
                mapping = (Configuration)this.project.getConfigurations().maybeCreate(this.variantName + VariantDependencies.CONFIGURATION_MAPPING);
                mapping.setDescription("Published mapping configuration for Variant " + this.variantName);
                classes = (Configuration)this.project.getConfigurations().maybeCreate(this.variantName + VariantDependencies.CONFIGURATION_CLASSES);
                classes.setDescription("Published classes configuration for Variant " + this.variantName);
                manifest = (Configuration)this.project.getConfigurations().maybeCreate(this.variantName + VariantDependencies.CONFIGURATION_MANIFEST);
                manifest.setDescription("Published manifest configuration for Variant " + this.variantName);
                classes.setExtendsFrom(this.compileConfigs);
            }
            DependencyChecker checker = new DependencyChecker(this.project.getPath().equals(":") ? this.project.getName() : this.project.getPath(), this.variantName, (SyncIssueHandler)this.errorReporter, this.variantType, this.testedVariantType);
            return new VariantDependencies(this.variantName, checker, compile, apk, publish, annotationProcessor, jackPlugin, mapping, classes, metadata, manifest, this.testedVariantDependencies, this.testedVariantOutput);
        }
    }
}

