/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.builder.model.AaptOptions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class AaptOptionsImpl
implements AaptOptions,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String ignoreAssets;
    private final Collection<String> noCompress;
    private final boolean failOnMissingConfigEntry;
    private final List<String> additionalParameters;

    static AaptOptions create(AaptOptions aaptOptions) {
        return new AaptOptionsImpl(aaptOptions.getIgnoreAssets(), aaptOptions.getNoCompress(), aaptOptions.getFailOnMissingConfigEntry(), aaptOptions.getAdditionalParameters());
    }

    public AaptOptionsImpl(String ignoreAssets, Collection<String> noCompress, boolean failOnMissingConfigEntry, List<String> additionalParameters) {
        this.ignoreAssets = ignoreAssets;
        this.failOnMissingConfigEntry = failOnMissingConfigEntry;
        this.noCompress = noCompress == null ? null : ImmutableList.copyOf(noCompress);
        this.additionalParameters = additionalParameters == null ? ImmutableList.of() : additionalParameters;
    }

    public String getIgnoreAssets() {
        return this.ignoreAssets;
    }

    public Collection<String> getNoCompress() {
        return this.noCompress;
    }

    public boolean getFailOnMissingConfigEntry() {
        return this.failOnMissingConfigEntry;
    }

    public List<String> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public String toString() {
        return "AaptOptions{, ignoreAssets=" + this.ignoreAssets + ", noCompress=" + this.noCompress + ", failOnMissingConfigEntry=" + this.failOnMissingConfigEntry + ", additionalParameters=" + this.additionalParameters + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AaptOptionsImpl that = (AaptOptionsImpl)o;
        return this.failOnMissingConfigEntry == that.failOnMissingConfigEntry && Objects.equals(this.ignoreAssets, that.ignoreAssets) && Objects.equals(this.noCompress, that.noCompress) && Objects.equals(this.additionalParameters, that.additionalParameters);
    }

    public int hashCode() {
        return Objects.hash(this.ignoreAssets, this.noCompress, this.failOnMissingConfigEntry, this.additionalParameters);
    }
}

