/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.ide.BaseArtifactImpl;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.ClassField;
import com.android.builder.model.Dependencies;
import com.android.builder.model.InstantRun;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.level2.DependencyGraphs;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class AndroidArtifactImpl
extends BaseArtifactImpl
implements AndroidArtifact,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Collection<AndroidArtifactOutput> outputs;
    private final boolean isSigned;
    private final String signingConfigName;
    private final String applicationId;
    private final String sourceGenTaskName;
    private final List<File> generatedResourceFolders;
    private final Set<String> abiFilters;
    private final Collection<NativeLibrary> nativeLibraries;
    private final Map<String, ClassField> buildConfigFields;
    private final Map<String, ClassField> resValues;
    private final InstantRun instantRun;

    AndroidArtifactImpl(String name, Collection<AndroidArtifactOutput> outputs, String assembleTaskName, boolean isSigned, String signingConfigName, String applicationId, String sourceGenTaskName, String compileTaskName, List<File> generatedSourceFolders, List<File> generatedResourceFolders, File classesFolder, File javaResourcesFolder, Dependencies compileDependencies, DependencyGraphs dependencyGraphs, SourceProvider variantSourceProvider, SourceProvider multiFlavorSourceProviders, Set<String> abiFilters, Collection<NativeLibrary> nativeLibraries, Map<String, ClassField> buildConfigFields, Map<String, ClassField> resValues, InstantRun instantRun) {
        super(name, assembleTaskName, compileTaskName, classesFolder, javaResourcesFolder, compileDependencies, dependencyGraphs, variantSourceProvider, multiFlavorSourceProviders, generatedSourceFolders);
        this.outputs = outputs;
        this.isSigned = isSigned;
        this.signingConfigName = signingConfigName;
        this.applicationId = applicationId;
        this.sourceGenTaskName = sourceGenTaskName;
        this.generatedResourceFolders = generatedResourceFolders;
        this.abiFilters = abiFilters;
        this.nativeLibraries = nativeLibraries;
        this.buildConfigFields = buildConfigFields;
        this.resValues = resValues;
        this.instantRun = instantRun;
    }

    public Collection<AndroidArtifactOutput> getOutputs() {
        return this.outputs;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public String getSigningConfigName() {
        return this.signingConfigName;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getSourceGenTaskName() {
        return this.sourceGenTaskName;
    }

    public Set<String> getIdeSetupTaskNames() {
        return Sets.newHashSet((Object[])new String[]{this.getSourceGenTaskName()});
    }

    public List<File> getGeneratedResourceFolders() {
        return this.generatedResourceFolders;
    }

    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    public Collection<NativeLibrary> getNativeLibraries() {
        return this.nativeLibraries;
    }

    public Map<String, ClassField> getBuildConfigFields() {
        return this.buildConfigFields;
    }

    public Map<String, ClassField> getResValues() {
        return this.resValues;
    }

    public InstantRun getInstantRun() {
        return this.instantRun;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndroidArtifactImpl that = (AndroidArtifactImpl)o;
        return this.isSigned == that.isSigned && Objects.equals(this.outputs, that.outputs) && Objects.equals(this.signingConfigName, that.signingConfigName) && Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.sourceGenTaskName, that.sourceGenTaskName) && Objects.equals(this.generatedResourceFolders, that.generatedResourceFolders) && Objects.equals(this.abiFilters, that.abiFilters) && Objects.equals(this.nativeLibraries, that.nativeLibraries) && Objects.equals(this.buildConfigFields, that.buildConfigFields) && Objects.equals(this.resValues, that.resValues) && Objects.equals(this.instantRun, that.instantRun);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.outputs, this.isSigned, this.signingConfigName, this.applicationId, this.sourceGenTaskName, this.generatedResourceFolders, this.abiFilters, this.nativeLibraries, this.buildConfigFields, this.resValues, this.instantRun);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("outputs", this.outputs).add("isSigned", this.isSigned).add("signingConfigName", (Object)this.signingConfigName).add("applicationId", (Object)this.applicationId).add("sourceGenTaskName", (Object)this.sourceGenTaskName).add("generatedResourceFolders", this.generatedResourceFolders).add("abiFilters", this.abiFilters).add("nativeLibraries", this.nativeLibraries).add("buildConfigFields", this.buildConfigFields).add("resValues", this.resValues).add("instantRun", (Object)this.instantRun).toString();
    }
}

