/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.ide.LibraryImpl;
import com.android.builder.dependency.level2.AtomDependency;
import com.android.builder.model.AndroidAtom;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AndroidAtomImpl
extends LibraryImpl
implements AndroidAtom,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String variant;
    private final File bundle;
    private final File folder;
    private final File manifest;
    private final File jarFile;
    private final File resFolder;
    private final File assetsFolder;
    private final String atomName;
    private final File dexFolder;
    private final File atomMetadataFile;
    private final File libFolder;
    private final File javaResFolder;
    private final File resourcePackage;
    private final List<AndroidAtom> androidAtoms = ImmutableList.of();
    private final List<AndroidLibrary> androidLibraries = ImmutableList.of();
    private final Collection<JavaLibrary> javaLibraries = ImmutableList.of();

    AndroidAtomImpl(AtomDependency clonedAtom) {
        super(clonedAtom.getProjectPath(), null, clonedAtom.getCoordinates(), false, false);
        this.variant = clonedAtom.getVariant();
        this.bundle = clonedAtom.getArtifactFile();
        this.folder = clonedAtom.getExtractedFolder();
        this.manifest = clonedAtom.getManifest();
        this.jarFile = clonedAtom.getJarFile();
        this.resFolder = clonedAtom.getResFolder();
        this.assetsFolder = clonedAtom.getAssetsFolder();
        this.atomName = clonedAtom.getAtomName();
        this.dexFolder = clonedAtom.getDexFolder();
        this.atomMetadataFile = clonedAtom.getAtomMetadataFile();
        this.libFolder = clonedAtom.getLibFolder();
        this.javaResFolder = clonedAtom.getJavaResFolder();
        this.resourcePackage = clonedAtom.getResourcePackage();
    }

    public String getProjectVariant() {
        return this.variant;
    }

    public File getBundle() {
        return this.bundle;
    }

    public File getFolder() {
        return this.folder;
    }

    public List<? extends AndroidAtom> getAtomDependencies() {
        return this.androidAtoms;
    }

    public List<? extends AndroidLibrary> getLibraryDependencies() {
        return this.androidLibraries;
    }

    public Collection<? extends JavaLibrary> getJavaDependencies() {
        return this.javaLibraries;
    }

    public File getManifest() {
        return this.manifest;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public File getResFolder() {
        return this.resFolder;
    }

    public File getAssetsFolder() {
        return this.assetsFolder;
    }

    public String getAtomName() {
        return this.atomName;
    }

    public File getDexFolder() {
        return this.dexFolder;
    }

    public File getAtomMetadataFile() {
        return this.atomMetadataFile;
    }

    public File getLibFolder() {
        return this.libFolder;
    }

    public File getJavaResFolder() {
        return this.javaResFolder;
    }

    public File getResourcePackage() {
        return this.resourcePackage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndroidAtomImpl that = (AndroidAtomImpl)o;
        return Objects.equal((Object)this.variant, (Object)that.variant) && Objects.equal((Object)this.bundle, (Object)that.bundle) && Objects.equal((Object)this.folder, (Object)that.folder) && Objects.equal((Object)this.manifest, (Object)that.manifest) && Objects.equal((Object)this.jarFile, (Object)that.jarFile) && Objects.equal((Object)this.resFolder, (Object)that.resFolder) && Objects.equal((Object)this.assetsFolder, (Object)that.assetsFolder) && Objects.equal((Object)this.atomName, (Object)that.atomName) && Objects.equal((Object)this.dexFolder, (Object)that.dexFolder) && Objects.equal((Object)this.atomMetadataFile, (Object)that.atomMetadataFile) && Objects.equal((Object)this.libFolder, (Object)that.libFolder) && Objects.equal((Object)this.javaResFolder, (Object)that.javaResFolder) && Objects.equal((Object)this.resourcePackage, (Object)that.resourcePackage) && Objects.equal(this.androidAtoms, that.androidAtoms) && Objects.equal(this.androidLibraries, that.androidLibraries) && Objects.equal(this.javaLibraries, that.javaLibraries);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.variant, this.bundle, this.folder, this.manifest, this.jarFile, this.resFolder, this.assetsFolder, this.atomName, this.dexFolder, this.atomMetadataFile, this.libFolder, this.javaResFolder, this.resourcePackage, this.androidAtoms, this.androidLibraries, this.javaLibraries});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("project", (Object)this.getProject()).add("variant", (Object)this.variant).add("requestedCoordinates", (Object)this.getRequestedCoordinates()).add("resolvedCoordinates", (Object)this.getResolvedCoordinates()).add("bundle", (Object)this.bundle).add("folder", (Object)this.folder).add("manifest", (Object)this.manifest).add("jarFile", (Object)this.jarFile).add("resFolder", (Object)this.resFolder).add("assetsFolder", (Object)this.assetsFolder).add("atomName", (Object)this.atomName).add("dexFolder", (Object)this.dexFolder).add("atomMetadataFile", (Object)this.atomMetadataFile).add("libFolder", (Object)this.libFolder).add("javaResFolder", (Object)this.javaResFolder).add("resourcePackage", (Object)this.resourcePackage).add("androidAtoms", this.androidAtoms).add("androidLibraries", this.androidLibraries).add("javaLibraries", this.javaLibraries).add("super", (Object)super.toString()).toString();
    }
}

