/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.ide.AndroidAtomImpl;
import com.android.build.gradle.internal.ide.AndroidLibraryImpl;
import com.android.build.gradle.internal.ide.JavaLibraryImpl;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.dependency.level2.AndroidDependency;
import com.android.builder.dependency.level2.AtomDependency;
import com.android.builder.dependency.level2.Dependency;
import com.android.builder.dependency.level2.DependencyContainer;
import com.android.builder.dependency.level2.DependencyNode;
import com.android.builder.dependency.level2.JavaDependency;
import com.android.builder.model.AndroidAtom;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.caching.CreatingCache;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class DependenciesConverter {
    private static final CreatingCache<DependencyItem<AtomDependency>, AndroidAtomImpl> sAtomCache = new CreatingCache(DependenciesConverter::createSerializableAndroidAtom);
    private static final CreatingCache<DependencyItem<AndroidDependency>, AndroidLibraryImpl> sLibCache = new CreatingCache(DependenciesConverter::createSerializableAndroidLibrary);
    private static final CreatingCache<DependencyItem<JavaDependency>, JavaLibraryImpl> sJarCache = new CreatingCache(DependenciesConverter::createSerializableJavaLibrary);
    private static final DependenciesImpl EMPTY = new DependenciesImpl((List<AndroidAtom>)ImmutableList.of(), (List<AndroidLibrary>)ImmutableList.of(), (List<JavaLibrary>)ImmutableList.of(), (List<String>)ImmutableList.of(), null);
    private DependencyContainer dependencyContainer;
    private DependencyItemFactory factory;

    DependenciesConverter() {
    }

    public static void clearCaches() {
        sAtomCache.clear();
        sLibCache.clear();
        sJarCache.clear();
    }

    static DependenciesImpl getEmpty() {
        return EMPTY;
    }

    static DependenciesImpl cloneDependenciesForJavaArtifacts(Dependencies dependencies) {
        if (dependencies == EMPTY) {
            return EMPTY;
        }
        List<AndroidAtom> atoms = Collections.emptyList();
        List<AndroidLibrary> libraries = Collections.emptyList();
        ArrayList javaLibraries = Lists.newArrayList((Iterable)dependencies.getJavaLibraries());
        List<String> projects = Collections.emptyList();
        return new DependenciesImpl(atoms, libraries, javaLibraries, projects, dependencies.getBaseAtom());
    }

    DependenciesImpl cloneDependencies(DependencyContainer dependencyContainer, VariantConfiguration variantConfiguration, AndroidBuilder androidBuilder) {
        File supportJar;
        this.dependencyContainer = dependencyContainer;
        this.factory = new DependencyItemFactory(dependencyContainer);
        ImmutableList directJavaDeps = dependencyContainer.getDirectJavaDependencies();
        List<String> clonedProjects = directJavaDeps.stream().filter(javaDependency -> javaDependency.getProjectPath() != null).map(Dependency::getProjectPath).collect(Collectors.toList());
        ImmutableList dependencyNodes = dependencyContainer.getDependencies();
        LinkedHashSet clonedJavaLibraries = Sets.newLinkedHashSet();
        this.cloneJavaLibraries((List<DependencyNode>)dependencyNodes, clonedJavaLibraries);
        ImmutableList atomDependencies = dependencyContainer.getAllAtomDependencies();
        List<AndroidAtom> clonedAndroidAtoms = this.clonedAndroidAtoms((List<AtomDependency>)atomDependencies);
        List<AndroidLibrary> clonedAndroidLibraries = this.cloneAndroidLibraries((List<DependencyNode>)dependencyNodes);
        if (variantConfiguration.getRenderscriptSupportModeEnabled() && (supportJar = androidBuilder.getRenderScriptSupportJar()) != null) {
            clonedJavaLibraries.add(new JavaLibraryImpl(supportJar, null, (List<JavaLibrary>)ImmutableList.of(), null, (MavenCoordinates)new MavenCoordinatesImpl("com.android.support", "renderscript", androidBuilder.getTargetInfo().getBuildTools().getRevision().toString()), false, false));
        }
        AndroidAtom baseAtom = null;
        if (dependencyContainer.getBaseAtom() != null) {
            baseAtom = (AndroidAtom)sAtomCache.get(this.factory.create(dependencyContainer.getBaseAtom()));
        }
        return new DependenciesImpl(clonedAndroidAtoms, clonedAndroidLibraries, new ArrayList<JavaLibrary>(clonedJavaLibraries), clonedProjects, baseAtom);
    }

    private void cloneJavaLibraries(List<DependencyNode> nodes, Set<JavaLibrary> outLibraries) {
        for (DependencyNode node : nodes) {
            Dependency dependency = (Dependency)this.dependencyContainer.getDependencyMap().get(node.getAddress());
            if (dependency.getProjectPath() != null) continue;
            switch (node.getNodeType()) {
                case JAVA: {
                    JavaDependency javaDep = (JavaDependency)dependency;
                    outLibraries.add((JavaLibrary)sJarCache.get(this.factory.create(javaDep)));
                }
                case ANDROID: {
                    this.cloneJavaLibraries((List<DependencyNode>)node.getDependencies(), outLibraries);
                    break;
                }
            }
        }
    }

    private List<AndroidAtom> clonedAndroidAtoms(List<AtomDependency> atomDependencies) {
        return atomDependencies.stream().map(dep -> (AndroidAtomImpl)sAtomCache.get(this.factory.create(dep))).collect(Collectors.toList());
    }

    private List<AndroidLibrary> cloneAndroidLibraries(List<DependencyNode> nodes) {
        ArrayList results = Lists.newArrayListWithCapacity((int)nodes.size());
        for (DependencyNode node : nodes) {
            AndroidDependency androidDependency;
            AndroidLibrary lib;
            if (node.getNodeType() != DependencyNode.NodeType.ANDROID || (lib = (AndroidLibrary)sLibCache.get(this.factory.create(androidDependency = (AndroidDependency)this.dependencyContainer.getDependencyMap().get(node.getAddress()), node))) == null) continue;
            results.add(lib);
        }
        return Lists.newArrayList((Iterable)results);
    }

    private static AndroidAtomImpl createSerializableAndroidAtom(DependencyItem<AtomDependency> dependencyItem) {
        return new AndroidAtomImpl((AtomDependency)((DependencyItem)dependencyItem).dependency);
    }

    private static AndroidLibraryImpl createSerializableAndroidLibrary(DependencyItem<AndroidDependency> dependencyItem) {
        AndroidDependency androidDependency = (AndroidDependency)((DependencyItem)dependencyItem).dependency;
        DependencyNode dependencyNode = (DependencyNode)dependencyItem.getOther();
        ImmutableList deps = dependencyNode.getDependencies();
        ArrayList clonedDeps = Lists.newArrayListWithCapacity((int)deps.size());
        for (DependencyNode childNode : deps) {
            AndroidDependency childDependency;
            DependencyItem<AndroidDependency> childDepItem;
            AndroidLibrary clonedLib;
            if (childNode.getNodeType() != DependencyNode.NodeType.ANDROID || (clonedLib = (AndroidLibrary)sLibCache.get(childDepItem = dependencyItem.create(childDependency = (AndroidDependency)dependencyItem.getMap().get(childNode.getAddress()), childNode))) == null) continue;
            clonedDeps.add(clonedLib);
        }
        Collection<File> localJarOverride = DependenciesConverter.findLocalJar(androidDependency);
        return new AndroidLibraryImpl(androidDependency, dependencyItem.isProvided(), dependencyItem.isSkipped(), clonedDeps, (Collection<JavaLibrary>)ImmutableList.of(), localJarOverride);
    }

    private static JavaLibraryImpl createSerializableJavaLibrary(DependencyItem<JavaDependency> dependencyItem) {
        JavaDependency javaDependency = (JavaDependency)((DependencyItem)dependencyItem).dependency;
        return new JavaLibraryImpl(javaDependency.getArtifactFile(), javaDependency.getProjectPath(), (List<JavaLibrary>)ImmutableList.of(), null, javaDependency.getCoordinates(), dependencyItem.isSkipped(), dependencyItem.isProvided());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<File> findLocalJar(AndroidDependency dependency) {
        File explodedFolder = dependency.getExtractedFolder();
        if (explodedFolder.isDirectory()) {
            return dependency.getLocalJars();
        }
        File aarFile = dependency.getArtifactFile();
        if (aarFile.isFile()) {
            ArrayList jarList = Lists.newArrayList();
            File jarsFolder = new File(explodedFolder, "jars");
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(aarFile);
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry zipEntry = e.nextElement();
                    String name = zipEntry.getName();
                    if (!name.startsWith("libs/") || !name.endsWith(".jar")) continue;
                    jarList.add(new File(jarsFolder, name.replace('/', File.separatorChar)));
                }
                ArrayList arrayList = jarList;
                return arrayList;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return Collections.emptyList();
    }

    static final class DependenciesImpl
    implements Dependencies,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<AndroidAtom> atoms;
        private final List<AndroidLibrary> libraries;
        private final List<JavaLibrary> javaLibraries;
        private final List<String> projects;
        private final AndroidAtom baseAtom;

        DependenciesImpl(List<AndroidAtom> atoms, List<AndroidLibrary> libraries, List<JavaLibrary> javaLibraries, List<String> projects, AndroidAtom baseAtom) {
            this.atoms = atoms;
            this.libraries = libraries;
            this.javaLibraries = javaLibraries;
            this.projects = projects;
            this.baseAtom = baseAtom;
        }

        public Collection<AndroidAtom> getAtoms() {
            return this.atoms;
        }

        public Collection<AndroidLibrary> getLibraries() {
            return this.libraries;
        }

        public Collection<JavaLibrary> getJavaLibraries() {
            return this.javaLibraries;
        }

        public List<String> getProjects() {
            return this.projects;
        }

        public AndroidAtom getBaseAtom() {
            return this.baseAtom;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("libraries", this.libraries).add("javaLibraries", this.javaLibraries).add("projects", this.projects).add("atoms", this.atoms).add("baseAtom", (Object)this.baseAtom).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependenciesImpl that = (DependenciesImpl)o;
            return Objects.equals(this.atoms, that.atoms) && Objects.equals(this.libraries, that.libraries) && Objects.equals(this.javaLibraries, that.javaLibraries) && Objects.equals(this.projects, that.projects) && Objects.equals(this.baseAtom, that.baseAtom);
        }

        public int hashCode() {
            return Objects.hash(this.atoms, this.libraries, this.javaLibraries, this.projects, this.baseAtom);
        }
    }

    private static final class DependencyItem<T extends Dependency> {
        private final T dependency;
        private final DependencyItemFactory factory;
        private final Object other;

        private DependencyItem(T dependency, DependencyItemFactory factory) {
            this(dependency, null, factory);
        }

        private DependencyItem(T dependency, Object other, DependencyItemFactory factory) {
            this.dependency = dependency;
            this.other = other;
            this.factory = factory;
        }

        boolean isSkipped() {
            return this.factory.dependencyContainer.isSkipped(this.dependency);
        }

        boolean isProvided() {
            return this.factory.dependencyContainer.isProvided(this.dependency);
        }

        <N> N getOther() {
            return (N)this.other;
        }

        <U extends Dependency> DependencyItem<U> create(U dependency) {
            return this.factory.create(dependency);
        }

        <U extends Dependency> DependencyItem<U> create(U dependency, Object other) {
            return this.factory.create(dependency, other);
        }

        Map<Object, Dependency> getMap() {
            return this.factory.dependencyContainer.getDependencyMap();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependencyItem that = (DependencyItem)o;
            return Objects.equals(this.dependency, that.dependency) && Objects.equals(this.isSkipped(), that.isSkipped()) && Objects.equals(this.isProvided(), that.isProvided());
        }

        public int hashCode() {
            return Objects.hash(this.dependency, this.isSkipped(), this.isProvided());
        }

        /* synthetic */ DependencyItem(Dependency x0, DependencyItemFactory x1, 1 x2) {
            this(x0, x1);
        }

        /* synthetic */ DependencyItem(Dependency x0, Object x1, DependencyItemFactory x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    private static class DependencyItemFactory {
        private final DependencyContainer dependencyContainer;

        private DependencyItemFactory(DependencyContainer dependencyContainer) {
            this.dependencyContainer = dependencyContainer;
        }

        <T extends Dependency> DependencyItem<T> create(T library) {
            return new DependencyItem(library, this, null);
        }

        <T extends Dependency> DependencyItem<T> create(T library, Object other) {
            return new DependencyItem(library, other, this, null);
        }
    }
}

