/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.dependency.ConfigurationDependencyGraphs;
import com.android.build.gradle.internal.dependency.DependencyContainerImpl;
import com.android.build.gradle.internal.ide.DependenciesConverter;
import com.android.build.gradle.internal.ide.level2.AndroidLibraryImpl;
import com.android.build.gradle.internal.ide.level2.EmptyDependencyGraphs;
import com.android.build.gradle.internal.ide.level2.FullDependencyGraphsImpl;
import com.android.build.gradle.internal.ide.level2.GraphItemImpl;
import com.android.build.gradle.internal.ide.level2.JavaLibraryImpl;
import com.android.build.gradle.internal.ide.level2.ModuleLibraryImpl;
import com.android.build.gradle.internal.ide.level2.SimpleDependencyGraphsImpl;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.dependency.level2.AndroidDependency;
import com.android.builder.dependency.level2.Dependency;
import com.android.builder.dependency.level2.DependencyContainer;
import com.android.builder.dependency.level2.DependencyNode;
import com.android.builder.dependency.level2.JavaDependency;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.Library;
import com.android.ide.common.caching.CreatingCache;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DependenciesLevel2Converter {
    private static final CreatingCache<Dependency, Library> sLibraryCache = new CreatingCache(DependenciesLevel2Converter::instantiateLibrary);
    private static final CreatingCache<DependencyNode, GraphItemImpl> sGraphItemCache = new CreatingCache(DependenciesLevel2Converter::createCachedGraphItem);
    private static final CreatingCache<Pair<File, String>, Pair<Dependency, DependencyNode>> sRSCache = new CreatingCache(DependenciesLevel2Converter::createRenderscriptSupport);
    private static final DependencyGraphs EMPTY = new EmptyDependencyGraphs();

    public static void clearCaches() {
        sLibraryCache.clear();
        sGraphItemCache.clear();
        sRSCache.clear();
    }

    public static DependencyGraphs getEmpty() {
        return EMPTY;
    }

    public static Map<String, Library> getGlobalLibMap() {
        List values = sLibraryCache.values();
        HashMap map = Maps.newHashMapWithExpectedSize((int)values.size());
        for (Library library : values) {
            map.put(library.getArtifactAddress(), library);
        }
        return map;
    }

    public static DependencyGraphs cloneGraphForJavaArtifacts(DependencyGraphs dependencyGraphs) {
        if (dependencyGraphs == EMPTY) {
            return EMPTY;
        }
        ConfigurationDependencyGraphs graph = (ConfigurationDependencyGraphs)dependencyGraphs;
        for (Dependency dependency : graph.getDependencyObjects()) {
            sLibraryCache.get((Object)dependency);
        }
        return new SimpleDependencyGraphsImpl(dependencyGraphs.getCompileDependencies());
    }

    public static DependencyGraphs cloneGraph(DependencyContainer compileContainer, DependencyContainer packageContainer, VariantConfiguration variantConfiguration, AndroidBuilder androidBuilder) {
        ImmutableList nodes = compileContainer.getDependencies();
        ArrayList compileItems = Lists.newArrayListWithCapacity((int)nodes.size());
        for (DependencyNode node : nodes) {
            compileItems.add(sGraphItemCache.get((Object)node));
        }
        for (Dependency dependency : compileContainer.getAllDependencies()) {
            sLibraryCache.get((Object)dependency);
        }
        Pair<Dependency, DependencyNode> renderscriptDependency = DependenciesLevel2Converter.handleRenderscriptSupport(variantConfiguration, androidBuilder);
        if (renderscriptDependency != null) {
            sLibraryCache.get(renderscriptDependency.getFirst());
            compileItems.add(sGraphItemCache.get(renderscriptDependency.getSecond()));
        }
        if (packageContainer == DependencyContainerImpl.empty()) {
            return new SimpleDependencyGraphsImpl(compileItems);
        }
        nodes = packageContainer.getDependencies();
        ArrayList packageItems = Lists.newArrayListWithCapacity((int)nodes.size());
        for (DependencyNode node : nodes) {
            packageItems.add(sGraphItemCache.get((Object)node));
        }
        List<String> skippedList = ((DependencyContainerImpl)packageContainer).getSkippedList();
        ImmutableList packageDependencies = skippedList.isEmpty() ? packageContainer.getAllDependencies() : packageContainer.getDependencyMap().values();
        for (Dependency dependency : packageDependencies) {
            sLibraryCache.get((Object)dependency);
        }
        if (renderscriptDependency != null) {
            packageItems.add(sGraphItemCache.get(renderscriptDependency.getSecond()));
        }
        return new FullDependencyGraphsImpl(compileItems, packageItems, ((DependencyContainerImpl)compileContainer).getProvidedList(), skippedList);
    }

    private static Library instantiateLibrary(Dependency dependency) {
        Library library;
        if (dependency.getProjectPath() != null) {
            library = new ModuleLibraryImpl(dependency);
        } else if (dependency instanceof AndroidDependency) {
            AndroidDependency androidDependency = (AndroidDependency)dependency;
            library = new AndroidLibraryImpl(androidDependency, DependenciesConverter.findLocalJar(androidDependency));
        } else if (dependency instanceof JavaDependency) {
            library = new JavaLibraryImpl((JavaDependency)dependency);
        } else {
            throw new RuntimeException("unknown Dependency instance");
        }
        return library;
    }

    private static GraphItemImpl createCachedGraphItem(DependencyNode dependencyNode) {
        ImmutableList children = dependencyNode.getDependencies();
        ArrayList clonedChildren = Lists.newArrayListWithCapacity((int)children.size());
        for (DependencyNode child : children) {
            clonedChildren.add(sGraphItemCache.get((Object)child));
        }
        return new GraphItemImpl(dependencyNode.getAddress().toString(), clonedChildren);
    }

    private static Pair<Dependency, DependencyNode> createRenderscriptSupport(Pair<File, String> pair) {
        JavaDependency dependency = new JavaDependency((File)pair.getFirst(), (MavenCoordinates)new MavenCoordinatesImpl("com.android.support", "renderscript", (String)pair.getSecond()), "renderscript-" + (String)pair.getSecond(), null);
        return Pair.of((Object)dependency, (Object)new DependencyNode(dependency.getAddress(), DependencyNode.NodeType.JAVA, (List)ImmutableList.of(), null));
    }

    private static Pair<Dependency, DependencyNode> handleRenderscriptSupport(VariantConfiguration variantConfiguration, AndroidBuilder androidBuilder) {
        File supportJar;
        if (variantConfiguration.getRenderscriptSupportModeEnabled() && (supportJar = androidBuilder.getRenderScriptSupportJar()) != null) {
            return (Pair)sRSCache.get((Object)Pair.of((Object)supportJar, (Object)androidBuilder.getTargetInfo().getBuildTools().getRevision().toString()));
        }
        return null;
    }
}

