/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.ide.BaseArtifactImpl;
import com.android.build.gradle.internal.ide.DependenciesConverter;
import com.android.build.gradle.internal.ide.DependenciesLevel2Converter;
import com.android.build.gradle.internal.ide.SourceProviderImpl;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.level2.DependencyGraphs;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public final class JavaArtifactImpl
extends BaseArtifactImpl
implements JavaArtifact,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<String> ideSetupTaskNames;
    private final File mockablePlatformJar;

    public static JavaArtifactImpl clone(JavaArtifact javaArtifact) {
        SourceProvider variantSP = javaArtifact.getVariantSourceProvider();
        SourceProvider flavorsSP = javaArtifact.getMultiFlavorSourceProvider();
        return new JavaArtifactImpl(javaArtifact.getName(), javaArtifact.getAssembleTaskName(), javaArtifact.getCompileTaskName(), javaArtifact.getIdeSetupTaskNames(), javaArtifact.getGeneratedSourceFolders(), javaArtifact.getClassesFolder(), javaArtifact.getJavaResourcesFolder(), javaArtifact.getMockablePlatformJar(), DependenciesConverter.cloneDependenciesForJavaArtifacts(javaArtifact.getDependencies()), DependenciesLevel2Converter.cloneGraphForJavaArtifacts(javaArtifact.getDependencyGraphs()), variantSP != null ? new SourceProviderImpl(variantSP) : null, flavorsSP != null ? new SourceProviderImpl(flavorsSP) : null);
    }

    public JavaArtifactImpl(String name, String assembleTaskName, String compileTaskName, Iterable<String> ideSetupTaskNames, Collection<File> generatedSourceFolders, File classesFolder, File javaResourcesFolder, File mockablePlatformJar, Dependencies compileDependencies, DependencyGraphs dependencyGraphs, SourceProvider variantSourceProvider, SourceProvider multiFlavorSourceProviders) {
        super(name, assembleTaskName, compileTaskName, classesFolder, javaResourcesFolder, compileDependencies, dependencyGraphs, variantSourceProvider, multiFlavorSourceProviders, generatedSourceFolders);
        this.ideSetupTaskNames = Sets.newHashSet(ideSetupTaskNames);
        this.mockablePlatformJar = mockablePlatformJar;
    }

    public Set<String> getIdeSetupTaskNames() {
        return this.ideSetupTaskNames;
    }

    public File getMockablePlatformJar() {
        return this.mockablePlatformJar;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaArtifactImpl that = (JavaArtifactImpl)o;
        return Objects.equals(this.ideSetupTaskNames, that.ideSetupTaskNames) && Objects.equals(this.mockablePlatformJar, that.mockablePlatformJar);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.ideSetupTaskNames, this.mockablePlatformJar);
    }
}

