/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;

public final class OutputFileImpl
implements OutputFile,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Collection<FilterData> filters;
    private final Collection<String> filterTypes;
    private final String type;
    private final File outputFile;

    public OutputFileImpl(Collection<FilterData> filters, String type, File file) {
        this.filters = filters;
        this.type = type;
        ImmutableList.Builder filterTypes = ImmutableList.builder();
        for (FilterData filter : filters) {
            filterTypes.add((Object)filter.getFilterType());
        }
        this.filterTypes = filterTypes.build();
        this.outputFile = file;
    }

    public String getOutputType() {
        return this.type;
    }

    public Collection<String> getFilterTypes() {
        return this.filterTypes;
    }

    public Collection<FilterData> getFilters() {
        return this.filters;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutputFileImpl that = (OutputFileImpl)o;
        return Objects.equals(this.filters, that.filters) && Objects.equals(this.filterTypes, that.filterTypes) && Objects.equals(this.type, that.type) && Objects.equals(this.outputFile, that.outputFile);
    }

    public int hashCode() {
        return Objects.hash(this.filters, this.filterTypes, this.type, this.outputFile);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filters", this.filters).add("filterTypes", this.filterTypes).add("type", (Object)this.type).add("outputFile", (Object)this.outputFile).toString();
    }
}

