/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunBuildMode;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.InstantRunArtifact;
import com.google.wireless.android.sdk.stats.InstantRunStatus;
import org.jetbrains.annotations.Nullable;

public class InstantRunAnalyticsHelper {
    public static InstantRunStatus generateAnalyticsProto(InstantRunBuildContext instantRunBuildContext) {
        InstantRunStatus.Builder builder = InstantRunStatus.newBuilder();
        builder.setBuildMode(InstantRunAnalyticsHelper.convert(instantRunBuildContext.getBuildMode()));
        builder.setPatchingPolicy(InstantRunAnalyticsHelper.convert(instantRunBuildContext.getPatchingPolicy()));
        builder.setVerifierStatus(InstantRunAnalyticsHelper.convert(instantRunBuildContext.getVerifierResult()));
        InstantRunBuildContext.Build last = instantRunBuildContext.getLastBuild();
        if (last != null) {
            for (InstantRunBuildContext.Artifact artifact : last.getArtifacts()) {
                builder.addArtifact(InstantRunArtifact.newBuilder().setType(InstantRunAnalyticsHelper.convert(artifact.getType())));
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static InstantRunStatus.BuildMode convert(InstantRunBuildMode mode) {
        switch (mode) {
            case HOT_WARM: {
                return InstantRunStatus.BuildMode.HOT_WARM;
            }
            case COLD: {
                return InstantRunStatus.BuildMode.COLD;
            }
            case FULL: {
                return InstantRunStatus.BuildMode.FULL;
            }
        }
        return InstantRunStatus.BuildMode.UNKNOWN_BUILD_MODE;
    }

    @VisibleForTesting
    static InstantRunStatus.PatchingPolicy convert(@Nullable InstantRunPatchingPolicy policy) {
        if (policy == null) {
            return InstantRunStatus.PatchingPolicy.UNKNOWN_PATCHING_POLICY;
        }
        switch (policy) {
            case PRE_LOLLIPOP: {
                return InstantRunStatus.PatchingPolicy.PRE_LOLLIPOP;
            }
            case MULTI_DEX: {
                return InstantRunStatus.PatchingPolicy.MULTI_DEX;
            }
            case MULTI_APK: {
                return InstantRunStatus.PatchingPolicy.MULTI_APK;
            }
        }
        return InstantRunStatus.PatchingPolicy.UNKNOWN_PATCHING_POLICY;
    }

    @VisibleForTesting
    static InstantRunStatus.VerifierStatus convert(InstantRunVerifierStatus status) {
        try {
            return InstantRunStatus.VerifierStatus.valueOf((String)status.toString());
        }
        catch (IllegalArgumentException ignored) {
            return InstantRunStatus.VerifierStatus.UNKNOWN_VERIFIER_STATUS;
        }
    }

    @VisibleForTesting
    static InstantRunArtifact.Type convert(FileType type) {
        switch (type) {
            case MAIN: {
                return InstantRunArtifact.Type.MAIN;
            }
            case SPLIT_MAIN: {
                return InstantRunArtifact.Type.SPLIT_MAIN;
            }
            case RELOAD_DEX: {
                return InstantRunArtifact.Type.RELOAD_DEX;
            }
            case DEX: {
                return InstantRunArtifact.Type.DEX;
            }
            case SPLIT: {
                return InstantRunArtifact.Type.SPLIT;
            }
            case RESOURCES: {
                return InstantRunArtifact.Type.RESOURCES;
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)type));
    }

    private InstantRunAnalyticsHelper() {
    }
}

