/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.api.transform.Transform;
import com.google.common.base.CaseFormat;
import com.google.wireless.android.sdk.stats.GradleTaskExecution;
import com.google.wireless.android.sdk.stats.GradleTransformExecution;

public class AnalyticsUtil {
    public static GradleTransformExecution.Type getTransformType(Class<? extends Transform> taskClass) {
        try {
            return GradleTransformExecution.Type.valueOf((String)AnalyticsUtil.getPotentialTransformTypeName(taskClass));
        }
        catch (IllegalArgumentException ignored) {
            return GradleTransformExecution.Type.UNKNOWN_TRANSFORM_TYPE;
        }
    }

    static String getPotentialTransformTypeName(Class<?> taskClass) {
        String taskImpl = taskClass.getSimpleName();
        if (taskImpl.endsWith("Transform")) {
            taskImpl = taskImpl.substring(0, taskImpl.length() - "Transform".length());
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, taskImpl);
    }

    public static GradleTaskExecution.Type getTaskExecutionType(Class<?> taskClass) {
        try {
            return GradleTaskExecution.Type.valueOf((String)AnalyticsUtil.getPotentialTaskExecutionTypeName(taskClass));
        }
        catch (IllegalArgumentException ignored) {
            return GradleTaskExecution.Type.UNKNOWN_TASK_TYPE;
        }
    }

    static String getPotentialTaskExecutionTypeName(Class<?> taskClass) {
        String taskImpl = taskClass.getSimpleName();
        if (taskImpl.endsWith("_Decorated")) {
            taskImpl = taskImpl.substring(0, taskImpl.length() - "_Decorated".length());
        }
        if (taskImpl.endsWith("Task")) {
            taskImpl = taskImpl.substring(0, taskImpl.length() - "Task".length());
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, taskImpl);
    }
}

