/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.profile.RecordingBuildListener;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.ProcessProfileWriterFactory;
import com.android.builder.profile.ProfileRecordWriter;
import com.android.utils.ILogger;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.initialization.BuildCompletionListener;

public final class ProfilerInitializer {
    private static final Object LOCK = new Object();
    private static volatile RecordingBuildListener recordingBuildListener;

    private ProfilerInitializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Project project) {
        Object object = LOCK;
        synchronized (object) {
            if (recordingBuildListener != null) {
                return;
            }
            ProcessProfileWriterFactory.initialize((File)project.getRootProject().getProjectDir(), (String)project.getGradle().getGradleVersion(), (ILogger)new LoggerWrapper(project.getLogger()), (File)new File(project.getRootProject().getBuildDir(), "android-profile"));
            recordingBuildListener = new RecordingBuildListener((ProfileRecordWriter)ProcessProfileWriter.get());
            project.getGradle().addListener((Object)recordingBuildListener);
        }
        project.getGradle().addListener((Object)new ProfileShutdownListener(project));
    }

    private static final class ProfileShutdownListener
    implements BuildCompletionListener {
        private final Project project;

        ProfileShutdownListener(Project project) {
            this.project = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed() {
            try {
                Object object = LOCK;
                synchronized (object) {
                    if (recordingBuildListener != null) {
                        this.project.getGradle().removeListener((Object)recordingBuildListener);
                        recordingBuildListener = null;
                        ProcessProfileWriterFactory.shutdown();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

