/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.publishing;

import com.android.build.gradle.internal.tasks.FileSupplier;
import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class AndroidArtifacts {
    public static final String ARTIFACT_TYPE = "artifactType";
    public static final String TYPE_AAR = "aar";
    public static final String TYPE_APK = "apk";
    public static final String TYPE_ATOM_BUNDLE = "atombundle";

    public static PublishArtifact getAarArtifact(final AbstractArchiveTask task, String classifier) {
        return new AndroidArtifact(task.getBaseName(), TYPE_AAR, TYPE_AAR, classifier, new FileSupplier(){

            @Override
            public Task getTask() {
                return task;
            }

            public File get() {
                return task.getArchivePath();
            }
        });
    }

    public static PublishArtifact buildArtifact(String name, String type, String classifier, FileSupplier outputFileSupplier) {
        return new AndroidArtifact(name, type, type, classifier, outputFileSupplier);
    }

    public static PublishArtifact buildApkArtifact(String name, String classifier, FileSupplier outputFileSupplier) {
        return new AndroidArtifact(name, TYPE_APK, TYPE_APK, classifier, outputFileSupplier);
    }

    public static PublishArtifact buildAtomArtifact(String name, String classifier, FileSupplier outputFileSupplier) {
        return new AndroidArtifact(name, TYPE_ATOM_BUNDLE, TYPE_ATOM_BUNDLE, classifier, outputFileSupplier);
    }

    public static PublishArtifact buildManifestArtifact(String name, FileSupplier outputFileSupplier) {
        return new AndroidArtifact(name, "xml", "xml", null, outputFileSupplier);
    }

    public static PublishArtifact buildMappingArtifact(String name, FileSupplier outputFileSupplier) {
        return new AndroidArtifact(name, "map", "map", null, outputFileSupplier);
    }

    public static PublishArtifact buildMetadataArtifact(String name, FileSupplier outputFileSupplier) {
        return new AndroidArtifact(name, "mtd", "mtd", null, outputFileSupplier);
    }

    public static void publish(final Project project, String publishConfigName, File file, final String builtBy, final String type) {
        project.getArtifacts().add(publishConfigName, (Object)file, new Closure(project){

            public Object doCall(ConfigurablePublishArtifact artifact) {
                artifact.setType(type);
                artifact.builtBy(new Object[]{project.getTasks().getByName(builtBy)});
                return null;
            }
        });
    }

    private static class AndroidArtifact
    implements PublishArtifact {
        private final String name;
        private final String extension;
        private final String type;
        private final String classifier;
        private final Supplier<File> outputFileSupplier;
        private final TaskDependency taskDependency;

        private AndroidArtifact(String name, String extension, String type, String classifier, FileSupplier outputFileSupplier) {
            this.name = name;
            this.extension = extension;
            this.type = type;
            this.classifier = classifier;
            this.outputFileSupplier = outputFileSupplier;
            this.taskDependency = new DefaultTaskDependency(outputFileSupplier.getTask());
        }

        public String getName() {
            return this.name;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public File getFile() {
            return (File)this.outputFileSupplier.get();
        }

        public String getExtension() {
            return this.extension;
        }

        public String getType() {
            return this.type;
        }

        public Date getDate() {
            return null;
        }

        public TaskDependency getBuildDependencies() {
            return this.taskDependency;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("classifier", (Object)this.classifier).add("outputFile", this.outputFileSupplier.get()).add("taskDependency", (Object)this.taskDependency).toString();
        }

        private static final class DefaultTaskDependency
        implements TaskDependency {
            private final Set<Task> tasks;

            DefaultTaskDependency(Task task) {
                this.tasks = Collections.singleton(task);
            }

            public Set<? extends Task> getDependencies(Task task) {
                return this.tasks;
            }
        }
    }
}

