/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.dependency.level2.AtomDependency;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.ApiVersion;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Set;
import org.gradle.api.Project;

public class AtomPackagingScope
implements PackagingScope {
    protected final VariantOutputScope variantOutputScope;
    protected final VariantScope variantScope;
    protected final GlobalScope globalScope;
    protected final AtomDependency atomDependency;

    public AtomPackagingScope(VariantOutputScope variantOutputScope, AtomDependency atomDependency) {
        this.variantOutputScope = variantOutputScope;
        this.variantScope = variantOutputScope.getVariantScope();
        this.globalScope = this.variantScope.getGlobalScope();
        this.atomDependency = atomDependency;
    }

    @Override
    public AndroidBuilder getAndroidBuilder() {
        return this.globalScope.getAndroidBuilder();
    }

    @Override
    public File getFinalResourcesFile() {
        return this.variantOutputScope.getProcessResourcePackageOutputFile(this.atomDependency);
    }

    @Override
    public String getFullVariantName() {
        return this.variantScope.getFullVariantName();
    }

    @Override
    public ApiVersion getMinSdkVersion() {
        return this.variantScope.getMinSdkVersion();
    }

    @Override
    public InstantRunBuildContext getInstantRunBuildContext() {
        return this.variantScope.getInstantRunBuildContext();
    }

    @Override
    public File getInstantRunSupportDir() {
        return this.variantScope.getInstantRunSupportDir();
    }

    @Override
    public File getIncrementalDir(String name) {
        return this.variantScope.getIncrementalDir(name);
    }

    @Override
    public Set<File> getDexFolders() {
        return ImmutableSet.of((Object)this.variantScope.getDexOutputFolder(this.atomDependency));
    }

    @Override
    public Set<File> getJavaResources() {
        return ImmutableSet.of((Object)this.atomDependency.getJavaResFolder());
    }

    @Override
    public File getAssetsDir() {
        return this.atomDependency.getAssetsFolder();
    }

    @Override
    public Set<File> getJniFolders() {
        return ImmutableSet.of((Object)this.atomDependency.getLibFolder());
    }

    @Override
    public SplitHandlingPolicy getSplitHandlingPolicy() {
        return SplitHandlingPolicy.PRE_21_POLICY;
    }

    @Override
    public Set<String> getAbiFilters() {
        return ImmutableSet.of();
    }

    @Override
    public ApkOutputFile getMainOutputFile() {
        return this.variantOutputScope.getMainOutputFile();
    }

    @Override
    public Set<String> getSupportedAbis() {
        return null;
    }

    @Override
    public boolean isDebuggable() {
        return ((CoreBuildType)this.variantScope.getVariantConfiguration().getBuildType()).isDebuggable();
    }

    @Override
    public boolean isJniDebuggable() {
        return ((CoreBuildType)this.variantScope.getVariantConfiguration().getBuildType()).isJniDebuggable();
    }

    @Override
    public CoreSigningConfig getSigningConfig() {
        return this.variantScope.getVariantConfiguration().getSigningConfig();
    }

    @Override
    public PackagingOptions getPackagingOptions() {
        return this.globalScope.getExtension().getPackagingOptions();
    }

    @Override
    public String getTaskName(String name) {
        return this.getTaskName(name, "");
    }

    @Override
    public String getTaskName(String prefix, String suffix) {
        return this.variantScope.getTaskName(prefix, StringHelper.capitalize((String)this.atomDependency.getAtomName()) + suffix);
    }

    @Override
    public Project getProject() {
        return this.globalScope.getProject();
    }

    @Override
    public File getOutputPackage() {
        return this.variantScope.getPackageAtom(this.atomDependency);
    }

    @Override
    public File getIntermediateApk() {
        return this.variantOutputScope.getIntermediateApk();
    }

    @Override
    public File getInstantRunSplitApkOutputFolder() {
        return this.variantScope.getInstantRunSplitApkOutputFolder();
    }

    @Override
    public File getAtomMetadataBaseFolder() {
        return this.atomDependency.getAtomMetadataFile().getParentFile();
    }

    @Override
    public String getApplicationId() {
        return this.variantScope.getVariantConfiguration().getApplicationId();
    }

    @Override
    public int getVersionCode() {
        return 0;
    }

    @Override
    public String getVersionName() {
        return null;
    }

    @Override
    public AaptOptions getAaptOptions() {
        return this.globalScope.getExtension().getAaptOptions();
    }

    @Override
    public VariantType getVariantType() {
        return VariantType.ATOM;
    }

    @Override
    public File getManifestFile() {
        return this.atomDependency.getManifest();
    }
}

