/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.ApiVersion;
import java.io.File;
import java.util.Set;
import org.gradle.api.Project;

public class DefaultGradlePackagingScope
implements PackagingScope {
    private final VariantOutputScope mVariantOutputScope;
    private final VariantScope mVariantScope;
    private final GlobalScope mGlobalScope;

    public DefaultGradlePackagingScope(VariantOutputScope variantOutputScope) {
        this.mVariantOutputScope = variantOutputScope;
        this.mVariantScope = this.mVariantOutputScope.getVariantScope();
        this.mGlobalScope = this.mVariantScope.getGlobalScope();
    }

    @Override
    public AndroidBuilder getAndroidBuilder() {
        return this.mGlobalScope.getAndroidBuilder();
    }

    @Override
    public File getFinalResourcesFile() {
        return this.mVariantOutputScope.getFinalResourcesFile();
    }

    @Override
    public String getFullVariantName() {
        return this.mVariantScope.getFullVariantName();
    }

    @Override
    public ApiVersion getMinSdkVersion() {
        return this.mVariantScope.getMinSdkVersion();
    }

    @Override
    public InstantRunBuildContext getInstantRunBuildContext() {
        return this.mVariantScope.getInstantRunBuildContext();
    }

    @Override
    public File getInstantRunSupportDir() {
        return this.mVariantScope.getInstantRunSupportDir();
    }

    @Override
    public File getIncrementalDir(String name) {
        return this.mVariantScope.getIncrementalDir(name);
    }

    @Override
    public Set<File> getDexFolders() {
        return this.mVariantScope.getTransformManager().getPipelineOutput(StreamFilter.DEX).keySet();
    }

    @Override
    public Set<File> getJavaResources() {
        return this.mVariantScope.getTransformManager().getPipelineOutput(StreamFilter.RESOURCES).keySet();
    }

    @Override
    public Set<File> getJniFolders() {
        return this.mVariantScope.getTransformManager().getPipelineOutput(StreamFilter.NATIVE_LIBS).keySet();
    }

    @Override
    public SplitHandlingPolicy getSplitHandlingPolicy() {
        return this.mVariantScope.getVariantData().getSplitHandlingPolicy();
    }

    @Override
    public Set<String> getAbiFilters() {
        return this.mGlobalScope.getExtension().getSplits().getAbiFilters();
    }

    @Override
    public ApkOutputFile getMainOutputFile() {
        return this.mVariantOutputScope.getMainOutputFile();
    }

    @Override
    public Set<String> getSupportedAbis() {
        return this.mVariantScope.getVariantConfiguration().getSupportedAbis();
    }

    @Override
    public boolean isDebuggable() {
        return ((CoreBuildType)this.mVariantScope.getVariantConfiguration().getBuildType()).isDebuggable();
    }

    @Override
    public boolean isJniDebuggable() {
        return ((CoreBuildType)this.mVariantScope.getVariantConfiguration().getBuildType()).isJniDebuggable();
    }

    @Override
    public CoreSigningConfig getSigningConfig() {
        return this.mVariantScope.getVariantConfiguration().getSigningConfig();
    }

    @Override
    public PackagingOptions getPackagingOptions() {
        return this.mGlobalScope.getExtension().getPackagingOptions();
    }

    @Override
    public String getTaskName(String name) {
        return this.mVariantOutputScope.getTaskName(name);
    }

    @Override
    public String getTaskName(String prefix, String suffix) {
        return this.mVariantOutputScope.getTaskName(prefix, suffix);
    }

    @Override
    public Project getProject() {
        return this.mGlobalScope.getProject();
    }

    @Override
    public File getOutputPackage() {
        return this.mVariantOutputScope.getFinalPackage();
    }

    @Override
    public File getIntermediateApk() {
        return this.mVariantOutputScope.getIntermediateApk();
    }

    @Override
    public File getAssetsDir() {
        return this.mVariantScope.getMergeAssetsOutputDir();
    }

    @Override
    public File getInstantRunSplitApkOutputFolder() {
        return this.mVariantScope.getInstantRunSplitApkOutputFolder();
    }

    @Override
    public File getAtomMetadataBaseFolder() {
        return this.mVariantOutputScope.getAtomMetadataBaseFolder();
    }

    @Override
    public String getApplicationId() {
        return this.mVariantScope.getVariantConfiguration().getApplicationId();
    }

    @Override
    public int getVersionCode() {
        return this.mVariantOutputScope.getVariantOutputData().getVersionCode();
    }

    @Override
    public String getVersionName() {
        return this.mVariantScope.getVariantConfiguration().getVersionName();
    }

    @Override
    public AaptOptions getAaptOptions() {
        return this.mGlobalScope.getExtension().getAaptOptions();
    }

    @Override
    public VariantType getVariantType() {
        return this.mVariantScope.getVariantConfiguration().getType();
    }

    @Override
    public File getManifestFile() {
        return this.mVariantOutputScope.getManifestOutputFile();
    }
}

