/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.CompatibleScreensManifest;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.ProcessInstantAppResources;
import com.android.build.gradle.tasks.SplitZipAlign;
import com.android.builder.core.VariantType;
import com.android.builder.dependency.level2.AtomDependency;
import com.android.utils.StringHelper;
import java.io.File;
import java.util.Collection;
import org.gradle.api.DefaultTask;

public class VariantOutputScope
implements TransformVariantScope {
    private VariantScope variantScope;
    private BaseVariantOutputData variantOutputData;
    private AndroidTask<DefaultTask> assembleTask;
    private AndroidTask<CompatibleScreensManifest> compatibleScreensManifestTask;
    private AndroidTask<? extends ManifestProcessorTask> manifestProcessorTask;
    private AndroidTask<ProcessAndroidResources> processResourcesTask;
    private AndroidTask<?> shrinkResourcesTask;
    private AndroidTask<SplitZipAlign> splitZipAlignTask;
    private AndroidTask<ProcessInstantAppResources> processInstantAppResourcesTask;

    public VariantOutputScope(VariantScope variantScope, BaseVariantOutputData variantOutputData) {
        this.variantScope = variantScope;
        this.variantOutputData = variantOutputData;
    }

    @Override
    public GlobalScope getGlobalScope() {
        return this.variantScope.getGlobalScope();
    }

    public VariantScope getVariantScope() {
        return this.variantScope;
    }

    public BaseVariantOutputData getVariantOutputData() {
        return this.variantOutputData;
    }

    @Override
    public String getDirName() {
        throw new UnsupportedOperationException("dir name per output scope not yet supported");
    }

    @Override
    public Collection<String> getDirectorySegments() {
        throw new UnsupportedOperationException("dir name per output scope not yet supported");
    }

    @Override
    public String getFullVariantName() {
        return this.variantScope.getFullVariantName();
    }

    @Override
    public String getTaskName(String prefix) {
        return this.getTaskName(prefix, "");
    }

    @Override
    public String getTaskName(String prefix, String suffix) {
        if (this.getVariantScope().getVariantData().getType() == VariantType.ATOM) {
            suffix = "Atom" + suffix;
        }
        return prefix + StringHelper.capitalize((String)this.getVariantOutputData().getFullName()) + suffix;
    }

    public File getFinalPackage() {
        if (this.getVariantScope().getVariantData().getType() == VariantType.INSTANTAPP) {
            return this.buildPackagePath(".iapk");
        }
        return this.buildPackagePath(this.isSignedApk() ? ".apk" : "-unsigned.apk");
    }

    public File getIntermediateApk() {
        return this.buildPackagePath(this.isSignedApk() ? "-unaligned.apk" : "-unsigned.apk");
    }

    private File buildPackagePath(String suffix) {
        return new File(this.getGlobalScope().getApkLocation(), this.getGlobalScope().getProjectBaseName() + "-" + this.variantOutputData.getBaseName() + suffix);
    }

    private boolean isSignedApk() {
        ApkVariantData apkVariantData = (ApkVariantData)this.variantScope.getVariantData();
        return apkVariantData.isSigned();
    }

    private boolean isZipAlignApk() {
        ApkVariantData apkVariantData = (ApkVariantData)this.variantScope.getVariantData();
        return apkVariantData.getZipAlignEnabled();
    }

    public File getManifestOutputFile() {
        switch (this.variantScope.getVariantConfiguration().getType()) {
            case DEFAULT: 
            case INSTANTAPP: {
                return new File(this.getGlobalScope().getIntermediatesDir(), "/manifests/full/" + this.variantOutputData.getDirName() + "/AndroidManifest.xml");
            }
            case LIBRARY: 
            case ATOM: {
                return new File(this.variantScope.getBaseBundleDir(), "AndroidManifest.xml");
            }
            case ANDROID_TEST: {
                return new File(this.getGlobalScope().getIntermediatesDir(), "manifest/" + this.variantScope.getVariantConfiguration().getDirName() + "/AndroidManifest.xml");
            }
        }
        throw new RuntimeException("getManifestOutputFile called for an unexpected variant.");
    }

    public File getCompatibleScreensManifestFile() {
        return new File(this.getGlobalScope().getIntermediatesDir(), "/manifests/density/" + this.variantOutputData.getDirName() + "/AndroidManifest.xml");
    }

    public File getProcessResourcePackageOutputFile() {
        return this.variantOutputData.getProcessResourcePackageOutputFile();
    }

    public File getProcessResourcePackageOutputFile(AtomDependency atomDependency) {
        return this.variantOutputData.getProcessResourcePackageOutputFile(atomDependency);
    }

    public File getShrinkedResourcesFile() {
        return new File(this.getGlobalScope().getIntermediatesDir(), "/res/resources-" + this.variantOutputData.getBaseName() + "-stripped.ap_");
    }

    public File getFinalResourcesFile() {
        return this.variantScope.useResourceShrinker() ? this.getShrinkedResourcesFile() : this.getProcessResourcePackageOutputFile();
    }

    public File getAtomMetadataBaseFolder() {
        return this.variantOutputData.getAtomMetadataBaseFolder();
    }

    public AndroidTask<DefaultTask> getAssembleTask() {
        return this.assembleTask;
    }

    public void setAssembleTask(AndroidTask<DefaultTask> assembleTask) {
        this.assembleTask = assembleTask;
    }

    public AndroidTask<CompatibleScreensManifest> getCompatibleScreensManifestTask() {
        return this.compatibleScreensManifestTask;
    }

    public void setCompatibleScreensManifestTask(AndroidTask<CompatibleScreensManifest> compatibleScreensManifestTask) {
        this.compatibleScreensManifestTask = compatibleScreensManifestTask;
    }

    public AndroidTask<? extends ManifestProcessorTask> getManifestProcessorTask() {
        return this.manifestProcessorTask;
    }

    public void setManifestProcessorTask(AndroidTask<? extends ManifestProcessorTask> manifestProcessorTask) {
        this.manifestProcessorTask = manifestProcessorTask;
    }

    public AndroidTask<ProcessAndroidResources> getProcessResourcesTask() {
        return this.processResourcesTask;
    }

    public void setProcessResourcesTask(AndroidTask<ProcessAndroidResources> processResourcesTask) {
        this.processResourcesTask = processResourcesTask;
    }

    public AndroidTask<?> getShrinkResourcesTask() {
        return this.shrinkResourcesTask;
    }

    public void setShrinkResourcesTask(AndroidTask<?> shrinkResourcesTask) {
        this.shrinkResourcesTask = shrinkResourcesTask;
    }

    public AndroidTask<SplitZipAlign> getSplitZipAlignTask() {
        return this.splitZipAlignTask;
    }

    public void setSplitZipAlignTask(AndroidTask<SplitZipAlign> splitZipAlignTask) {
        this.splitZipAlignTask = splitZipAlignTask;
    }

    public AndroidTask<ProcessInstantAppResources> getProcessInstantAppResourcesTask() {
        return this.processInstantAppResourcesTask;
    }

    public void setProcessInstantAppResourcesTask(AndroidTask<ProcessInstantAppResources> processInstantAppResourcesTask) {
        this.processInstantAppResourcesTask = processInstantAppResourcesTask;
    }

    public ApkOutputFile getMainOutputFile() {
        return this.getVariantOutputData().getMainOutputFile();
    }
}

