/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.tasks.PrepareLibraryTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.builder.dependency.level2.AndroidDependency;
import com.android.builder.utils.FileCache;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.internal.WaitableExecutor;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Consumer;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;

public class ResolveDependenciesTask
extends BaseTask {
    private BaseVariantData<? extends BaseVariantOutputData> variantData;
    private DependencyManager dependencyManager;
    private String testedProjectPath;
    private Optional<FileCache> buildCache;

    @TaskAction
    public void resolveDependencies() throws LoggedErrorException, InterruptedException, IOException {
        this.dependencyManager.resolveDependencies(this.variantData.getVariantDependency(), this.testedProjectPath);
        this.variantData.getVariantConfiguration().setResolvedDependencies(this.variantData.getVariantDependency().getCompileDependencies(), this.variantData.getVariantDependency().getPackageDependencies());
        ResolveDependenciesTask.extractAarInParallel(this.getProject(), this.variantData.getVariantConfiguration(), this.buildCache);
    }

    public static void extractAarInParallel(Project project, GradleVariantConfiguration config, Optional<FileCache> buildCache) throws LoggedErrorException, InterruptedException, IOException {
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        HashSet dependencies = Sets.newHashSet((Iterable)config.getFlatCompileAndroidLibraries());
        dependencies.addAll(config.getFlatPackageAndroidLibraries());
        for (AndroidDependency androidDependency : dependencies) {
            if (androidDependency.getProjectPath() != null) continue;
            File input = androidDependency.getArtifactFile();
            File output = androidDependency.getExtractedFolder();
            boolean useBuildCache = PrepareLibraryTask.shouldUseBuildCache(buildCache.isPresent(), androidDependency.getCoordinates());
            PrepareLibraryTask.prepareLibrary(input, output, buildCache.isPresent() ? buildCache.get() : null, ResolveDependenciesTask.createAction(project, (WaitableExecutor<Void>)executor, input), project.getLogger(), useBuildCache);
        }
        executor.waitForTasksWithQuickFail(false);
    }

    private static Consumer<File> createAction(Project project, WaitableExecutor<Void> executor, File input) {
        return outputDir -> executor.execute(() -> {
            PrepareLibraryTask.extract(input, outputDir, project);
            return null;
        });
    }

    public static class ConfigAction
    implements TaskConfigAction<ResolveDependenciesTask> {
        private final VariantScope scope;
        private final DependencyManager dependencyManager;

        public ConfigAction(VariantScope scope, DependencyManager dependencyManager) {
            this.scope = scope;
            this.dependencyManager = dependencyManager;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("resolve", "Dependencies");
        }

        @Override
        public Class<ResolveDependenciesTask> getType() {
            return ResolveDependenciesTask.class;
        }

        @Override
        public void execute(ResolveDependenciesTask task) {
            task.variantData = this.scope.getVariantData();
            task.dependencyManager = this.dependencyManager;
            task.setVariantName(this.scope.getFullVariantName());
            task.testedProjectPath = this.scope.getGlobalScope().getExtension() instanceof TestAndroidConfig ? ((TestAndroidConfig)this.scope.getGlobalScope().getExtension()).getTargetProjectPath() : null;
            task.buildCache = AndroidGradleOptions.getBuildCache(this.scope.getGlobalScope().getProject());
        }
    }
}

