/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.databinding;

import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.processing.Scope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.xml.sax.SAXException;

public class DataBindingProcessLayoutsTask
extends DefaultTask {
    private LayoutXmlProcessor xmlProcessor;
    private File sdkDir;
    private int minSdk;
    private File layoutInputFolder;
    private File layoutOutputFolder;
    private File xmlInfoOutFolder;

    @InputDirectory
    public File getLayoutInputFolder() {
        return this.layoutInputFolder;
    }

    public void setLayoutInputFolder(File layoutInputFolder) {
        this.layoutInputFolder = layoutInputFolder;
    }

    @OutputDirectory
    public File getLayoutOutputFolder() {
        return this.layoutOutputFolder;
    }

    public void setLayoutOutputFolder(File layoutOutputFolder) {
        this.layoutOutputFolder = layoutOutputFolder;
    }

    @OutputDirectory
    public File getXmlInfoOutFolder() {
        return this.xmlInfoOutFolder;
    }

    @TaskAction
    public void processResources(IncrementalTaskInputs incrementalTaskInputs) throws ParserConfigurationException, SAXException, XPathExpressionException, IOException, JAXBException {
        final LayoutXmlProcessor.ResourceInput resourceInput = new LayoutXmlProcessor.ResourceInput(incrementalTaskInputs.isIncremental(), this.getLayoutInputFolder(), this.getLayoutOutputFolder());
        if (incrementalTaskInputs.isIncremental()) {
            incrementalTaskInputs.outOfDate((Action)new Action<InputFileDetails>(){

                public void execute(InputFileDetails inputFileDetails) {
                    if (inputFileDetails.isAdded()) {
                        resourceInput.added(inputFileDetails.getFile());
                    } else if (inputFileDetails.isModified()) {
                        resourceInput.changed(inputFileDetails.getFile());
                    }
                }
            });
            incrementalTaskInputs.removed((Action)new Action<InputFileDetails>(){

                public void execute(InputFileDetails inputFileDetails) {
                    resourceInput.removed(inputFileDetails.getFile());
                }
            });
        }
        this.xmlProcessor.processResources(resourceInput);
        Scope.assertNoError();
        this.xmlProcessor.writeLayoutInfoFiles(this.getXmlInfoOutFolder());
        Scope.assertNoError();
    }

    public void setXmlProcessor(LayoutXmlProcessor xmlProcessor) {
        this.xmlProcessor = xmlProcessor;
    }

    public File getSdkDir() {
        return this.sdkDir;
    }

    public void setSdkDir(File sdkDir) {
        this.sdkDir = sdkDir;
    }

    public int getMinSdk() {
        return this.minSdk;
    }

    public void setMinSdk(int minSdk) {
        this.minSdk = minSdk;
    }

    public void setXmlInfoOutFolder(File xmlInfoOutFolder) {
        this.xmlInfoOutFolder = xmlInfoOutFolder;
    }

    public static class ConfigAction
    implements TaskConfigAction<DataBindingProcessLayoutsTask> {
        private final VariantScope variantScope;

        public ConfigAction(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("dataBindingProcessLayouts");
        }

        @Override
        public Class<DataBindingProcessLayoutsTask> getType() {
            return DataBindingProcessLayoutsTask.class;
        }

        @Override
        public void execute(DataBindingProcessLayoutsTask task) {
            task.setXmlProcessor(this.variantScope.getVariantData().getLayoutXmlProcessor());
            task.setSdkDir(this.variantScope.getGlobalScope().getSdkHandler().getSdkFolder());
            task.setMinSdk(this.variantScope.getVariantConfiguration().getMinSdkVersion().getApiLevel());
            task.setLayoutInputFolder(this.variantScope.getMergeResourcesOutputDir());
            task.setLayoutOutputFolder(this.variantScope.getLayoutFolderOutputForDataBinding());
            task.setXmlInfoOutFolder(this.variantScope.getLayoutInfoOutputForDataBinding());
            this.variantScope.setResourceOutputDir(this.variantScope.getLayoutFolderOutputForDataBinding());
        }
    }
}

