/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.internal.transforms.InstantRunSplitApkBuilder;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.AaptOptions;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class InstantRunSliceSplitApkBuilder
extends InstantRunSplitApkBuilder {
    private final WaitableExecutor<File> executor = WaitableExecutor.useGlobalSharedThreadPool();

    public InstantRunSliceSplitApkBuilder(Logger logger, Project project, InstantRunBuildContext instantRunBuildContext, AndroidBuilder androidBuilder, PackagingScope packagingScope, CoreSigningConfig signingConf, AaptOptions aaptOptions, File outputDirectory, File supportDirectory) {
        super(logger, project, instantRunBuildContext, androidBuilder, packagingScope, signingConf, aaptOptions, outputDirectory, supportDirectory);
    }

    public String getName() {
        return "instantRunSlicesApk";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)((Object)ExtendedContentType.DEX));
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS});
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        ArrayList<InstantRunSplitApkBuilder.DexFiles> splitsToBuild = new ArrayList<InstantRunSplitApkBuilder.DexFiles>();
        if (transformInvocation.isIncremental()) {
            for (TransformInput transformInput : transformInvocation.getInputs()) {
                for (JarInput jarInput : transformInput.getJarInputs()) {
                    this.logger.error("InstantRunDependenciesApkBuilder received a jar file " + jarInput.getFile().getAbsolutePath());
                }
                for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                    block14: for (Map.Entry fileEntry : directoryInput.getChangedFiles().entrySet()) {
                        File inputFolder = ((File)fileEntry.getKey()).getParentFile();
                        switch ((Status)fileEntry.getValue()) {
                            case NOTCHANGED: {
                                continue block14;
                            }
                            case ADDED: 
                            case CHANGED: {
                                File[] dexFiles = inputFolder.listFiles();
                                if (dexFiles == null) continue block14;
                                try {
                                    splitsToBuild.add(new InstantRunSplitApkBuilder.DexFiles(dexFiles, directoryInput.getName()));
                                    continue block14;
                                }
                                catch (Exception e) {
                                    throw new TransformException((Throwable)e);
                                }
                            }
                            case REMOVED: {
                                InstantRunSplitApkBuilder.DexFiles dexFile = new InstantRunSplitApkBuilder.DexFiles((ImmutableSet<File>)ImmutableSet.of(), inputFolder.getName());
                                String outputFileName = dexFile.encodeName() + "_unaligned.apk";
                                new File(this.outputDirectory, outputFileName).delete();
                                outputFileName = dexFile.encodeName() + ".apk";
                                new File(this.outputDirectory, outputFileName).delete();
                                continue block14;
                            }
                        }
                        throw new TransformException(String.format("Unhandled status %1$s for %2$s", fileEntry.getValue(), ((File)fileEntry.getKey()).getAbsolutePath()));
                    }
                }
            }
        } else {
            FileUtils.cleanOutputDir((File)this.outputDirectory);
            for (TransformInput transformInput : transformInvocation.getInputs()) {
                for (JarInput jarInput : transformInput.getJarInputs()) {
                    this.logger.error("InstantRunDependenciesApkBuilder received a jar file " + jarInput.getFile().getAbsolutePath());
                }
                for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                    Object[] files = directoryInput.getFile().listFiles();
                    if (files == null) continue;
                    try {
                        splitsToBuild.add(new InstantRunSplitApkBuilder.DexFiles((ImmutableSet<File>)ImmutableSet.copyOf((Object[])files), directoryInput.getName()));
                    }
                    catch (Exception e) {
                        throw new TransformException((Throwable)e);
                    }
                }
            }
        }
        splitsToBuild.forEach(split -> {
            try {
                this.executor.execute(() -> this.generateSplitApk((InstantRunSplitApkBuilder.DexFiles)split));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        try {
            this.executor.waitForTasksWithQuickFail(true);
        }
        catch (LoggedErrorException e) {
            this.logger.error("Exception while generating split APKs " + e.getMessage());
            throw new TransformException((Throwable)e);
        }
    }
}

