/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.api.AtomVariant;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.AtomVariantImpl;
import com.android.build.gradle.internal.api.AtomVariantOutputImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.variant.AtomVariantData;
import com.android.build.gradle.internal.variant.AtomVariantOutputData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.VariantType;
import com.android.builder.model.ApiVersion;
import com.android.builder.profile.Recorder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.internal.reflect.Instantiator;

public class AtomVariantFactory
implements VariantFactory {
    private Instantiator instantiator;
    private final AndroidConfig extension;
    private final AndroidBuilder androidBuilder;

    public AtomVariantFactory(Instantiator instantiator, AndroidBuilder androidBuilder, AndroidConfig extension) {
        this.instantiator = instantiator;
        this.androidBuilder = androidBuilder;
        this.extension = extension;
    }

    @Override
    public BaseVariantData createVariantData(GradleVariantConfiguration variantConfiguration, TaskManager taskManager, Recorder recorder) {
        return new AtomVariantData(this.extension, taskManager, variantConfiguration, this.androidBuilder.getErrorReporter(), recorder);
    }

    @Override
    public AtomVariant createVariantApi(BaseVariantData<? extends BaseVariantOutputData> variantData, ReadOnlyObjectProvider readOnlyObjectProvider) {
        AtomVariantImpl variant = (AtomVariantImpl)this.instantiator.newInstance(AtomVariantImpl.class, new Object[]{variantData, this.androidBuilder, readOnlyObjectProvider});
        List<? extends BaseVariantOutputData> outputList = variantData.getOutputs();
        ArrayList apiOutputList = Lists.newArrayListWithCapacity((int)outputList.size());
        for (BaseVariantOutputData baseVariantOutputData : outputList) {
            AtomVariantOutputData atomOutput = (AtomVariantOutputData)baseVariantOutputData;
            AtomVariantOutputImpl output = (AtomVariantOutputImpl)this.instantiator.newInstance(AtomVariantOutputImpl.class, new Object[]{atomOutput});
            apiOutputList.add(output);
        }
        variant.addOutputs((List)apiOutputList);
        return variant;
    }

    @Override
    public VariantType getVariantConfigurationType() {
        return VariantType.ATOM;
    }

    @Override
    public boolean hasTestScope() {
        return true;
    }

    @Override
    public void validateModel(VariantModel model) {
        String applicationIdSuffix;
        ErrorReporter errorReporter = this.androidBuilder.getErrorReporter();
        if (model.getDefaultConfig().getProductFlavor().getApplicationId() != null) {
            String applicationId = model.getDefaultConfig().getProductFlavor().getApplicationId();
            errorReporter.handleSyncError(applicationId, 0, "Atom projects cannot set applicationId. applicationId is set to '" + applicationId + "' in default config.");
        }
        if (model.getDefaultConfig().getProductFlavor().getApplicationIdSuffix() != null) {
            Iterator<ProductFlavorData<CoreProductFlavor>> applicationIdSuffix2 = model.getDefaultConfig().getProductFlavor().getApplicationIdSuffix();
            errorReporter.handleSyncError(applicationIdSuffix2, 0, "Atom projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + applicationIdSuffix2 + "' in default config.");
        }
        for (BuildTypeData buildType : model.getBuildTypes().values()) {
            if (buildType.getBuildType().getApplicationIdSuffix() == null) continue;
            applicationIdSuffix = buildType.getBuildType().getApplicationIdSuffix();
            errorReporter.handleSyncError(applicationIdSuffix, 0, "Atom projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + applicationIdSuffix + "' in build type '" + buildType.getBuildType().getName() + "'.");
        }
        for (ProductFlavorData<CoreProductFlavor> productFlavor : model.getProductFlavors().values()) {
            if (productFlavor.getProductFlavor().getApplicationId() != null) {
                String applicationId = productFlavor.getProductFlavor().getApplicationId();
                errorReporter.handleSyncError(applicationId, 0, "Atom projects cannot set applicationId. applicationId is set to '" + applicationId + "' in flavor '" + productFlavor.getProductFlavor().getName() + "'.");
            }
            if (productFlavor.getProductFlavor().getApplicationIdSuffix() == null) continue;
            applicationIdSuffix = productFlavor.getProductFlavor().getApplicationIdSuffix();
            errorReporter.handleSyncError(applicationIdSuffix, 0, "Atom projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + applicationIdSuffix + "' in flavor '" + productFlavor.getProductFlavor().getName() + "'.");
        }
        ApiVersion minSdkVersion = model.getDefaultConfig().getProductFlavor().getMinSdkVersion();
        if (minSdkVersion != null && minSdkVersion.getCodename() == null && minSdkVersion.getApiLevel() < 16) {
            errorReporter.handleSyncError(model.getDefaultConfig().getProductFlavor().getName(), 0, "Atom projects have a minimum API level requirement of 16 (Jelly Bean).Minimum API level is set to '" + minSdkVersion.getApiString() + "'.");
        }
    }

    @Override
    public void preVariantWork(Project project) {
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
        buildTypes.create("release");
    }
}

