/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.OutputFile;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.api.InstantAppVariant;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.InstantAppVariantImpl;
import com.android.build.gradle.internal.api.InstantAppVariantOutputImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.InstantAppVariantData;
import com.android.build.gradle.internal.variant.InstantAppVariantOutputData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.internal.reflect.Instantiator;

public class InstantAppVariantFactory
implements VariantFactory {
    private Instantiator instantiator;
    private final AndroidConfig extension;
    private final AndroidBuilder androidBuilder;

    public InstantAppVariantFactory(Instantiator instantiator, AndroidBuilder androidBuilder, AndroidConfig extension) {
        this.instantiator = instantiator;
        this.androidBuilder = androidBuilder;
        this.extension = extension;
    }

    @Override
    public BaseVariantData createVariantData(GradleVariantConfiguration variantConfiguration, TaskManager taskManager, Recorder recorder) {
        InstantAppVariantData variant = new InstantAppVariantData(this.extension, taskManager, variantConfiguration, this.androidBuilder.getErrorReporter(), recorder);
        variant.createOutput(OutputFile.OutputType.MAIN, Collections.emptyList());
        return variant;
    }

    @Override
    public InstantAppVariant createVariantApi(BaseVariantData<? extends BaseVariantOutputData> variantData, ReadOnlyObjectProvider readOnlyObjectProvider) {
        InstantAppVariantImpl variant = (InstantAppVariantImpl)this.instantiator.newInstance(InstantAppVariantImpl.class, new Object[]{variantData, this.androidBuilder, readOnlyObjectProvider});
        List<? extends BaseVariantOutputData> outputList = variantData.getOutputs();
        ArrayList apiOutputList = Lists.newArrayListWithCapacity((int)outputList.size());
        for (BaseVariantOutputData baseVariantOutputData : outputList) {
            InstantAppVariantOutputData instantAppOutput = (InstantAppVariantOutputData)baseVariantOutputData;
            InstantAppVariantOutputImpl output = (InstantAppVariantOutputImpl)this.instantiator.newInstance(InstantAppVariantOutputImpl.class, new Object[]{instantAppOutput});
            apiOutputList.add(output);
        }
        variant.addOutputs((List)apiOutputList);
        return variant;
    }

    @Override
    public VariantType getVariantConfigurationType() {
        return VariantType.INSTANTAPP;
    }

    @Override
    public boolean hasTestScope() {
        return false;
    }

    @Override
    public void validateModel(VariantModel model) {
    }

    @Override
    public void preVariantWork(Project project) {
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
        buildTypes.create("release");
    }
}

