/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.build.gradle.internal.variant.AtomVariantOutputData;
import com.android.builder.dependency.level2.AtomDependency;
import com.android.builder.dependency.level2.DependencyContainer;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.wireless.android.instantapps.iapk.AtomDependencyProto;
import com.google.wireless.android.instantapps.iapk.AtomMetadataProto;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class GenerateAtomMetadata
extends DefaultAndroidTask {
    private File atomMetadataFolder;
    private String atomVersion;
    private String atomName;
    private Set<File> atomMetadataDependency;

    @TaskAction
    public void taskAction() throws IOException {
        AtomMetadataProto.AtomMetadata.Builder atomMetadataBuilder = AtomMetadataProto.AtomMetadata.newBuilder();
        atomMetadataBuilder.setAtomName(this.getAtomName());
        atomMetadataBuilder.setAtomVersionName(this.getAtomVersion());
        for (File atomDependencyFile : this.getAtomMetadataDependency()) {
            FileInputStream inputStream = new FileInputStream(atomDependencyFile);
            Throwable throwable = null;
            try {
                AtomMetadataProto.AtomMetadata atomMetadataDependency = AtomMetadataProto.AtomMetadata.parseFrom(inputStream);
                AtomDependencyProto.AtomDependency.Builder atomDependencyBuilder = AtomDependencyProto.AtomDependency.newBuilder();
                atomDependencyBuilder.setAtomName(atomMetadataDependency.getAtomName());
                atomDependencyBuilder.setAtomVersionName(atomMetadataDependency.getAtomVersionName());
                atomMetadataBuilder.addAtomDependency(atomDependencyBuilder);
                inputStream.close();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        File atomMetadataFile = new File(this.getAtomMetadataFolder(), "atom-metadata");
        atomMetadataFile.delete();
        try (FileOutputStream outputStream = new FileOutputStream(atomMetadataFile);){
            atomMetadataBuilder.build().writeTo(outputStream);
            outputStream.close();
        }
    }

    @OutputDirectory
    public File getAtomMetadataFolder() {
        return this.atomMetadataFolder;
    }

    protected void setAtomMetadataFolder(File atomMetadataFolder) {
        this.atomMetadataFolder = atomMetadataFolder;
    }

    @Input
    public String getAtomVersion() {
        return this.atomVersion;
    }

    public void setAtomVersion(String atomVersion) {
        this.atomVersion = atomVersion;
    }

    @Input
    public String getAtomName() {
        return this.atomName;
    }

    public void setAtomName(String atomName) {
        this.atomName = atomName;
    }

    @InputFiles
    public Set<File> getAtomMetadataDependency() {
        return this.atomMetadataDependency;
    }

    public void setAtomMetadataDependency(Set<File> atomMetadataDependency) {
        this.atomMetadataDependency = atomMetadataDependency;
    }

    public static class ConfigAction
    implements TaskConfigAction<GenerateAtomMetadata> {
        private VariantOutputScope scope;

        public ConfigAction(VariantOutputScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("generate", "Metadata");
        }

        @Override
        public Class<GenerateAtomMetadata> getType() {
            return GenerateAtomMetadata.class;
        }

        @Override
        public void execute(GenerateAtomMetadata generateAtomMetadata) {
            AtomVariantOutputData variantOutputData = (AtomVariantOutputData)this.scope.getVariantOutputData();
            DependencyContainer dependencyContainer = this.scope.getVariantScope().getVariantConfiguration().getPackageDependencies();
            ImmutableSet.Builder atomMetadataBuilder = ImmutableSet.builder();
            for (AtomDependency atom : dependencyContainer.getDirectAtomDependencies()) {
                atomMetadataBuilder.add((Object)atom.getAtomMetadataFile());
            }
            generateAtomMetadata.setAtomMetadataDependency((Set<File>)atomMetadataBuilder.build());
            generateAtomMetadata.setAtomName(this.scope.getGlobalScope().getProject().getName());
            String versionName = variantOutputData.getVersionName();
            Preconditions.checkState((!Strings.isNullOrEmpty((String)versionName) ? 1 : 0) != 0, (Object)"versionName is not specified.");
            generateAtomMetadata.setAtomVersion(versionName);
            generateAtomMetadata.setAtomMetadataFolder(FileUtils.join((File)this.scope.getVariantScope().getBaseBundleDir(), (String[])new String[]{"metadata"}));
            generateAtomMetadata.setVariantName(variantOutputData.getFullName());
            variantOutputData.generateAtomMetadataTask = generateAtomMetadata;
        }

        public VariantOutputScope getScope() {
            return this.scope;
        }

        public void setScope(VariantOutputScope scope) {
            this.scope = scope;
        }
    }
}

