/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.dsl.CoreJackOptions;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.JackProcessOptions;
import com.android.builder.core.JackToolchain;
import com.android.builder.internal.compiler.JackConversionCache;
import com.android.builder.model.ApiVersion;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class JackPreDexTransform
extends Transform {
    private static final ILogger LOG = LoggerWrapper.getLogger(JackPreDexTransform.class);
    private final Supplier<List<File>> bootClasspath;
    private final Supplier<BuildToolInfo> buildToolInfo;
    private final ErrorReporter errorReporter;
    private final JavaProcessExecutor javaProcessExecutor;
    private String javaMaxHeapSize;
    private boolean forPackagedLibs;
    private CoreJackOptions coreJackOptions;
    private ApiVersion minSdkVersion;
    private final boolean debugJackInternals;
    private final boolean verboseProcessing;
    private final boolean debuggable;

    public static Builder builder() {
        return new Builder();
    }

    protected JackPreDexTransform(Supplier<List<File>> bootClasspath, Supplier<BuildToolInfo> buildToolInfo, ErrorReporter errorReporter, JavaProcessExecutor javaProcessExecutor, String javaMaxHeapSize, CoreJackOptions coreJackOptions, ApiVersion minSdkVersion, boolean forPackagedLibs, boolean debugJackInternals, boolean verboseProcessing, boolean debuggable) {
        this.bootClasspath = bootClasspath;
        this.buildToolInfo = buildToolInfo;
        this.errorReporter = errorReporter;
        this.javaProcessExecutor = javaProcessExecutor;
        this.javaMaxHeapSize = javaMaxHeapSize;
        this.coreJackOptions = coreJackOptions;
        this.minSdkVersion = minSdkVersion;
        this.forPackagedLibs = forPackagedLibs;
        this.debugJackInternals = debugJackInternals;
        this.verboseProcessing = verboseProcessing;
        this.debuggable = debuggable;
    }

    public String getName() {
        return this.forPackagedLibs ? "preJackPackagedLibraries" : "preJackRuntimeLibraries";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return TransformManager.CONTENT_JACK;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        if (this.forPackagedLibs) {
            return TransformManager.SCOPE_FULL_PROJECT;
        }
        return Collections.singleton(QualifiedContent.Scope.PROVIDED_ONLY);
    }

    public boolean isIncremental() {
        return true;
    }

    public Map<String, Object> getParameterInputs() {
        return ImmutableMap.of((Object)"buildToolsRev", (Object)this.buildToolInfo.get().getRevision().toString());
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        try {
            this.runJack(transformInvocation);
        }
        catch (JackToolchain.ToolchainException | ProcessException | ClassNotFoundException e) {
            throw new TransformException(e);
        }
    }

    private void runJack(TransformInvocation transformInvocation) throws JackToolchain.ToolchainException, ClassNotFoundException, ProcessException, InterruptedException, IOException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider);
        Iterable<File> jarInputs = TransformInputUtil.getJarFiles(transformInvocation.getInputs());
        if (!this.forPackagedLibs) {
            jarInputs = Iterables.concat(jarInputs, (Iterable)this.bootClasspath.get());
        }
        for (File file : jarInputs) {
            JackProcessOptions options = new JackProcessOptions();
            options.setUseJill(!this.forPackagedLibs);
            options.setImportFiles((Collection)ImmutableList.of((Object)file));
            File outFile = outputProvider.getContentLocation(JackPreDexTransform.getJackFileName(file), this.getOutputTypes(), this.getScopes(), Format.JAR);
            options.setOutputFile(outFile);
            options.setJavaMaxHeapSize(this.javaMaxHeapSize);
            options.setAdditionalParameters(this.coreJackOptions.getAdditionalParameters());
            options.setMinSdkVersion(this.minSdkVersion);
            options.setDebugJackInternals(this.debugJackInternals);
            options.setVerboseProcessing(this.verboseProcessing);
            options.setDebuggable(this.debuggable);
            JackConversionCache.getCache().convertLibrary(file, outFile, options, this.coreJackOptions.isJackInProcess().booleanValue(), this.buildToolInfo.get(), LOG, this.errorReporter, this.javaProcessExecutor);
        }
    }

    public static String getJackFileName(File inputFile) {
        String name = inputFile.getName();
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        String input = inputFile.getAbsolutePath();
        HashFunction hashFunction = Hashing.sha1();
        HashCode hashCode = hashFunction.hashString((CharSequence)input, Charsets.UTF_16LE);
        return name + "-" + hashCode.toString();
    }

    public boolean isForRuntimeLibs() {
        return !this.forPackagedLibs;
    }

    public static class Builder {
        private Supplier<List<File>> bootClasspath = ImmutableList::of;
        private Supplier<BuildToolInfo> buildToolInfo;
        private ErrorReporter errorReporter;
        private JavaProcessExecutor javaProcessExecutor;
        private String javaMaxHeapSize;
        private CoreJackOptions coreJackOptions;
        private Boolean forPackagedLibs;
        private ApiVersion minApiVersion;
        private boolean debugJackInternals = false;
        private boolean verboseProcessing = false;
        private boolean debuggable = false;

        public Builder bootClasspath(Supplier<List<File>> bootClasspath) {
            this.bootClasspath = bootClasspath;
            return this;
        }

        public Builder buildToolInfo(Supplier<BuildToolInfo> buildToolInfo) {
            this.buildToolInfo = buildToolInfo;
            return this;
        }

        public Builder errorReporter(ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
            return this;
        }

        public Builder javaProcessExecutor(JavaProcessExecutor javaProcessExecutor) {
            this.javaProcessExecutor = javaProcessExecutor;
            return this;
        }

        public Builder javaMaxHeapSize(String javaMaxHeapSize) {
            this.javaMaxHeapSize = javaMaxHeapSize;
            return this;
        }

        public Builder coreJackOptions(CoreJackOptions coreJackOptions) {
            this.coreJackOptions = coreJackOptions;
            return this;
        }

        public Builder forPackagedLibs() {
            this.forPackagedLibs = true;
            return this;
        }

        public Builder forClasspathLibs() {
            this.forPackagedLibs = false;
            return this;
        }

        public Builder minApiVersion(ApiVersion minApiVersion) {
            this.minApiVersion = minApiVersion;
            return this;
        }

        public Builder debugJackInternals(boolean debugJackInternals) {
            this.debugJackInternals = debugJackInternals;
            return this;
        }

        public Builder verboseProcessing(boolean verboseProcessing) {
            this.verboseProcessing = verboseProcessing;
            return this;
        }

        public Builder debuggable(boolean debuggable) {
            this.debuggable = debuggable;
            return this;
        }

        public JackPreDexTransform create() {
            Preconditions.checkNotNull(this.buildToolInfo);
            Preconditions.checkNotNull((Object)this.errorReporter);
            Preconditions.checkNotNull((Object)this.javaProcessExecutor);
            Preconditions.checkNotNull((Object)this.coreJackOptions);
            Preconditions.checkNotNull((Object)this.minApiVersion);
            return new JackPreDexTransform(this.bootClasspath, this.buildToolInfo, this.errorReporter, this.javaProcessExecutor, this.javaMaxHeapSize, this.coreJackOptions, this.minApiVersion, this.forPackagedLibs, this.debugJackInternals, this.verboseProcessing, this.debuggable);
        }
    }
}

