/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.apkzlib.utils.CachedFileContents;
import com.android.apkzlib.utils.IOExceptionWrapper;
import com.android.apkzlib.zfile.ApkCreatorFactory;
import com.android.apkzlib.zip.compress.Zip64NotSupportedException;
import com.android.build.OutputFile;
import com.android.build.gradle.internal.annotations.PackageFile;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.incremental.DexPackagingPolicy;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.packaging.ApkCreatorFactories;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.builder.files.FileCacheByPath;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.ApiVersion;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.PackagingUtils;
import com.android.ide.common.res2.FileStatus;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.tooling.BuildException;

public abstract class PackageAndroidArtifact
extends IncrementalTask
implements FileSupplier {
    public static final String INSTANT_RUN_PACKAGES_PREFIX = "instant-run";
    private File resourceFile;
    private Set<File> dexFolders;
    private File assets;
    private File atomMetadataFolder;
    private Set<File> javaResourceFiles;
    private Set<File> jniFolders;
    @PackageFile
    private File outputFile;
    private Set<String> abiFilters;
    private boolean debugBuild;
    private boolean jniDebugBuild;
    private CoreSigningConfig signingConfig;
    private PackagingOptions packagingOptions;
    private ApiVersion minSdkVersion;
    protected InstantRunBuildContext instantRunContext;
    protected File instantRunSupportDir;
    protected DexPackagingPolicy dexPackagingPolicy;
    protected File manifest;
    protected AaptOptions aaptOptions;
    protected FileType instantRunFileType;
    private static final String ZIP_DIFF_CACHE_DIR = "zip-cache";
    private static final String ZIP_64_COPY_DIR = "zip64-copy";
    protected FileCacheByPath cacheByPath;

    @InputFile
    public File getResourceFile() {
        return this.resourceFile;
    }

    public void setResourceFile(File resourceFile) {
        this.resourceFile = resourceFile;
    }

    @org.gradle.api.tasks.OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @Input
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    public void setAbiFilters(Set<String> abiFilters) {
        this.abiFilters = abiFilters;
    }

    @InputFiles
    @Optional
    public Collection<File> getJavaResourceFiles() {
        return this.javaResourceFiles;
    }

    @InputFiles
    @Optional
    public Collection<File> getJniFolders() {
        return this.jniFolders;
    }

    @InputFiles
    @Optional
    public Set<File> getDexFolders() {
        return this.dexFolders;
    }

    public void setDexFolders(Set<File> dexFolders) {
        this.dexFolders = dexFolders;
    }

    @InputDirectory
    public File getAssets() {
        return this.assets;
    }

    public void setAssets(File assets) {
        this.assets = assets;
    }

    @InputDirectory
    @Optional
    public File getAtomMetadataFolder() {
        return this.atomMetadataFolder;
    }

    @Input
    public boolean getJniDebugBuild() {
        return this.jniDebugBuild;
    }

    public void setJniDebugBuild(boolean jniDebugBuild) {
        this.jniDebugBuild = jniDebugBuild;
    }

    @Input
    public boolean getDebugBuild() {
        return this.debugBuild;
    }

    public void setDebugBuild(boolean debugBuild) {
        this.debugBuild = debugBuild;
    }

    @Nested
    @Optional
    public CoreSigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    public void setSigningConfig(CoreSigningConfig signingConfig) {
        this.signingConfig = signingConfig;
    }

    @Nested
    public PackagingOptions getPackagingOptions() {
        return this.packagingOptions;
    }

    public void setPackagingOptions(PackagingOptions packagingOptions) {
        this.packagingOptions = packagingOptions;
    }

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion.getApiLevel();
    }

    public void setMinSdkVersion(ApiVersion version) {
        this.minSdkVersion = version;
    }

    @Input
    public String getDexPackagingPolicy() {
        return this.dexPackagingPolicy.toString();
    }

    @Input
    public String getNativeLibrariesPackagingModeName() {
        return PackagingUtils.getNativeLibrariesLibrariesPackagingMode((File)this.manifest).toString();
    }

    @Input
    public Collection<String> getNoCompressExtensions() {
        return (Collection)MoreObjects.firstNonNull((Object)this.aaptOptions.getNoCompress(), Collections.emptyList());
    }

    protected Predicate<String> getNoCompressPredicate() {
        return PackagingUtils.getNoCompressPredicate((AaptOptions)this.aaptOptions, (File)this.manifest);
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        this.cacheByPath.clear();
        FileUtils.deleteDirectoryContents((File)this.getIncrementalFolder());
        HashSet<File> androidResources = new HashSet<File>();
        File androidResourceFile = this.getResourceFile();
        if (androidResourceFile != null) {
            androidResources.add(androidResourceFile);
        }
        this.getOutputFile().delete();
        ImmutableMap updatedDex = IncrementalRelativeFileSets.fromZipsAndDirectories(this.getDexFolders());
        ImmutableMap.Builder updatedJavaResourcesBuilder = ImmutableMap.builder();
        for (File javaResourceFile : this.getJavaResourceFiles()) {
            try {
                updatedJavaResourcesBuilder.putAll((Map)(javaResourceFile.isFile() ? IncrementalRelativeFileSets.fromZip((File)javaResourceFile) : IncrementalRelativeFileSets.fromDirectory((File)javaResourceFile)));
            }
            catch (Zip64NotSupportedException e) {
                updatedJavaResourcesBuilder.putAll((Map)IncrementalRelativeFileSets.fromZip((File)PackageAndroidArtifact.copyJavaResourcesOnly(this.getIncrementalFolder(), javaResourceFile)));
            }
        }
        ImmutableMap updatedJavaResources = updatedJavaResourcesBuilder.build();
        ImmutableMap updatedAssets = IncrementalRelativeFileSets.fromZipsAndDirectories(Collections.singleton(this.getAssets()));
        ImmutableMap updatedAndroidResources = IncrementalRelativeFileSets.fromZipsAndDirectories(androidResources);
        ImmutableMap updatedJniResources = IncrementalRelativeFileSets.fromZipsAndDirectories(this.getJniFolders());
        ImmutableMap updatedAtomMetadata = this.getAtomMetadataFolder() == null ? ImmutableMap.of() : IncrementalRelativeFileSets.fromDirectory((File)this.getAtomMetadataFolder());
        this.doTask((ImmutableMap<RelativeFile, FileStatus>)updatedDex, (ImmutableMap<RelativeFile, FileStatus>)updatedJavaResources, (ImmutableMap<RelativeFile, FileStatus>)updatedAssets, (ImmutableMap<RelativeFile, FileStatus>)updatedAndroidResources, (ImmutableMap<RelativeFile, FileStatus>)updatedJniResources, (ImmutableMap<RelativeFile, FileStatus>)updatedAtomMetadata);
        KnownFilesSaveData saveData = KnownFilesSaveData.make(this.getIncrementalFolder());
        saveData.setInputSet((Collection)updatedDex.keySet(), InputSet.DEX);
        saveData.setInputSet((Collection)updatedJavaResources.keySet(), InputSet.JAVA_RESOURCE);
        saveData.setInputSet((Collection)updatedAssets.keySet(), InputSet.ASSET);
        saveData.setInputSet((Collection)updatedAndroidResources.keySet(), InputSet.ANDROID_RESOURCE);
        saveData.setInputSet((Collection)updatedJniResources.keySet(), InputSet.NATIVE_RESOURCE);
        saveData.setInputSet((Collection)updatedAtomMetadata.keySet(), InputSet.ATOM_METADATA);
        saveData.saveCurrentData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static File copyJavaResourcesOnly(File destinationFolder, File zip64File) throws IOException {
        File cacheDir = new File(destinationFolder, ZIP_64_COPY_DIR);
        File copiedZip = new File(cacheDir, zip64File.getName());
        FileUtils.mkdirs((File)copiedZip.getParentFile());
        try (ZipFile inFile = new ZipFile(zip64File);
             ZipOutputStream outFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(copiedZip)));){
            Enumeration<? extends ZipEntry> entries = inFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.getName().endsWith(".class")) continue;
                outFile.putNextEntry(new ZipEntry(zipEntry.getName()));
                try {
                    ByteStreams.copy((InputStream)new BufferedInputStream(inFile.getInputStream(zipEntry)), (OutputStream)outFile);
                }
                finally {
                    outFile.closeEntry();
                }
            }
        }
        return copiedZip;
    }

    private void doTask(ImmutableMap<RelativeFile, FileStatus> changedDex, ImmutableMap<RelativeFile, FileStatus> changedJavaResources, ImmutableMap<RelativeFile, FileStatus> changedAssets, ImmutableMap<RelativeFile, FileStatus> changedAndroidResources, ImmutableMap<RelativeFile, FileStatus> changedNLibs, ImmutableMap<RelativeFile, FileStatus> changedAtomMetadata) throws IOException {
        ImmutableMap.Builder javaResourcesForApk = ImmutableMap.builder();
        javaResourcesForApk.putAll(changedJavaResources);
        switch (this.dexPackagingPolicy) {
            case INSTANT_RUN_SHARDS_IN_SINGLE_APK: {
                ImmutableMap updatedChangedResources;
                Collection instantRunDexBaseFiles = this.getDexFolders().stream().filter(input -> input.getName().contains(INSTANT_RUN_PACKAGES_PREFIX)).collect(Collectors.toSet());
                Iterable nonInstantRunDexBaseFiles = this.getDexFolders().stream().filter(f -> !instantRunDexBaseFiles.contains(f)).collect(Collectors.toSet());
                ImmutableMap<RelativeFile, FileStatus> newInstantRunResources = this.makeInstantRunResourcesFromDex(nonInstantRunDexBaseFiles);
                changedJavaResources = updatedChangedResources = IncrementalRelativeFileSets.union((Iterable)Sets.newHashSet((Object[])new ImmutableMap[]{changedJavaResources, newInstantRunResources}));
                changedDex = ImmutableMap.copyOf((Map)Maps.filterKeys((Map)changedDex, (com.google.common.base.Predicate)Predicates.compose((com.google.common.base.Predicate)Predicates.in((Collection)instantRunDexBaseFiles), RelativeFile::getBase)));
                break;
            }
            case INSTANT_RUN_MULTI_APK: {
                changedDex = ImmutableMap.copyOf((Map)Maps.filterKeys(changedDex, (com.google.common.base.Predicate)Predicates.compose((com.google.common.base.Predicate)Predicates.in(this.getDexFolders()), RelativeFile::getBase)));
            }
            case STANDARD: {
                break;
            }
            default: {
                throw new RuntimeException("Unhandled DexPackagingPolicy : " + this.getDexPackagingPolicy());
            }
        }
        try {
            boolean v2SigningEnabled;
            boolean v1SigningEnabled;
            X509Certificate certificate;
            PrivateKey key;
            if (this.signingConfig != null && this.signingConfig.isSigningReady()) {
                CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)this.signingConfig.getStoreType(), (File)((File)Preconditions.checkNotNull((Object)this.signingConfig.getStoreFile())), (String)((String)Preconditions.checkNotNull((Object)this.signingConfig.getStorePassword())), (String)((String)Preconditions.checkNotNull((Object)this.signingConfig.getKeyPassword())), (String)((String)Preconditions.checkNotNull((Object)this.signingConfig.getKeyAlias())));
                key = certificateInfo.getKey();
                certificate = certificateInfo.getCertificate();
                v1SigningEnabled = this.signingConfig.isV1SigningEnabled();
                v2SigningEnabled = this.signingConfig.isV2SigningEnabled();
            } else {
                key = null;
                certificate = null;
                v1SigningEnabled = false;
                v2SigningEnabled = false;
            }
            ApkCreatorFactory.CreationData creationData = new ApkCreatorFactory.CreationData(this.getOutputFile(), key, certificate, v1SigningEnabled, v2SigningEnabled, null, this.getBuilder().getCreatedBy(), this.getMinSdkVersion(), PackagingUtils.getNativeLibrariesLibrariesPackagingMode((File)this.manifest), this.getNoCompressPredicate());
            this.getLogger().debug("Information to create the APK: apkPath={}, v1SigningEnabled={}, v2SigningEnabled={}, builtBy={}, createdBy={}, minSdkVersion={}, nativeLibrariesPackagingMode={}", new Object[]{creationData.getApkPath(), creationData.isV1SigningEnabled(), creationData.isV2SigningEnabled(), creationData.getBuiltBy(), creationData.getCreatedBy(), creationData.getMinSdkVersion(), creationData.getNativeLibrariesPackagingMode()});
            try (IncrementalPackager packager = this.createPackager(creationData);){
                packager.updateDex(changedDex);
                packager.updateJavaResources(changedJavaResources);
                packager.updateAssets(changedAssets);
                packager.updateAndroidResources(changedAndroidResources);
                packager.updateNativeLibraries(changedNLibs);
                packager.updateAtomMetadata(changedAtomMetadata);
            }
        }
        catch (PackagerException | KeytoolException e) {
            throw new RuntimeException(e);
        }
        Stream.concat(changedDex.keySet().stream(), Stream.concat(changedJavaResources.keySet().stream(), Stream.concat(changedAndroidResources.keySet().stream(), changedNLibs.keySet().stream()))).map(RelativeFile::getBase).filter(File::isFile).distinct().forEach(f -> {
            try {
                this.cacheByPath.add(f);
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        });
        try {
            this.instantRunContext.addChangedFile(this.instantRunFileType, this.getOutputFile());
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private IncrementalPackager createPackager(ApkCreatorFactory.CreationData creationData) throws PackagerException, IOException {
        return new IncrementalPackager(creationData, this.getIncrementalFolder(), ApkCreatorFactories.fromProjectProperties(this.getProject(), this.getDebugBuild()), this.getAbiFilters(), this.getJniDebugBuild());
    }

    @Override
    protected boolean isIncremental() {
        return true;
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws IOException {
        Preconditions.checkNotNull(changedInputs, (Object)"changedInputs == null");
        HashSet<File> androidResources = new HashSet<File>();
        File androidResourceFile = this.getResourceFile();
        if (androidResourceFile != null) {
            androidResources.add(androidResourceFile);
        }
        KnownFilesSaveData saveData = KnownFilesSaveData.make(this.getIncrementalFolder());
        HashSet<Runnable> cacheUpdates = new HashSet<Runnable>();
        ImmutableMap<RelativeFile, FileStatus> changedDexFiles = this.getChangedInputs(changedInputs, saveData, InputSet.DEX, this.getDexFolders(), this.cacheByPath, cacheUpdates);
        ImmutableMap<RelativeFile, FileStatus> changedJavaResources = this.getChangedInputs(changedInputs, saveData, InputSet.JAVA_RESOURCE, this.getJavaResourceFiles(), this.cacheByPath, cacheUpdates);
        ImmutableMap<RelativeFile, FileStatus> changedAssets = this.getChangedInputs(changedInputs, saveData, InputSet.ASSET, Collections.singleton(this.getAssets()), this.cacheByPath, cacheUpdates);
        ImmutableMap<RelativeFile, FileStatus> changedAndroidResources = this.getChangedInputs(changedInputs, saveData, InputSet.ANDROID_RESOURCE, androidResources, this.cacheByPath, cacheUpdates);
        ImmutableMap<RelativeFile, FileStatus> changedNLibs = this.getChangedInputs(changedInputs, saveData, InputSet.NATIVE_RESOURCE, this.getJniFolders(), this.cacheByPath, cacheUpdates);
        ImmutableMap<RelativeFile, FileStatus> changedAtomMetadata = this.getAtomMetadataFolder() == null ? ImmutableMap.of() : this.getChangedInputs(changedInputs, saveData, InputSet.ATOM_METADATA, (Collection<File>)ImmutableList.of((Object)this.getAtomMetadataFolder()), this.cacheByPath, cacheUpdates);
        this.doTask(changedDexFiles, changedJavaResources, changedAssets, changedAndroidResources, changedNLibs, changedAtomMetadata);
        cacheUpdates.forEach(Runnable::run);
        ImmutableMap allDex = IncrementalRelativeFileSets.fromZipsAndDirectories(this.getDexFolders());
        ImmutableMap allJavaResources = IncrementalRelativeFileSets.fromZipsAndDirectories(this.getJavaResourceFiles());
        ImmutableMap allAssets = IncrementalRelativeFileSets.fromZipsAndDirectories(Collections.singleton(this.getAssets()));
        ImmutableMap allAndroidResources = IncrementalRelativeFileSets.fromZipsAndDirectories(androidResources);
        ImmutableMap allJniResources = IncrementalRelativeFileSets.fromZipsAndDirectories(this.getJniFolders());
        ImmutableMap allAtomMetadataFiles = this.getAtomMetadataFolder() == null ? ImmutableMap.of() : IncrementalRelativeFileSets.fromDirectory((File)this.getAtomMetadataFolder());
        saveData.setInputSet((Collection)allDex.keySet(), InputSet.DEX);
        saveData.setInputSet((Collection)allJavaResources.keySet(), InputSet.JAVA_RESOURCE);
        saveData.setInputSet((Collection)allAssets.keySet(), InputSet.ASSET);
        saveData.setInputSet((Collection)allAndroidResources.keySet(), InputSet.ANDROID_RESOURCE);
        saveData.setInputSet((Collection)allJniResources.keySet(), InputSet.NATIVE_RESOURCE);
        saveData.setInputSet((Collection)allAtomMetadataFiles.keySet(), InputSet.ATOM_METADATA);
        saveData.saveCurrentData();
    }

    private ImmutableMap<RelativeFile, FileStatus> getChangedInputs(Map<File, FileStatus> changedInputs, KnownFilesSaveData saveData, InputSet inputSet, Collection<File> baseFiles, FileCacheByPath cacheByPath, Set<Runnable> cacheUpdates) throws IOException {
        Set deletedFiles = Maps.filterValues(changedInputs, (com.google.common.base.Predicate)Predicates.equalTo((Object)FileStatus.REMOVED)).keySet();
        ImmutableSet deletedRelativeFiles = saveData.find(deletedFiles, inputSet);
        Map nonDeletedFiles = Maps.filterValues(changedInputs, (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.equalTo((Object)FileStatus.REMOVED)));
        ImmutableMap nonDeletedRelativeFiles = IncrementalRelativeFileSets.makeFromBaseFiles(baseFiles, (Map)nonDeletedFiles, (FileCacheByPath)cacheByPath, cacheUpdates);
        return new ImmutableMap.Builder().putAll(Maps.asMap((Set)deletedRelativeFiles, (Function)Functions.constant((Object)FileStatus.REMOVED))).putAll((Map)nonDeletedRelativeFiles).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmutableMap<RelativeFile, FileStatus> makeInstantRunResourcesFromDex(Iterable<File> dexBaseFiles) throws IOException {
        File tmpZipFile = new File(this.instantRunSupportDir, "instant-run.zip");
        boolean existedBefore = tmpZipFile.exists();
        Files.createParentDirs((File)tmpZipFile);
        zipFile.setLevel(0);
        try (ZipOutputStream zipFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tmpZipFile)));){
            for (File dexFolder : dexBaseFiles) {
                for (File file : Files.fileTreeTraverser().breadthFirstTraversal((Object)dexFolder)) {
                    if (!file.isFile() || !file.getName().endsWith(".dex")) continue;
                    String entryName = file.getParentFile().getName() + "-" + file.getName();
                    zipFile.putNextEntry(new ZipEntry(entryName));
                    try {
                        Files.copy((File)file, (OutputStream)zipFile);
                    }
                    finally {
                        zipFile.closeEntry();
                    }
                }
            }
        }
        RelativeFile resourcesFile = new RelativeFile(this.instantRunSupportDir, tmpZipFile);
        return ImmutableMap.of((Object)resourcesFile, (Object)(existedBefore ? FileStatus.CHANGED : FileStatus.NEW));
    }

    public File get() {
        return this.getOutputFile();
    }

    @Override
    public Task getTask() {
        return this;
    }

    public static abstract class ConfigAction<T extends PackageAndroidArtifact>
    implements TaskConfigAction<T> {
        protected final PackagingScope packagingScope;
        protected final DexPackagingPolicy dexPackagingPolicy;

        public ConfigAction(PackagingScope packagingScope, InstantRunPatchingPolicy patchingPolicy) {
            this.packagingScope = (PackagingScope)Preconditions.checkNotNull((Object)packagingScope);
            this.dexPackagingPolicy = patchingPolicy == null ? DexPackagingPolicy.STANDARD : patchingPolicy.getDexPatchingPolicy();
        }

        @Override
        public void execute(T packageAndroidArtifact) {
            ((PackageAndroidArtifact)packageAndroidArtifact).instantRunFileType = FileType.MAIN;
            ((BaseTask)((Object)packageAndroidArtifact)).setAndroidBuilder(this.packagingScope.getAndroidBuilder());
            ((DefaultAndroidTask)((Object)packageAndroidArtifact)).setVariantName(this.packagingScope.getFullVariantName());
            ((PackageAndroidArtifact)packageAndroidArtifact).setMinSdkVersion(this.packagingScope.getMinSdkVersion());
            ((PackageAndroidArtifact)packageAndroidArtifact).instantRunContext = this.packagingScope.getInstantRunBuildContext();
            ((PackageAndroidArtifact)packageAndroidArtifact).dexPackagingPolicy = this.dexPackagingPolicy;
            ((PackageAndroidArtifact)packageAndroidArtifact).instantRunSupportDir = this.packagingScope.getInstantRunSupportDir();
            ((IncrementalTask)((Object)packageAndroidArtifact)).setIncrementalFolder(this.packagingScope.getIncrementalDir(packageAndroidArtifact.getName()));
            ((PackageAndroidArtifact)packageAndroidArtifact).aaptOptions = this.packagingScope.getAaptOptions();
            ((PackageAndroidArtifact)packageAndroidArtifact).manifest = this.packagingScope.getManifestFile();
            File cacheByPathDir = new File(((IncrementalTask)((Object)packageAndroidArtifact)).getIncrementalFolder(), PackageAndroidArtifact.ZIP_DIFF_CACHE_DIR);
            FileUtils.mkdirs((File)cacheByPathDir);
            ((PackageAndroidArtifact)packageAndroidArtifact).cacheByPath = new FileCacheByPath(cacheByPathDir);
            ConventionMappingHelper.map(packageAndroidArtifact, "resourceFile", this.packagingScope::getFinalResourcesFile);
            ConventionMappingHelper.map(packageAndroidArtifact, "dexFolders", () -> this.packagingScope.getDexFolders());
            ConventionMappingHelper.map(packageAndroidArtifact, "javaResourceFiles", this.packagingScope::getJavaResources);
            ((PackageAndroidArtifact)packageAndroidArtifact).setAssets(this.packagingScope.getAssetsDir());
            ConventionMappingHelper.map(packageAndroidArtifact, "jniFolders", () -> {
                if (this.packagingScope.getSplitHandlingPolicy() == SplitHandlingPolicy.PRE_21_POLICY) {
                    return this.packagingScope.getJniFolders();
                }
                ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(this.packagingScope.getAbiFilters());
                return filters.isEmpty() ? this.packagingScope.getJniFolders() : Collections.emptySet();
            });
            ConventionMappingHelper.map(packageAndroidArtifact, "abiFilters", () -> {
                String filter = this.packagingScope.getMainOutputFile().getFilter(OutputFile.ABI);
                if (filter != null) {
                    return ImmutableSet.of((Object)filter);
                }
                Set<String> supportedAbis = this.packagingScope.getSupportedAbis();
                if (supportedAbis != null) {
                    return supportedAbis;
                }
                return ImmutableSet.of();
            });
            ConventionMappingHelper.map(packageAndroidArtifact, "jniDebugBuild", this.packagingScope::isJniDebuggable);
            ConventionMappingHelper.map(packageAndroidArtifact, "debugBuild", this.packagingScope::isDebuggable);
            ((PackageAndroidArtifact)packageAndroidArtifact).setSigningConfig(this.packagingScope.getSigningConfig());
            ConventionMappingHelper.map(packageAndroidArtifact, "packagingOptions", this.packagingScope::getPackagingOptions);
        }
    }

    private static enum InputSet {
        DEX,
        JAVA_RESOURCE,
        NATIVE_RESOURCE,
        ANDROID_RESOURCE,
        ASSET,
        ATOM_METADATA;

    }

    private static class KnownFilesSaveData {
        private static final String SAVE_DATA_FILE_NAME = "file-input-save-data.txt";
        private static final String COUNT_PROPERTY = "count";
        private static final String BASE_SUFFIX = ".base";
        private static final String FILE_SUFFIX = ".file";
        private static final String INPUT_SET_SUFFIX = ".set";
        private static final Map<File, CachedFileContents<KnownFilesSaveData>> mCache = Maps.newHashMap();
        private final CachedFileContents<KnownFilesSaveData> mFileContentsCache;
        private final Map<RelativeFile, InputSet> mFiles;
        private boolean mDirty;

        private KnownFilesSaveData(CachedFileContents<KnownFilesSaveData> cache) throws IOException {
            this.mFileContentsCache = cache;
            this.mFiles = Maps.newHashMap();
            if (cache.getFile().isFile()) {
                this.readCurrentData();
            }
            this.mDirty = false;
        }

        private static synchronized KnownFilesSaveData make(File intermediateDir) throws IOException {
            KnownFilesSaveData saveData;
            File saveFile = KnownFilesSaveData.computeSaveFile(intermediateDir);
            CachedFileContents cached = mCache.get(saveFile);
            if (cached == null) {
                cached = new CachedFileContents(saveFile);
                mCache.put(saveFile, (CachedFileContents<KnownFilesSaveData>)cached);
            }
            if ((saveData = (KnownFilesSaveData)cached.getCache()) == null) {
                saveData = new KnownFilesSaveData((CachedFileContents<KnownFilesSaveData>)cached);
                cached.closed((Object)saveData);
            }
            return saveData;
        }

        private static File computeSaveFile(File intermediateDir) {
            return new File(intermediateDir, SAVE_DATA_FILE_NAME);
        }

        private void readCurrentData() throws IOException {
            int fileCount;
            Closer closer = Closer.create();
            File saveFile = this.mFileContentsCache.getFile();
            Properties properties = new Properties();
            try {
                Reader saveDataReader = (Reader)closer.register((Closeable)new FileReader(saveFile));
                properties.load(saveDataReader);
            }
            catch (Throwable t) {
                throw closer.rethrow(t);
            }
            finally {
                closer.close();
            }
            String fileCountText = null;
            try {
                fileCountText = properties.getProperty(COUNT_PROPERTY);
                if (fileCountText == null) {
                    throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + COUNT_PROPERTY + "' has no value).");
                }
                fileCount = Integer.parseInt(fileCountText);
                if (fileCount < 0) {
                    throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + COUNT_PROPERTY + "' has value " + fileCount + ").");
                }
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + COUNT_PROPERTY + "' has value '" + fileCountText + "').", e);
            }
            for (int i = 0; i < fileCount; ++i) {
                InputSet is;
                String baseName = properties.getProperty(i + BASE_SUFFIX);
                if (baseName == null) {
                    throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + i + BASE_SUFFIX + "' has no value).");
                }
                String fileName = properties.getProperty(i + FILE_SUFFIX);
                if (fileName == null) {
                    throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + i + FILE_SUFFIX + "' has no value).");
                }
                String inputSetName = properties.getProperty(i + INPUT_SET_SUFFIX);
                if (inputSetName == null) {
                    throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + i + INPUT_SET_SUFFIX + "' has no value).");
                }
                try {
                    is = InputSet.valueOf(InputSet.class, inputSetName);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + i + INPUT_SET_SUFFIX + "' has invalid value '" + inputSetName + "').");
                }
                this.mFiles.put(new RelativeFile(new File(baseName), new File(fileName)), is);
            }
        }

        private void saveCurrentData() throws IOException {
            if (!this.mDirty) {
                return;
            }
            Closer closer = Closer.create();
            Properties properties = new Properties();
            properties.put(COUNT_PROPERTY, Integer.toString(this.mFiles.size()));
            int idx = 0;
            for (Map.Entry<RelativeFile, InputSet> e : this.mFiles.entrySet()) {
                RelativeFile rf = e.getKey();
                String basePath = (String)Verify.verifyNotNull((Object)rf.getBase().getPath());
                Verify.verify((!basePath.isEmpty() ? 1 : 0) != 0);
                String filePath = (String)Verify.verifyNotNull((Object)rf.getFile().getPath());
                Verify.verify((!filePath.isEmpty() ? 1 : 0) != 0);
                properties.put(idx + BASE_SUFFIX, basePath);
                properties.put(idx + FILE_SUFFIX, filePath);
                properties.put(idx + INPUT_SET_SUFFIX, e.getValue().name());
                ++idx;
            }
            try {
                Writer saveDataWriter = (Writer)closer.register((Closeable)new FileWriter(this.mFileContentsCache.getFile()));
                properties.store(saveDataWriter, "Internal package file, do not edit.");
                this.mFileContentsCache.closed((Object)this);
            }
            catch (Throwable t) {
                throw closer.rethrow(t);
            }
            finally {
                closer.close();
            }
        }

        private ImmutableSet<RelativeFile> find(Set<File> files, InputSet inputSet) {
            HashSet found = Sets.newHashSet();
            for (RelativeFile rf : Maps.filterValues(this.mFiles, (com.google.common.base.Predicate)Predicates.equalTo((Object)((Object)inputSet))).keySet()) {
                if (!files.contains(rf.getFile())) continue;
                found.add(rf);
            }
            return ImmutableSet.copyOf((Collection)found);
        }

        private java.util.function.Function<File, RelativeFile> inInputSet(InputSet inputSet) {
            Map inverseFiltered = this.mFiles.entrySet().stream().filter(e -> e.getValue() == inputSet).map(Map.Entry::getKey).collect(HashMap::new, (m, rf) -> m.put(rf.getFile(), rf), Map::putAll);
            return inverseFiltered::get;
        }

        private void setInputSet(Collection<RelativeFile> files, InputSet set) {
            Iterator<Map.Entry<RelativeFile, InputSet>> it = this.mFiles.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<RelativeFile, InputSet> next = it.next();
                if (next.getValue() != set || files.contains(next.getKey())) continue;
                it.remove();
                this.mDirty = true;
            }
            files.forEach(f -> {
                if (!this.mFiles.containsKey(f)) {
                    this.mFiles.put((RelativeFile)f, set);
                    this.mDirty = true;
                }
            });
        }
    }
}

