/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.ide.FilterDataImpl;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.SplitRelatedTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.SigningException;
import com.android.builder.packaging.ZipAbortException;
import com.android.ide.common.signing.KeytoolException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Callables;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class PackageSplitRes
extends SplitRelatedTask {
    private Set<String> densitySplits;
    private Set<String> languageSplits;
    private String outputBaseName;
    private SigningConfig signingConfig;
    private File inputDirectory;
    private File outputDirectory;

    @InputFiles
    public List<File> getInputFiles() {
        final ImmutableList.Builder builder = ImmutableList.builder();
        this.forEachInputFile(new SplitFileHandler(){

            @Override
            public void execute(String split, File file) {
                builder.add((Object)file);
            }
        });
        return builder.build();
    }

    @OutputFiles
    public List<File> getOutputFiles() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ApkOutputFile apk : this.getOutputSplitFiles()) {
            builder.add((Object)apk.getOutputFile());
        }
        return builder.build();
    }

    @Override
    public File getApkMetadataFile() {
        return null;
    }

    @Override
    public List<ApkOutputFile> getOutputSplitFiles() {
        final ImmutableList.Builder builder = ImmutableList.builder();
        this.forEachInputFile(new SplitFileHandler(){

            @Override
            public void execute(String split, File file) {
                FilterData filterData = null;
                for (String density : PackageSplitRes.this.densitySplits) {
                    if (!split.startsWith(density)) continue;
                    filterData = FilterDataImpl.build(OutputFile.FilterType.DENSITY.toString(), density);
                }
                if (PackageSplitRes.this.languageSplits.contains(PackageSplitRes.unMangleSplitName(split))) {
                    filterData = FilterDataImpl.build(OutputFile.FilterType.LANGUAGE.toString(), PackageSplitRes.unMangleSplitName(split));
                }
                if (filterData != null) {
                    builder.add((Object)new ApkOutputFile(OutputFile.OutputType.SPLIT, (Collection<FilterData>)ImmutableList.of((Object)filterData), Callables.returning((Object)new File(PackageSplitRes.this.outputDirectory, PackageSplitRes.this.getOutputFileNameForSplit(split)))));
                }
            }
        });
        return builder.build();
    }

    @TaskAction
    protected void doFullTaskAction() {
        this.forEachInputFile(new SplitFileHandler(){

            @Override
            public void execute(String split, File file) {
                File outFile = new File(PackageSplitRes.this.outputDirectory, PackageSplitRes.this.getOutputFileNameForSplit(split));
                try {
                    AndroidBuilder.signApk((File)file, (SigningConfig)PackageSplitRes.this.signingConfig, (File)outFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (KeytoolException e) {
                    throw new RuntimeException(e);
                }
                catch (SigningException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                catch (ZipAbortException e) {
                    throw new RuntimeException(e);
                }
                catch (com.android.builder.signing.SigningException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void forEachInputFile(SplitFileHandler handler) {
        Pattern resourcePattern = Pattern.compile("resources-" + this.outputBaseName + ".ap__(.*)");
        ArrayList densitiesCopy = Lists.newArrayList(this.densitySplits);
        ArrayList languagesCopy = Lists.newArrayList(this.languageSplits);
        File[] fileLists = this.inputDirectory.listFiles();
        if (fileLists != null) {
            for (File file : fileLists) {
                Matcher match = resourcePattern.matcher(file.getName());
                if (!match.matches() || match.group(1).isEmpty() || !PackageSplitRes.isValidSplit(densitiesCopy, languagesCopy, match.group(1))) continue;
                handler.execute(match.group(1), file);
            }
        }
        for (String density : densitiesCopy) {
            handler.execute(density, new File(this.inputDirectory, "resources-" + this.outputBaseName + ".ap__" + density));
        }
        for (String language : languagesCopy) {
            handler.execute(language, new File(this.inputDirectory, "resources-" + this.outputBaseName + ".ap__" + language));
        }
    }

    private static boolean isValidSplit(List<String> densities, List<String> languages, String splitWithOptionalSuffix) {
        for (String density : densities) {
            if (!splitWithOptionalSuffix.startsWith(density)) continue;
            densities.remove(density);
            return true;
        }
        String mangledName = PackageSplitRes.unMangleSplitName(splitWithOptionalSuffix);
        if (languages.contains(mangledName)) {
            languages.remove(mangledName);
            return true;
        }
        return false;
    }

    public String getOutputFileNameForSplit(String split) {
        String archivesBaseName = (String)this.getProject().getProperties().get("archivesBaseName");
        String apkName = archivesBaseName + "-" + this.outputBaseName + "_" + split;
        return apkName + (this.signingConfig == null ? "-unsigned.apk" : "-unaligned.apk");
    }

    @Override
    public List<FilterData> getSplitsData() {
        ImmutableList.Builder filterDataBuilder = ImmutableList.builder();
        PackageSplitRes.addAllFilterData((ImmutableList.Builder<FilterData>)filterDataBuilder, this.densitySplits, OutputFile.FilterType.DENSITY);
        PackageSplitRes.addAllFilterData((ImmutableList.Builder<FilterData>)filterDataBuilder, this.languageSplits, OutputFile.FilterType.LANGUAGE);
        return filterDataBuilder.build();
    }

    public static String unMangleSplitName(String splitWithOptionalSuffix) {
        String mangledName = splitWithOptionalSuffix.replaceAll("_", ",");
        return mangledName.contains("-r") ? mangledName : mangledName.replace("-", "-r");
    }

    @Input
    public Set<String> getDensitySplits() {
        return this.densitySplits;
    }

    public void setDensitySplits(Set<String> densitySplits) {
        this.densitySplits = densitySplits;
    }

    @Input
    public Set<String> getLanguageSplits() {
        return this.languageSplits;
    }

    public void setLanguageSplits(Set<String> languageSplits) {
        this.languageSplits = languageSplits;
    }

    @Input
    public String getOutputBaseName() {
        return this.outputBaseName;
    }

    public void setOutputBaseName(String outputBaseName) {
        this.outputBaseName = outputBaseName;
    }

    @Nested
    @Optional
    public SigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    public void setSigningConfig(SigningConfig signingConfig) {
        this.signingConfig = signingConfig;
    }

    public File getInputDirectory() {
        return this.inputDirectory;
    }

    public void setInputDirectory(File inputDirectory) {
        this.inputDirectory = inputDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public static class ConfigAction
    implements TaskConfigAction<PackageSplitRes> {
        private VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("package", "SplitResources");
        }

        @Override
        public Class<PackageSplitRes> getType() {
            return PackageSplitRes.class;
        }

        @Override
        public void execute(PackageSplitRes packageSplitResourcesTask) {
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            GradleVariantConfiguration config = variantData.getVariantConfiguration();
            Set<String> densityFilters = variantData.getFilters(OutputFile.FilterType.DENSITY);
            Set<String> languageFilters = variantData.getFilters(OutputFile.FilterType.LANGUAGE);
            BaseVariantOutputData variantOutputData = variantData.getMainOutput();
            variantOutputData.packageSplitResourcesTask = packageSplitResourcesTask;
            VariantOutputScope variantOutputScope = variantOutputData.getScope();
            packageSplitResourcesTask.setInputDirectory(variantOutputScope.getProcessResourcePackageOutputFile().getParentFile());
            packageSplitResourcesTask.setDensitySplits(densityFilters);
            packageSplitResourcesTask.setLanguageSplits(languageFilters);
            packageSplitResourcesTask.setOutputBaseName(config.getBaseName());
            packageSplitResourcesTask.setSigningConfig(config.getSigningConfig());
            packageSplitResourcesTask.setOutputDirectory(this.scope.getSplitOutputDirectory());
            packageSplitResourcesTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            packageSplitResourcesTask.setVariantName(config.getFullName());
            packageSplitResourcesTask.dependsOn(new Object[]{variantOutputScope.getProcessResourcesTask().getName()});
        }
    }

    private static interface SplitFileHandler {
        public void execute(String var1, File var2);
    }
}

