/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.dependency.level2.AtomDependency;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.MergingLogRewriter;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.blame.parser.aapt.AaptOutputParser;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.tooling.BuildException;

@ParallelizableTask
public class ProcessInstantAppResources
extends IncrementalTask {
    private File manifestFile;
    private Set<File> atomResourcePackages;
    private File baseAtomResourcePackage;
    private VariantType type;
    private boolean debuggable;
    private boolean pseudoLocalesEnabled;
    private AaptOptions aaptOptions;
    private File outputResourcePackage;
    private File mergeBlameLogFolder;
    private VariantScope variantScope;

    @Override
    public void doFullTaskAction() throws IOException {
        AndroidBuilder builder = this.getBuilder();
        MergingLog mergingLog = new MergingLog(this.getMergeBlameLogFolder());
        ParsingProcessOutputHandler processOutputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new AaptOutputParser(), this.getILogger()), new MessageReceiver[]{new MergingLogRewriter(mergingLog, (MessageReceiver)builder.getErrorReporter())});
        try {
            Aapt aapt = AaptGradleFactory.make(this.getBuilder(), (ProcessOutputHandler)processOutputHandler, true, this.variantScope.getGlobalScope().getProject(), VariantType.INSTANTAPP, FileUtils.mkdirs((File)new File(this.getIncrementalFolder(), "aapt-temp")), this.aaptOptions.getCruncherProcesses());
            AaptPackageConfig.Builder config = new AaptPackageConfig.Builder().setManifestFile(this.getManifestFile()).setOptions((com.android.builder.model.AaptOptions)this.getAaptOptions()).setResourceOutputApk(this.getOutputResourcePackage()).setVariantType(this.getType()).setDebuggable(this.getDebuggable()).setPseudoLocalize(this.getPseudoLocalesEnabled()).setBaseFeature(this.getBaseAtomResourcePackage()).setPreviousFeatures(this.getAtomResourcePackages());
            builder.processResources(aapt, config, true);
        }
        catch (ProcessException | IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @InputFile
    public File getManifestFile() {
        return this.manifestFile;
    }

    public void setManifestFile(File manifestFile) {
        this.manifestFile = manifestFile;
    }

    @InputFiles
    public Set<File> getAtomResourcePackages() {
        return this.atomResourcePackages;
    }

    public void setAtomResourcePackages(Set<File> atomResourcePackages) {
        this.atomResourcePackages = atomResourcePackages;
    }

    @InputFile
    public File getBaseAtomResourcePackage() {
        return this.baseAtomResourcePackage;
    }

    public void setBaseAtomResourcePackage(File baseAtomResourcePackage) {
        this.baseAtomResourcePackage = baseAtomResourcePackage;
    }

    @Input
    public VariantType getType() {
        return this.type;
    }

    public void setType(VariantType type) {
        this.type = type;
    }

    @Input
    public boolean getDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    @Input
    public boolean getPseudoLocalesEnabled() {
        return this.pseudoLocalesEnabled;
    }

    public void setPseudoLocalesEnabled(boolean pseudoLocalesEnabled) {
        this.pseudoLocalesEnabled = pseudoLocalesEnabled;
    }

    @Nested
    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    public void setAaptOptions(AaptOptions aaptOptions) {
        this.aaptOptions = aaptOptions;
    }

    @OutputFile
    public File getOutputResourcePackage() {
        return this.outputResourcePackage;
    }

    public void setOutputResourcePackage(File outputResourcePackage) {
        this.outputResourcePackage = outputResourcePackage;
    }

    @OutputDirectory
    public File getMergeBlameLogFolder() {
        return this.mergeBlameLogFolder;
    }

    public void setMergeBlameLogFolder(File mergeBlameLogFolder) {
        this.mergeBlameLogFolder = mergeBlameLogFolder;
    }

    public static class ConfigAction
    implements TaskConfigAction<ProcessInstantAppResources> {
        private VariantOutputScope scope;

        public ConfigAction(VariantOutputScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("process", "InstantAppResources");
        }

        @Override
        public Class<ProcessInstantAppResources> getType() {
            return ProcessInstantAppResources.class;
        }

        @Override
        public void execute(ProcessInstantAppResources processInstantAppResources) throws BuildException {
            GradleVariantConfiguration config = this.scope.getVariantScope().getVariantConfiguration();
            processInstantAppResources.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            processInstantAppResources.setVariantName(config.getFullName());
            processInstantAppResources.variantScope = this.scope.getVariantScope();
            processInstantAppResources.setIncrementalFolder(this.scope.getVariantScope().getIncrementalDir(this.getName()));
            ConventionMappingHelper.map((Task)processInstantAppResources, "manifestFile", this.scope.getVariantOutputData().manifestProcessorTask::getOutputFile);
            processInstantAppResources.setType(config.getType());
            processInstantAppResources.setDebuggable(((CoreBuildType)config.getBuildType()).isDebuggable());
            processInstantAppResources.setAaptOptions(this.scope.getGlobalScope().getExtension().getAaptOptions());
            processInstantAppResources.setPseudoLocalesEnabled(((CoreBuildType)config.getBuildType()).isPseudoLocalesEnabled());
            processInstantAppResources.setMergeBlameLogFolder(this.scope.getVariantScope().getResourceBlameLogDir());
            processInstantAppResources.setOutputResourcePackage(this.scope.getProcessResourcePackageOutputFile());
            AtomDependency baseAtom = config.getPackageDependencies().getBaseAtom();
            if (baseAtom == null) {
                return;
            }
            processInstantAppResources.setBaseAtomResourcePackage(baseAtom.getResourcePackage());
            ImmutableList androidAtoms = config.getFlatAndroidAtomsDependencies();
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (AtomDependency atom : androidAtoms) {
                if (atom == baseAtom) continue;
                builder.add((Object)this.scope.getProcessResourcePackageOutputFile(atom));
            }
            processInstantAppResources.setAtomResourcePackages((Set<File>)builder.build());
        }
    }
}

