/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.dsl.CoreAnnotationProcessorOptions;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.tasks.factory.AbstractCompilesUtil;
import com.android.build.gradle.tasks.factory.AndroidJavaCompile;
import com.android.builder.dependency.level2.AtomDependency;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.compile.AbstractCompile;

public class AtomResClassJavaCompileConfigAction
implements TaskConfigAction<AndroidJavaCompile> {
    private static final ILogger LOG = LoggerWrapper.getLogger(AtomResClassJavaCompileConfigAction.class);
    private VariantScope scope;
    private AtomDependency atomDependency;

    public AtomResClassJavaCompileConfigAction(VariantScope scope, AtomDependency atomDependency) {
        this.scope = scope;
        this.atomDependency = atomDependency;
    }

    @Override
    public String getName() {
        return this.scope.getTaskName("compile", StringHelper.capitalize((String)this.atomDependency.getAtomName()) + "ResClassWithJavac");
    }

    @Override
    public Class<AndroidJavaCompile> getType() {
        return AndroidJavaCompile.class;
    }

    @Override
    public void execute(AndroidJavaCompile javacTask) {
        boolean keepDefaultBootstrap;
        javacTask.compileSdkVersion = this.scope.getGlobalScope().getExtension().getCompileSdkVersion();
        javacTask.mBuildContext = this.scope.getInstantRunBuildContext();
        javacTask.source(new Object[]{this.scope.getRClassSourceOutputDir(this.atomDependency)});
        javacTask.setDestinationDir(this.scope.getJavaOutputDir(this.atomDependency));
        CompileOptions compileOptions = this.scope.getGlobalScope().getExtension().getCompileOptions();
        AbstractCompilesUtil.configureLanguageLevel((AbstractCompile)javacTask, compileOptions, this.scope.getGlobalScope().getExtension().getCompileSdkVersion(), this.scope.getVariantConfiguration().getJackOptions().isEnabled());
        javacTask.getOptions().setEncoding(compileOptions.getEncoding());
        Project project = this.scope.getGlobalScope().getProject();
        CoreAnnotationProcessorOptions annotationProcessorOptions = this.scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions();
        Preconditions.checkNotNull((Object)annotationProcessorOptions.getIncludeCompileClasspath());
        ArrayList processorPath = Lists.newArrayList(this.scope.getVariantData().getVariantDependency().resolveAndGetAnnotationProcessorClassPath(annotationProcessorOptions.getIncludeCompileClasspath(), this.scope.getGlobalScope().getAndroidBuilder().getErrorReporter()));
        boolean bl = keepDefaultBootstrap = this.scope.getVariantConfiguration().getJackOptions().isEnabled() != false && JavaVersion.current().isJava8Compatible();
        if (!keepDefaultBootstrap) {
            javacTask.getOptions().setBootClasspath(Joiner.on((String)File.pathSeparator).join((Iterable)this.scope.getGlobalScope().getAndroidBuilder().getBootClasspathAsStrings(false)));
        }
        ConventionMappingHelper.map((Task)javacTask, "classpath", () -> AtomResClassJavaCompileConfigAction.lambda$execute$0(this.scope.getGlobalScope().getProject()));
        boolean incremental = AbstractCompilesUtil.isIncremental(project, this.scope, compileOptions, processorPath, LOG);
        if (incremental) {
            LOG.info("Using incremental javac compilation.", new Object[0]);
            javacTask.getOptions().setIncremental(true);
        } else {
            LOG.info("Not using incremental javac compilation.", new Object[0]);
        }
    }

    private static /* synthetic */ Object lambda$execute$0(Project rec$) throws Exception {
        return rec$.files(new Object[0]);
    }
}

