/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api.dsl.sealing;

import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.build.gradle.internal.api.dsl.sealing.Sealable;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Named;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\u000bJ\b\u0010\r\u001a\u00020\u0006H\u0002J\u0006\u0010\u000e\u001a\u00020\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/api/dsl/sealing/SealableObject;", "Lcom/android/build/gradle/internal/api/dsl/sealing/Sealable;", "dslScope", "Lcom/android/build/gradle/internal/api/dsl/DslScope;", "(Lcom/android/build/gradle/internal/api/dsl/DslScope;)V", "name", "", "(Lcom/android/build/gradle/internal/api/dsl/DslScope;Ljava/lang/String;)V", "getDslScope$gradle", "()Lcom/android/build/gradle/internal/api/dsl/DslScope;", "sealed", "", "checkSeal", "computeName", "isSealed", "seal", "", "gradle"})
public abstract class SealableObject
implements Sealable {
    private boolean sealed;
    @NotNull
    private final DslScope dslScope;
    private final String name;

    @Override
    public void seal() {
        if (this.sealed) {
            String className = this.getClass().getName();
            String itemNameStr = this.computeName();
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Attempting to seal object" + itemNameStr + " of type " + className + " after it's been sealed.", null, null, 6, null));
        }
        this.sealed = true;
    }

    public final boolean isSealed() {
        return this.sealed;
    }

    public final boolean checkSeal() {
        if (this.sealed) {
            String className = this.getClass().getName();
            String itemNameStr = this.computeName();
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Attempting to modify object" + itemNameStr + " of type " + className + " after it's been sealed.", className, null, 4, null));
            return false;
        }
        return true;
    }

    private final String computeName() {
        String itemName;
        String string = this.name;
        if (string == null) {
            string = this instanceof Named ? this.name : null;
        }
        return (itemName = string) != null ? " '" + itemName + '\'' : "";
    }

    @NotNull
    public final DslScope getDslScope$gradle() {
        return this.dslScope;
    }

    public SealableObject(@NotNull DslScope dslScope, @Nullable String name) {
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        this.dslScope = dslScope;
        this.name = name;
    }

    public SealableObject(@NotNull DslScope dslScope) {
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        this(dslScope, null);
    }
}

