/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.VariantOutput;
import com.android.ide.common.build.ApkData;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class OutputScope
implements Serializable {
    private final List<ApkData> apkDatas;

    public OutputScope() {
        this.apkDatas = new ArrayList<ApkData>();
    }

    public OutputScope(Collection<ApkData> apkDatas) {
        this.apkDatas = new ArrayList<ApkData>(apkDatas);
    }

    void addSplit(ApkData apkData) {
        this.apkDatas.add(apkData);
    }

    public List<ApkData> getApkDatas() {
        return this.apkDatas.stream().filter(ApkData::isEnabled).collect(Collectors.toList());
    }

    public ApkData getMainSplit() {
        Optional<ApkData> splitsByType = this.apkDatas.stream().filter(apkInfo -> apkInfo.getType() == VariantOutput.OutputType.MAIN).findFirst();
        if (splitsByType.isPresent()) {
            return splitsByType.get();
        }
        Optional<ApkData> universal = this.getApkDatas().stream().filter(split -> "universal".equals(split.getFilterName())).findFirst();
        if (universal.isPresent()) {
            return universal.get();
        }
        Optional<ApkData> firstFullSplit = this.getApkDatas().stream().filter(split -> split.getType() == VariantOutput.OutputType.FULL_SPLIT).findFirst();
        if (firstFullSplit.isPresent()) {
            return firstFullSplit.get();
        }
        throw new RuntimeException(String.format("Cannot determine main APK output from %1$s", Joiner.on((String)":").join(this.apkDatas)));
    }

    public List<ApkData> getSplitsByType(VariantOutput.OutputType outputType) {
        return this.apkDatas.stream().filter(split -> split.getType() == outputType).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OutputScope that = (OutputScope)o;
        return Objects.equals(this.apkDatas, that.apkDatas);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.apkDatas);
    }
}

