/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.cdt.utils.coff.ReadMemoryAccess;

public class Coff {
    public static final String NL = System.getProperty("line.separator", "\n");

    public static class FileHeader {
        public int f_nscns;
        public int f_symptr;
        public int f_nsyms;
        public int f_opthdr;
    }

    public static class SectionHeader {
        public byte[] s_name = new byte[8];
        public int s_paddr;
        public int s_vaddr;
        public int s_size;
        public int s_scnptr;
        public int s_relptr;
        public int s_lnnoptr;
        public int s_nreloc;
        public int s_nlnno;
        public int s_flags;
        RandomAccessFile sfile;

        public SectionHeader(RandomAccessFile file, long offset) throws IOException {
            this.sfile = file;
            file.seek(offset);
            byte[] hdr = new byte[40];
            file.readFully(hdr);
            ReadMemoryAccess memory = new ReadMemoryAccess(hdr, true);
            memory.getBytes(this.s_name);
            this.s_paddr = memory.getInt();
            this.s_vaddr = memory.getInt();
            this.s_size = memory.getInt();
            this.s_scnptr = memory.getInt();
            this.s_relptr = memory.getInt();
            this.s_lnnoptr = memory.getInt();
            this.s_nreloc = memory.getUnsignedShort();
            this.s_nlnno = memory.getUnsignedShort();
            this.s_flags = memory.getInt();
        }

        public ByteBuffer mapSectionData() throws IOException {
            return this.sfile.getChannel().map(FileChannel.MapMode.READ_ONLY, this.s_scnptr, this.s_paddr).load().asReadOnlyBuffer();
        }
    }
}

