/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.analytics;

import com.intellij.internal.statistic.analytics.StudioCrashDetails;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class StudioCrashDetection {
    private static final String RECORD_FILE_KEY = "studio.record.file";
    private static final String PLATFORM_PREFIX = "AndroidStudio";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private StudioCrashDetection() {
    }

    public static void start() {
        block17: {
            if (System.getProperty(RECORD_FILE_KEY) != null) {
                throw new AssertionError((Object)"StudioCrashDetection.start called more than once");
            }
            try {
                File f = new File(PathManager.getTempPath(), String.format("%s.%s", PLATFORM_PREFIX, UUID.randomUUID().toString()));
                if (!f.createNewFile()) break block17;
                System.setProperty(RECORD_FILE_KEY, f.getAbsolutePath());
                try (FileWriter fw = new FileWriter(f);){
                    List lines;
                    File buildInfo = new File(PathManager.getHomePath(), "build.txt");
                    if (!buildInfo.exists() && SystemInfo.isMac) {
                        buildInfo = new File(PathManager.getHomePath(), "Resources/build.txt");
                    }
                    String buildVersion = "<unknown>";
                    if (buildInfo.exists() && !(lines = FileUtil.loadLines((File)buildInfo)).isEmpty()) {
                        buildVersion = (String)lines.get(0);
                    }
                    fw.write(buildVersion);
                    fw.write(LINE_SEPARATOR);
                    fw.write(System.getProperty("java.runtime.version"));
                    fw.write(LINE_SEPARATOR);
                    fw.write(String.valueOf(ManagementFactory.getRuntimeMXBean().getStartTime()));
                    fw.write(LINE_SEPARATOR);
                    fw.write(String.valueOf(StudioCrashDetection.getMyPID()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static long getMyPID() {
        String pidAndMachineName = ManagementFactory.getRuntimeMXBean().getName();
        String[] split = pidAndMachineName.split("@");
        long pid = -1L;
        if (split.length == 2) {
            try {
                pid = Long.parseLong(split[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pid;
    }

    public static void updateRecordedVersionNumber(@NotNull String version) {
        String recordFileName;
        if (version == null) {
            StudioCrashDetection.$$$reportNull$$$0(0);
        }
        if ((recordFileName = System.getProperty(RECORD_FILE_KEY)) != null) {
            File recordFile = new File(recordFileName);
            try {
                List lines = FileUtil.loadLines((File)recordFile);
                lines.set(0, version);
                try (FileWriter fw = new FileWriter(recordFile);){
                    for (String line : lines) {
                        fw.write(line);
                        fw.write(LINE_SEPARATOR);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void stop() {
        String recordFileName = System.getProperty(RECORD_FILE_KEY);
        if (recordFileName != null) {
            FileUtil.delete((File)new File(recordFileName));
            System.clearProperty(RECORD_FILE_KEY);
        }
    }

    public static List<StudioCrashDetails> reapCrashDescriptions() {
        File[] previousRecords = new File(PathManager.getTempPath()).listFiles(new FileFilter(){
            final String recordFile = System.getProperty("studio.record.file");

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(StudioCrashDetection.PLATFORM_PREFIX) && !pathname.getAbsolutePath().equals(this.recordFile);
            }
        });
        ArrayList<StudioCrashDetails> crashes = new ArrayList<StudioCrashDetails>();
        if (previousRecords != null) {
            for (File record : previousRecords) {
                StudioCrashDetails crash;
                try {
                    crash = StudioCrashDetails.loadFromRecordFile(record);
                }
                catch (IOException ignored) {
                    crash = StudioCrashDetails.UNKNOWN;
                }
                if (!FileUtil.delete((File)record)) continue;
                crashes.add(crash);
            }
        }
        return crashes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/internal/statistic/analytics/StudioCrashDetection", "updateRecordedVersionNumber"));
    }
}

