/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BuiltinWebServerAccess;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IdeaWideProxySelector;
import git4idea.commands.GitHttpAuthService;
import git4idea.commands.GitHttpAuthenticator;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitSSHGUIHandler;
import git4idea.config.GitVcsSettings;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.git4idea.ssh.GitXmlRpcSshService;

class GitHandlerAuthenticationManager
implements AutoCloseable {
    private static final Logger LOG = Logger.getInstance(GitHandlerAuthenticationManager.class);
    @NotNull
    private final GitLineHandler myHandler;
    @NotNull
    private final Project myProject;
    @Nullable
    private UUID myHttpHandler;
    private volatile boolean myHttpAuthFailed;
    @Nullable
    private UUID mySshHandler;

    private GitHandlerAuthenticationManager(@NotNull Project project, @NotNull GitLineHandler handler) {
        if (project == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myHandler = handler;
    }

    @NotNull
    public static GitHandlerAuthenticationManager prepare(@NotNull Project project, @NotNull GitLineHandler handler) throws IOException {
        if (project == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(2);
        }
        if (handler == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(3);
        }
        GitHandlerAuthenticationManager manager = new GitHandlerAuthenticationManager(project, handler);
        manager.prepareHttpAuth();
        if (GitVcsSettings.getInstance(project).isIdeaSsh()) {
            manager.prepareSshAuth();
        }
        GitHandlerAuthenticationManager gitHandlerAuthenticationManager = manager;
        if (gitHandlerAuthenticationManager == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(4);
        }
        return gitHandlerAuthenticationManager;
    }

    @Override
    public void close() {
        this.cleanupHttpAuth();
        this.cleanupSshAuth();
    }

    private void prepareHttpAuth() throws IOException {
        GitHttpAuthService service = (GitHttpAuthService)ServiceManager.getService(GitHttpAuthService.class);
        this.myHandler.addCustomEnvironmentVariable("GIT_ASKPASS", service.getScriptPath().getPath());
        final GitHttpAuthenticator httpAuthenticator = service.createAuthenticator(this.myProject, this.myHandler.getCommand(), this.myHandler.getUrls(), this.myHandler.isIgnoreAuthenticationRequest());
        this.myHttpHandler = service.registerHandler(httpAuthenticator, (Disposable)this.myProject);
        this.myHandler.addCustomEnvironmentVariable("GIT_ASKPASS_HANDLER", this.myHttpHandler.toString());
        int port = service.getXmlRcpPort();
        this.myHandler.addCustomEnvironmentVariable("GIT_ASKPASS_PORT", Integer.toString(port));
        this.myHandler.addCustomEnvironmentVariable("GIT_ASKPASS_TOKEN", BuiltinWebServerAccess.getUserAuthenticationToken());
        LOG.debug(String.format("myHandler=%s, port=%s", this.myHttpHandler, port));
        this.myHandler.addLineListener(new GitLineHandlerAdapter(){

            @Override
            public void onLineAvailable(@NonNls String line, Key outputType) {
                String lowerCaseLine = line.toLowerCase();
                if (lowerCaseLine.contains("authentication failed") || lowerCaseLine.contains("403 forbidden")) {
                    LOG.debug("auth listener: auth failure detected: " + line);
                    GitHandlerAuthenticationManager.this.myHttpAuthFailed = true;
                }
            }

            @Override
            public void processTerminated(int exitCode) {
                LOG.debug("auth listener: process terminated. auth failed=" + GitHandlerAuthenticationManager.this.myHttpAuthFailed + ", cancelled=" + httpAuthenticator.wasCancelled());
                if (!httpAuthenticator.wasCancelled()) {
                    if (GitHandlerAuthenticationManager.this.myHttpAuthFailed) {
                        httpAuthenticator.forgetPassword();
                    } else {
                        httpAuthenticator.saveAuthData();
                    }
                } else {
                    GitHandlerAuthenticationManager.this.myHttpAuthFailed = false;
                }
            }
        });
    }

    private void cleanupHttpAuth() {
        if (this.myHttpHandler != null) {
            ((GitHttpAuthService)ServiceManager.getService(GitHttpAuthService.class)).unregisterHandler(this.myHttpHandler);
            this.myHttpHandler = null;
        }
    }

    public boolean isHttpAuthFailed() {
        return this.myHttpAuthFailed;
    }

    private void prepareSshAuth() throws IOException {
        GitXmlRpcSshService ssh = (GitXmlRpcSshService)ServiceManager.getService(GitXmlRpcSshService.class);
        this.myHandler.addCustomEnvironmentVariable("GIT_SSH", ssh.getScriptPath().getPath());
        this.myHandler.addCustomEnvironmentVariable("GIT_SSH_VARIANT", "ssh");
        this.mySshHandler = ssh.registerHandler(new GitSSHGUIHandler(this.myProject, this.myHandler.isIgnoreAuthenticationRequest()), (Disposable)this.myProject);
        this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_HANDLER", this.mySshHandler.toString());
        int port = ssh.getXmlRcpPort();
        this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_PORT", Integer.toString(port));
        this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_TOKEN", BuiltinWebServerAccess.getUserAuthenticationToken());
        LOG.debug(String.format("myHandler=%s, port=%s", this.mySshHandler, port));
        HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        boolean useHttpProxy = httpConfigurable.USE_HTTP_PROXY && !GitHandlerAuthenticationManager.isSshUrlExcluded(httpConfigurable, this.myHandler.getUrls());
        this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_USE_PROXY", String.valueOf(useHttpProxy));
        if (useHttpProxy) {
            this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_PROXY_HOST", StringUtil.notNullize((String)httpConfigurable.PROXY_HOST));
            this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_PROXY_PORT", String.valueOf(httpConfigurable.PROXY_PORT));
            boolean proxyAuthentication = httpConfigurable.PROXY_AUTHENTICATION;
            this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_PROXY_AUTHENTICATION", String.valueOf(proxyAuthentication));
            if (proxyAuthentication) {
                this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_PROXY_USER", StringUtil.notNullize((String)httpConfigurable.getProxyLogin()));
                this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_PROXY_PASSWORD", StringUtil.notNullize((String)httpConfigurable.getPlainProxyPassword()));
            }
        }
    }

    private void cleanupSshAuth() {
        if (this.mySshHandler != null) {
            ((GitXmlRpcSshService)ServiceManager.getService(GitXmlRpcSshService.class)).unregisterHandler(this.mySshHandler);
            this.mySshHandler = null;
        }
    }

    private static boolean isSshUrlExcluded(@NotNull HttpConfigurable httpConfigurable, @NotNull Collection<String> urls) {
        if (httpConfigurable == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(5);
        }
        if (urls == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(6);
        }
        return ContainerUtil.exists(urls, url -> {
            if (httpConfigurable == null) {
                GitHandlerAuthenticationManager.$$$reportNull$$$0(7);
            }
            String host = URLUtil.parseHostFromSshUrl((String)url);
            return ((IdeaWideProxySelector)httpConfigurable.getOnlyBySettingsSelector()).isProxyException(host);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitHandlerAuthenticationManager";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpConfigurable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitHandlerAuthenticationManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepare";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSshUrlExcluded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isSshUrlExcluded$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

