/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionDescriptionImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogUtil;
import git4idea.history.browser.SHAHash;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHistoryUtils {
    private GitHistoryUtils() {
    }

    @Nullable
    public static VcsRevisionNumber getCurrentRevision(@NotNull Project project, @NotNull FilePath filePath, @Nullable String branch) throws VcsException {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            GitHistoryUtils.$$$reportNull$$$0(1);
        }
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitLineHandler h = new GitLineHandler(project, GitUtil.getGitRoot(filePath), GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        h.addParameters(!StringUtil.isEmpty((String)branch) ? branch : "--all");
        h.endOptions();
        h.addRelativePaths(filePath);
        String result2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        if (result2.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result2);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h);
        return new GitRevisionNumber(record.getHash(), record.getDate());
    }

    @Nullable
    public static VcsRevisionDescription getCurrentRevisionDescription(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(2);
        }
        if (filePath == null) {
            GitHistoryUtils.$$$reportNull$$$0(3);
        }
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitLineHandler h = new GitLineHandler(project, GitUtil.getGitRoot(filePath), GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        h.addParameters("--encoding=UTF-8");
        h.addParameters("--all");
        h.endOptions();
        h.addRelativePaths(filePath);
        String result2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        if (result2.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result2);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h);
        String author = Comparing.equal((String)record.getAuthorName(), (String)record.getCommitterName()) ? record.getAuthorName() : record.getAuthorName() + " (" + record.getCommitterName() + ")";
        return new VcsRevisionDescriptionImpl((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), record.getDate(), author, record.getFullMessage());
    }

    @Nullable
    public static ItemLatestState getLastRevision(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        VirtualFile root;
        GitLocalBranch c;
        GitRemoteBranch t;
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(4);
        }
        if (filePath == null) {
            GitHistoryUtils.$$$reportNull$$$0(5);
        }
        GitRemoteBranch gitRemoteBranch = t = (c = GitBranchUtil.getCurrentBranch(project, root = GitUtil.getGitRoot(filePath))) == null ? null : GitBranchUtil.tracked(project, root, c.getName());
        if (t == null) {
            return new ItemLatestState(GitHistoryUtils.getCurrentRevision(project, filePath, null), true, false);
        }
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty(), "--name-status", t.getFullName());
        h.endOptions();
        h.addRelativePaths(filePath);
        String result2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        if (result2.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result2);
        if (record == null) {
            return null;
        }
        List<Change> changes = record.parseChanges(project, root);
        boolean exists = changes.isEmpty() || !FileStatus.DELETED.equals(changes.get(0).getFileStatus());
        record.setUsedHandler(h);
        return new ItemLatestState((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), exists, false);
    }

    @Nullable
    public static List<VcsCommitMetadata> readLastCommits(@NotNull Project project, @NotNull VirtualFile root, String ... refs) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(6);
        }
        if (root == null) {
            GitHistoryUtils.$$$reportNull$$$0(7);
        }
        if (refs == null) {
            GitHistoryUtils.$$$reportNull$$$0(8);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            return null;
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.AUTHOR_TIME);
        h.setSilent(true);
        h.addParameters("--no-walk");
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(refs);
        h.endOptions();
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        List<GitLogRecord> records = parser.parse(output);
        if (records.size() != refs.length) {
            return null;
        }
        return ContainerUtil.map(records, record -> {
            if (root == null) {
                GitHistoryUtils.$$$reportNull$$$0(35);
            }
            return factory.createCommitMetadata(factory.createHash(record.getHash()), GitLogUtil.getParentHashes(factory, record), record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
        });
    }

    @Deprecated
    @NotNull
    public static List<Pair<SHAHash, Date>> onlyHashesHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(9);
        }
        if (path == null) {
            GitHistoryUtils.$$$reportNull$$$0(10);
        }
        VirtualFile root = GitUtil.getGitRoot(path);
        List<Pair<SHAHash, Date>> list = GitHistoryUtils.onlyHashesHistory(project, path, root, parameters);
        if (list == null) {
            GitHistoryUtils.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Deprecated
    @NotNull
    public static List<Pair<SHAHash, Date>> onlyHashesHistory(@NotNull Project project, @NotNull FilePath path, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(12);
        }
        if (path == null) {
            GitHistoryUtils.$$$reportNull$$$0(13);
        }
        if (root == null) {
            GitHistoryUtils.$$$reportNull$$$0(14);
        }
        path = GitHistoryUtils.getLastCommitName(project, path);
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.endOptions();
        h.addRelativePaths(path);
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        ArrayList<Pair<SHAHash, Date>> rc = new ArrayList<Pair<SHAHash, Date>>();
        for (GitLogRecord record : parser.parse(output)) {
            record.setUsedHandler(h);
            rc.add((Pair<SHAHash, Date>)Pair.create((Object)new SHAHash(record.getHash()), (Object)record.getDate()));
        }
        ArrayList<Pair<SHAHash, Date>> arrayList = rc;
        if (arrayList == null) {
            GitHistoryUtils.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static List<GitCommit> history(@NotNull Project project, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(16);
        }
        if (root == null) {
            GitHistoryUtils.$$$reportNull$$$0(17);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List<GitCommit> list = Collections.emptyList();
            if (list == null) {
                GitHistoryUtils.$$$reportNull$$$0(18);
            }
            return list;
        }
        List<GitCommit> list = GitLogUtil.collectFullDetails(project, root, parameters);
        if (list == null) {
            GitHistoryUtils.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public static String[] formHashParameters(@NotNull GitVcs vcs, @NotNull Collection<String> hashes2) {
        if (vcs == null) {
            GitHistoryUtils.$$$reportNull$$$0(20);
        }
        if (hashes2 == null) {
            GitHistoryUtils.$$$reportNull$$$0(21);
        }
        ArrayList parameters = ContainerUtil.newArrayList();
        parameters.add(GitLogUtil.getNoWalkParameter(vcs));
        parameters.addAll(hashes2);
        String[] stringArray = ArrayUtil.toStringArray((Collection)parameters);
        if (stringArray == null) {
            GitHistoryUtils.$$$reportNull$$$0(22);
        }
        return stringArray;
    }

    public static void loadDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super GitCommit> commitConsumer, String ... parameters) throws VcsException {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(23);
        }
        if (root == null) {
            GitHistoryUtils.$$$reportNull$$$0(24);
        }
        if (commitConsumer == null) {
            GitHistoryUtils.$$$reportNull$$$0(25);
        }
        if (parameters == null) {
            GitHistoryUtils.$$$reportNull$$$0(26);
        }
        GitLogUtil.readFullDetails(project, root, commitConsumer, true, true, parameters);
    }

    public static long getAuthorTime(@NotNull Project project, @NotNull FilePath path, @NotNull String commitsId) throws VcsException {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(27);
        }
        if (path == null) {
            GitHistoryUtils.$$$reportNull$$$0(28);
        }
        if (commitsId == null) {
            GitHistoryUtils.$$$reportNull$$$0(29);
        }
        path = GitHistoryUtils.getLastCommitName(project, path);
        VirtualFile root = GitUtil.getGitRoot(path);
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.AUTHOR_TIME);
        h.setSilent(true);
        h.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(commitsId);
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        GitLogRecord logRecord = parser.parseOneRecord(output);
        if (logRecord == null) {
            throw new VcsException("Can not parse log output \"" + output + "\"");
        }
        return logRecord.getAuthorTimeStamp();
    }

    public static FilePath getLastCommitName(@NotNull Project project, FilePath path) {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(30);
        }
        if (project.isDefault()) {
            return path;
        }
        ChangeListManager changeManager = ChangeListManager.getInstance((Project)project);
        Change change = changeManager.getChange(path);
        if (change != null && change.getType() == Change.Type.MOVED) {
            assert (change.getBeforeRevision() != null) : "Move change always have beforeRevision";
            path = change.getBeforeRevision().getFile();
        }
        return path;
    }

    @Nullable
    public static GitRevisionNumber getMergeBase(@NotNull Project project, @NotNull VirtualFile root, @NotNull String first, @NotNull String second) throws VcsException {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(31);
        }
        if (root == null) {
            GitHistoryUtils.$$$reportNull$$$0(32);
        }
        if (first == null) {
            GitHistoryUtils.$$$reportNull$$$0(33);
        }
        if (second == null) {
            GitHistoryUtils.$$$reportNull$$$0(34);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.MERGE_BASE);
        h.setSilent(true);
        h.addParameters(first, second);
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]).trim();
        if (output.length() == 0) {
            return null;
        }
        return GitRevisionNumber.resolve(project, root, output);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 24: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 10: 
            case 13: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitHistoryUtils";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitConsumer";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitsId";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitHistoryUtils";
                break;
            }
            case 11: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "onlyHashesHistory";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "history";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "formHashParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRevision";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRevisionDescription";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLastRevision";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readLastCommits";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onlyHashesHistory";
                break;
            }
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 22: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "history";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "formHashParameters";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadDetails";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAuthorTime";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommitName";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getMergeBase";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$readLastCommits$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

