/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.merge.GitMergeProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.StringScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitConflictResolver {
    private static final Logger LOG = Logger.getInstance(GitConflictResolver.class);
    @NotNull
    private final Collection<VirtualFile> myRoots;
    @NotNull
    private final Params myParams;
    @NotNull
    protected final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final AbstractVcsHelper myVcsHelper;
    @NotNull
    private final GitVcs myVcs;

    @Deprecated
    public GitConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull GitPlatformFacade facade, @NotNull Collection<VirtualFile> roots, @NotNull Params params) {
        if (project == null) {
            GitConflictResolver.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitConflictResolver.$$$reportNull$$$0(1);
        }
        if (facade == null) {
            GitConflictResolver.$$$reportNull$$$0(2);
        }
        if (roots == null) {
            GitConflictResolver.$$$reportNull$$$0(3);
        }
        if (params == null) {
            GitConflictResolver.$$$reportNull$$$0(4);
        }
        this(project, git, roots, params);
    }

    public GitConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull Collection<VirtualFile> roots, @NotNull Params params) {
        if (project == null) {
            GitConflictResolver.$$$reportNull$$$0(5);
        }
        if (git == null) {
            GitConflictResolver.$$$reportNull$$$0(6);
        }
        if (roots == null) {
            GitConflictResolver.$$$reportNull$$$0(7);
        }
        if (params == null) {
            GitConflictResolver.$$$reportNull$$$0(8);
        }
        this.myProject = project;
        this.myGit = git;
        this.myRoots = roots;
        this.myParams = params;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myVcsHelper = AbstractVcsHelper.getInstance((Project)project);
        this.myVcs = GitVcs.getInstance(this.myProject);
    }

    public final boolean merge() {
        return this.merge(false);
    }

    protected boolean proceedIfNothingToMerge() throws VcsException {
        return true;
    }

    protected boolean proceedAfterAllMerged() throws VcsException {
        return true;
    }

    public final boolean mergeNoProceed() {
        return this.merge(true);
    }

    protected void notifyUnresolvedRemain() {
        this.notifyWarning(this.myParams.myErrorNotificationTitle, "Unresolved conflicts remaining in the project." + this.myParams.myErrorNotificationAdditionalDescription);
    }

    private void notifyUnresolvedRemainAfterNotification() {
        this.notifyWarning("Unresolved Conflicts Remaining", this.myParams.myErrorNotificationAdditionalDescription);
    }

    protected void notifyWarning(String title, String content) {
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title, content, NotificationType.WARNING, null);
        notification.addAction((AnAction)NotificationAction.createSimple((String)"Resolve...", () -> {
            notification.expire();
            BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, () -> this.mergeNoProceed());
        }));
        VcsNotifier.getInstance((Project)this.myProject).notify(notification);
    }

    private boolean merge(boolean mergeDialogInvokedFromNotification) {
        try {
            Collection<VirtualFile> initiallyUnmergedFiles = this.getUnmergedFiles(this.myRoots);
            if (initiallyUnmergedFiles.isEmpty()) {
                LOG.info("merge: no unmerged files");
                return mergeDialogInvokedFromNotification ? true : this.proceedIfNothingToMerge();
            }
            this.showMergeDialog(initiallyUnmergedFiles);
            Collection<VirtualFile> unmergedFilesAfterResolve = this.getUnmergedFiles(this.myRoots);
            if (unmergedFilesAfterResolve.isEmpty()) {
                LOG.info("merge no more unmerged files");
                return mergeDialogInvokedFromNotification ? true : this.proceedAfterAllMerged();
            }
            LOG.info("mergeFiles unmerged files remain: " + unmergedFilesAfterResolve);
            if (mergeDialogInvokedFromNotification) {
                this.notifyUnresolvedRemainAfterNotification();
            } else {
                this.notifyUnresolvedRemain();
            }
        }
        catch (VcsException e) {
            this.notifyException(e);
        }
        return false;
    }

    private void showMergeDialog(@NotNull Collection<VirtualFile> initiallyUnmergedFiles) {
        if (initiallyUnmergedFiles == null) {
            GitConflictResolver.$$$reportNull$$$0(9);
        }
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (initiallyUnmergedFiles == null) {
                GitConflictResolver.$$$reportNull$$$0(12);
            }
            GitMergeProvider mergeProvider = new GitMergeProvider(this.myProject, this.myParams.reverse);
            this.myVcsHelper.showMergeDialog(new ArrayList(initiallyUnmergedFiles), (MergeProvider)mergeProvider, this.myParams.myMergeDialogCustomizer);
        });
    }

    private void notifyException(VcsException e) {
        LOG.info("mergeFiles ", (Throwable)e);
        String description = "Couldn't check the working tree for unmerged files because of an error.";
        VcsNotifier.getInstance((Project)this.myProject).notifyError(this.myParams.myErrorNotificationTitle, "Couldn't check the working tree for unmerged files because of an error." + this.myParams.myErrorNotificationAdditionalDescription + "<br/>" + e.getLocalizedMessage(), null);
    }

    private Collection<VirtualFile> getUnmergedFiles(@NotNull Collection<VirtualFile> roots) throws VcsException {
        if (roots == null) {
            GitConflictResolver.$$$reportNull$$$0(10);
        }
        HashSet<VirtualFile> unmergedFiles = new HashSet<VirtualFile>();
        for (VirtualFile root : roots) {
            unmergedFiles.addAll(this.getUnmergedFiles(root));
        }
        return unmergedFiles;
    }

    private Collection<VirtualFile> getUnmergedFiles(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            GitConflictResolver.$$$reportNull$$$0(11);
        }
        return this.unmergedFiles(root);
    }

    private List<VirtualFile> unmergedFiles(VirtualFile root) throws VcsException {
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            return Collections.emptyList();
        }
        GitCommandResult result2 = this.myGit.getUnmergedFiles(repository);
        if (!result2.success()) {
            throw new VcsException(result2.getErrorOutputAsJoinedString());
        }
        String output = StringUtil.join(result2.getOutput(), (String)"\n");
        HashSet unmergedPaths = ContainerUtil.newHashSet();
        StringScanner s = new StringScanner(output);
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            s.boundedToken('\t');
            String relative = s.line();
            unmergedPaths.add(GitUtil.unescapePath(relative));
        }
        if (unmergedPaths.size() == 0) {
            return Collections.emptyList();
        }
        List files = ContainerUtil.map((Collection)unmergedPaths, path -> new File(root.getPath(), (String)path));
        return DvcsUtil.sortVirtualFilesByPresentation((Collection)DvcsUtil.findVirtualFilesWithRefresh((List)files));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initiallyUnmergedFiles";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "git4idea/merge/GitConflictResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showMergeDialog";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnmergedFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showMergeDialog$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Params {
        private boolean reverse;
        private String myErrorNotificationTitle = "";
        private String myErrorNotificationAdditionalDescription = "";
        private String myMergeDescription = "";
        private MergeDialogCustomizer myMergeDialogCustomizer = new MergeDialogCustomizer(){

            public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
                if (files == null) {
                    1.$$$reportNull$$$0(0);
                }
                return myMergeDescription;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/merge/GitConflictResolver$Params$1", "getMultipleFileMergeDescription"));
            }
        };

        public Params setReverse(boolean reverseMerge) {
            this.reverse = reverseMerge;
            return this;
        }

        public Params setErrorNotificationTitle(String errorNotificationTitle) {
            this.myErrorNotificationTitle = errorNotificationTitle;
            return this;
        }

        public Params setErrorNotificationAdditionalDescription(String errorNotificationAdditionalDescription) {
            this.myErrorNotificationAdditionalDescription = errorNotificationAdditionalDescription;
            return this;
        }

        public Params setMergeDescription(String mergeDescription) {
            this.myMergeDescription = mergeDescription;
            return this;
        }

        public Params setMergeDialogCustomizer(MergeDialogCustomizer mergeDialogCustomizer) {
            this.myMergeDialogCustomizer = mergeDialogCustomizer;
            return this;
        }
    }
}

