/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.ErrorReporter;
import com.android.builder.core.LibraryRequest;
import com.android.sdklib.IAndroidTarget;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class BootClasspathBuilder {
    public static ImmutableList<File> computeFullBootClasspath(IAndroidTarget target, File annotationsJar) {
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkNotNull((Object)annotationsJar);
        ImmutableList.Builder classpath = ImmutableList.builder();
        for (Object p : target.getBootClasspath()) {
            classpath.add((Object)new File((String)p));
        }
        List libs = target.getAdditionalLibraries();
        for (IAndroidTarget.OptionalLibrary lib : libs) {
            File jar = lib.getJar();
            Verify.verify((jar != null ? 1 : 0) != 0, (String)"Jar missing from additional library %s.", (Object[])new Object[]{lib.getName()});
            classpath.add((Object)jar);
        }
        List optionalLibraries = target.getOptionalLibraries();
        for (IAndroidTarget.OptionalLibrary lib : optionalLibraries) {
            File jar = lib.getJar();
            Verify.verify((jar != null ? 1 : 0) != 0, (String)"Jar missing from optional library %s.", (Object[])new Object[]{lib.getName()});
            classpath.add((Object)jar);
        }
        if (target.getVersion().getApiLevel() <= 15) {
            classpath.add((Object)annotationsJar);
        }
        return classpath.build();
    }

    public static ImmutableList<File> computeFilteredClasspath(IAndroidTarget target, List<LibraryRequest> libraryRequestsArg, ErrorReporter errorReporter, File annotationsJar) {
        ArrayList classpath = Lists.newArrayList();
        for (String p : target.getBootClasspath()) {
            classpath.add(new File(p));
        }
        ArrayList requestedLibs = Lists.newArrayList(libraryRequestsArg);
        List libs = target.getAdditionalLibraries();
        for (IAndroidTarget.OptionalLibrary lib : libs) {
            classpath.add(lib.getJar());
            Optional<LibraryRequest> requestedLib = BootClasspathBuilder.findMatchingLib(lib.getName(), requestedLibs);
            if (!requestedLib.isPresent()) continue;
            requestedLibs.remove(requestedLib.get());
        }
        List optionalLibraries = target.getOptionalLibraries();
        for (IAndroidTarget.OptionalLibrary lib : optionalLibraries) {
            Optional<LibraryRequest> requestedLib = BootClasspathBuilder.findMatchingLib(lib.getName(), requestedLibs);
            if (!requestedLib.isPresent()) continue;
            classpath.add(lib.getJar());
            requestedLibs.remove(requestedLib.get());
        }
        for (LibraryRequest library : requestedLibs) {
            errorReporter.handleSyncError(library.getName(), 10, "Unable to find optional library: " + library.getName());
        }
        if (target.getVersion().getApiLevel() <= 15) {
            classpath.add(annotationsJar);
        }
        return ImmutableList.copyOf((Collection)classpath);
    }

    private static Optional<LibraryRequest> findMatchingLib(String name, List<LibraryRequest> libraries) {
        return libraries.stream().filter(l -> name.equals(l.getName())).findFirst();
    }
}

