/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AaptUtils;
import com.android.builder.model.AaptOptions;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class AaptV2CommandBuilder {
    private AaptV2CommandBuilder() {
    }

    public static ImmutableList<String> makeCompile(File file, File output) {
        return ImmutableList.of((Object)"compile", (Object)"-o", (Object)output.getAbsolutePath(), (Object)file.getAbsolutePath());
    }

    public static ImmutableList<String> makeLink(AaptPackageConfig config, File intermediateDir, BuildToolInfo buildToolInfo) throws AaptException {
        List additionalParameters;
        Collection noCompressList;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)"link");
        if (config.isVerbose()) {
            builder.add((Object)"-v");
        }
        File stableResourceIdsFile = new File(intermediateDir, "stable-resource-ids.txt");
        IAndroidTarget target = config.getAndroidTarget();
        Preconditions.checkNotNull((Object)target);
        builder.add((Object[])new String[]{"-I", target.getPath(1)});
        File manifestFile = config.getManifestFile();
        Preconditions.checkNotNull((Object)manifestFile);
        builder.add((Object[])new String[]{"--manifest", manifestFile.getAbsolutePath()});
        if (config.getResourceDir() != null) {
            try {
                Files.walk(config.getResourceDir().toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> builder.add((Object[])new String[]{"-R", p.toString()}));
            }
            catch (IOException e) {
                throw new AaptException("Failed to walk path " + config.getResourceDir(), new Object[0]);
            }
        }
        builder.add((Object)"--auto-add-overlay");
        if (config.getSourceOutputDir() != null) {
            builder.add((Object[])new String[]{"--java", config.getSourceOutputDir().getAbsolutePath()});
        }
        if (config.getResourceOutputApk() != null) {
            builder.add((Object[])new String[]{"-o", config.getResourceOutputApk().getAbsolutePath()});
        } else {
            try {
                File tmpOutput = File.createTempFile("aapt-", "-out");
                tmpOutput.deleteOnExit();
                builder.add((Object[])new String[]{"-o", tmpOutput.getAbsolutePath()});
            }
            catch (IOException e) {
                throw new AaptException("No output apk defined and failed to create tmp file", new Object[]{e});
            }
        }
        if (config.getProguardOutputFile() != null) {
            builder.add((Object[])new String[]{"--proguard", config.getProguardOutputFile().getAbsolutePath()});
        }
        if (config.getSplits() != null) {
            for (String string : config.getSplits()) {
            }
        }
        if (config.isDebuggable()) {
            // empty if block
        }
        ILogger logger = config.getLogger();
        Preconditions.checkNotNull((Object)logger);
        if (config.getVariantType() != VariantType.ANDROID_TEST && config.getCustomPackageForR() != null) {
            builder.add((Object[])new String[]{"--custom-package", config.getCustomPackageForR()});
        }
        if (config.isPseudoLocalize()) {
            Preconditions.checkState((buildToolInfo.getRevision().getMajor() >= 21 ? 1 : 0) != 0);
        }
        boolean generateFinalIds = true;
        if (config.getVariantType() == VariantType.LIBRARY) {
            generateFinalIds = false;
        } else if (config.getVariantType() == VariantType.ATOM && config.getBaseFeature() != null) {
            generateFinalIds = false;
        }
        if (!generateFinalIds) {
            builder.add((Object)"--non-final-ids");
        }
        AaptOptions options = config.getOptions();
        Preconditions.checkNotNull((Object)options);
        String ignoreAssets = options.getIgnoreAssets();
        if (ignoreAssets != null) {
            // empty if block
        }
        if (config.getOptions().getFailOnMissingConfigEntry()) {
            Preconditions.checkState((buildToolInfo.getRevision().getMajor() > 20 ? 1 : 0) != 0);
        }
        if ((noCompressList = config.getOptions().getNoCompress()) != null) {
            for (String noCompress : noCompressList) {
                builder.add((Object[])new String[]{"-0", noCompress});
            }
        }
        if ((additionalParameters = config.getOptions().getAdditionalParameters()) != null) {
            builder.addAll((Iterable)additionalParameters);
        }
        ArrayList<String> resourceConfigs = new ArrayList<String>();
        resourceConfigs.addAll(config.getResourceConfigs());
        String preferredDensity = null;
        ArrayList densityResourceConfigs = Lists.newArrayList(AaptUtils.getDensityResConfigs(resourceConfigs));
        ArrayList otherResourceConfigs = Lists.newArrayList(AaptUtils.getNonDensityResConfigs(resourceConfigs));
        preferredDensity = config.getPreferredDensity();
        if (preferredDensity != null && !densityResourceConfigs.isEmpty()) {
            throw new AaptException(String.format("When using splits in tools 21 and above, resConfigs should not contain any densities. Right now, it contains \"%1$s\"\nSuggestion: remove these from resConfigs from build.gradle", Joiner.on((String)"\",\"").join((Iterable)densityResourceConfigs)), new Object[0]);
        }
        if (densityResourceConfigs.size() > 1) {
            throw new AaptException("Cannot filter assets for multiple densities using SDK build tools 21 or later. Consider using apk splits instead.", new Object[0]);
        }
        if (preferredDensity == null && densityResourceConfigs.size() == 1) {
            preferredDensity = (String)Iterables.getOnlyElement((Iterable)densityResourceConfigs);
        }
        if (!otherResourceConfigs.isEmpty()) {
            Joiner joiner = Joiner.on((char)',');
            builder.add((Object[])new String[]{"-c", joiner.join((Iterable)otherResourceConfigs)});
        }
        if (preferredDensity != null) {
            builder.add((Object[])new String[]{"--preferred-density", preferredDensity});
        }
        if (config.getSymbolOutputDir() == null || config.getVariantType() == VariantType.LIBRARY || !config.getLibraries().isEmpty()) {
            // empty if block
        }
        builder.add((Object)"--no-version-vectors");
        return builder.build();
    }
}

