/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AbstractProcessExecutionAapt;
import com.android.builder.internal.aapt.v2.Aapt2RenamingConventions;
import com.android.builder.internal.aapt.v2.AaptV2CommandBuilder;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.repository.Revision;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import java.io.File;

public class OutOfProcessAaptV2
extends AbstractProcessExecutionAapt {
    private static final Revision VERSION_FOR_SERVER_AAPT = new Revision(22, 0, 0);
    private final BuildToolInfo mBuildToolInfo;
    private final File mIntermediateDir;

    public OutOfProcessAaptV2(ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, BuildToolInfo buildToolInfo, File intermediateDir, ILogger logger) {
        super(processExecutor, processOutputHandler);
        Preconditions.checkArgument((boolean)intermediateDir.isDirectory(), (Object)"!intermediateDir.isDirectory()");
        this.mBuildToolInfo = buildToolInfo;
        this.mIntermediateDir = intermediateDir;
    }

    @Override
    protected AbstractProcessExecutionAapt.CompileInvocation makeCompileProcessBuilder(File file, File output) throws AaptException {
        Preconditions.checkArgument((boolean)file.isFile(), (Object)"!file.isFile()");
        Preconditions.checkArgument((boolean)output.isDirectory(), (Object)"!output.isDirectory()");
        return new AbstractProcessExecutionAapt.CompileInvocation(new ProcessInfoBuilder().setExecutable(this.getAapt2ExecutablePath()).addArgs(AaptV2CommandBuilder.makeCompile(file, output)), new File(output, Aapt2RenamingConventions.compilationRename(file)));
    }

    @Override
    protected ProcessInfoBuilder makePackageProcessBuilder(AaptPackageConfig config) throws AaptException {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getAapt2ExecutablePath());
        builder.addArgs(AaptV2CommandBuilder.makeLink(config, this.mIntermediateDir, this.mBuildToolInfo));
        return builder;
    }

    private String getAapt2ExecutablePath() {
        String aapt2 = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.AAPT2);
        if (aapt2 == null || !new File(aapt2).isFile()) {
            throw new IllegalStateException("aapt2 is missing on '" + aapt2 + "'");
        }
        return aapt2;
    }

    public void start() {
    }

    public void end() throws InterruptedException {
    }
}

