/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.signing;

import com.android.apkzlib.sign.DigestAlgorithm;
import com.android.apkzlib.sign.SignatureAlgorithm;
import com.android.apkzlib.zfile.ApkCreator;
import com.android.apkzlib.zfile.ApkCreatorFactory;
import com.android.builder.packaging.PackagingUtils;
import com.android.builder.packaging.ZipAbortException;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;

public class SignedJarApkCreator
implements ApkCreator {
    private final int mMinSdkVersion;
    private final Predicate<String> mNoCompressPredicate;
    private final PrivateKey mKey;
    private final X509Certificate mCertificate;
    private JarOutputStream mOutputJar;
    private Manifest mManifest;
    private DigestAlgorithm mDigestAlgorithm;
    private SignatureAlgorithm mSignatureAlgorithm;
    private MessageDigest mMessageDigest;
    private byte[] mBuffer = new byte[4096];

    public SignedJarApkCreator(ApkCreatorFactory.CreationData creationData) throws IOException, NoSuchAlgorithmException {
        this.mMinSdkVersion = creationData.getMinSdkVersion();
        this.mOutputJar = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(creationData.getApkPath())));
        this.mOutputJar.setLevel(9);
        this.mNoCompressPredicate = creationData.getNoCompressPredicate();
        this.mKey = creationData.getPrivateKey();
        this.mCertificate = creationData.getCertificate();
        if (this.mKey != null && this.mCertificate != null) {
            this.mManifest = new Manifest();
            Attributes main = this.mManifest.getMainAttributes();
            main.putValue("Manifest-Version", "1.0");
            if (creationData.getBuiltBy() != null) {
                main.putValue("Built-By", creationData.getBuiltBy());
            }
            if (creationData.getCreatedBy() != null) {
                main.putValue("Created-By", creationData.getCreatedBy());
            }
            this.mSignatureAlgorithm = SignatureAlgorithm.fromKeyAlgorithm(this.mKey.getAlgorithm(), this.mMinSdkVersion);
            this.mDigestAlgorithm = DigestAlgorithm.findBest(this.mMinSdkVersion, this.mSignatureAlgorithm);
            this.mMessageDigest = MessageDigest.getInstance(this.mDigestAlgorithm.messageDigestName);
        }
    }

    @Override
    public void writeFile(File inputFile, String apkPath) throws IOException {
        try (FileInputStream fis = new FileInputStream(inputFile);){
            JarEntry entry = new JarEntry(apkPath);
            entry.setTime(inputFile.lastModified());
            if (this.mNoCompressPredicate.test(apkPath)) {
                SignedJarApkCreator.configureStoredEntry(entry, inputFile);
            }
            this.writeEntry(fis, entry);
        }
    }

    private static void configureStoredEntry(JarEntry entry, File inputFile) throws IOException {
        ByteSource byteSource = Files.asByteSource((File)inputFile);
        long size = inputFile.length();
        entry.setMethod(0);
        entry.setSize(size);
        entry.setCompressedSize(size);
        entry.setCrc(byteSource.hash(Hashing.crc32()).padToLong());
    }

    public void writeZip(File zip) throws IOException, ZipAbortException {
        this.writeZip(zip, null, null);
    }

    @Override
    public void writeZip(File zip, Function<String, String> transform, Predicate<String> isIgnored) throws IOException {
        Preconditions.checkArgument((transform == null ? 1 : 0) != 0, (Object)"SignedJarApkCreator does not support name transforms");
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zip));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                int index;
                String subName;
                String name = entry.getName();
                if (entry.isDirectory() || name.startsWith("META-INF/") && ("MANIFEST.MF".equals(subName = name.substring(9)) || name.startsWith("META-INF/maven/") || (index = subName.indexOf(47)) == -1 && PackagingUtils.SIGNING_EXTENSIONS.stream().anyMatch(ext -> subName.endsWith("." + ext))) || isIgnored != null && isIgnored.test(name)) continue;
                JarEntry newEntry = entry.getMethod() == 0 ? new JarEntry(entry) : new JarEntry(name);
                this.writeEntry(zis, newEntry);
                zis.closeEntry();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mOutputJar == null) {
            return;
        }
        if (this.mManifest != null) {
            this.mOutputJar.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
            this.mManifest.write(this.mOutputJar);
            try {
                this.mOutputJar.putNextEntry(new JarEntry("META-INF/CERT.SF"));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.writeSignatureFile(byteArrayOutputStream);
                byte[] signedData = byteArrayOutputStream.toByteArray();
                this.mOutputJar.write(signedData);
                this.mOutputJar.putNextEntry(new JarEntry("META-INF/CERT." + this.mKey.getAlgorithm()));
                this.writeSignatureBlock((CMSTypedData)new CMSProcessableByteArray(signedData), this.mCertificate);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.mOutputJar.close();
        this.mOutputJar = null;
    }

    private void writeEntry(InputStream input, JarEntry entry) throws IOException {
        int count;
        this.mOutputJar.putNextEntry(entry);
        while ((count = input.read(this.mBuffer)) != -1) {
            this.mOutputJar.write(this.mBuffer, 0, count);
            if (this.mMessageDigest == null) continue;
            this.mMessageDigest.update(this.mBuffer, 0, count);
        }
        this.mOutputJar.closeEntry();
        if (this.mManifest != null) {
            Attributes attr = this.mManifest.getAttributes(entry.getName());
            if (attr == null) {
                attr = new Attributes();
                this.mManifest.getEntries().put(entry.getName(), attr);
            }
            attr.putValue(this.mDigestAlgorithm.entryAttributeName, new String(Base64.encode((byte[])this.mMessageDigest.digest()), "ASCII"));
        }
    }

    private void writeSignatureFile(OutputStream out) throws IOException, GeneralSecurityException {
        Manifest sf = new Manifest();
        Attributes main = sf.getMainAttributes();
        main.putValue("Signature-Version", "1.0");
        main.putValue("Created-By", "1.0 (Android)");
        MessageDigest md = MessageDigest.getInstance(this.mDigestAlgorithm.messageDigestName);
        PrintStream print = new PrintStream((OutputStream)new DigestOutputStream(new ByteArrayOutputStream(), md), true, "UTF-8");
        this.mManifest.write(print);
        print.flush();
        main.putValue(this.mDigestAlgorithm.manifestAttributeName, new String(Base64.encode((byte[])md.digest()), "ASCII"));
        Map<String, Attributes> entries = this.mManifest.getEntries();
        for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
            print.print("Name: " + entry.getKey() + "\r\n");
            for (Map.Entry<Object, Object> att : entry.getValue().entrySet()) {
                print.print(att.getKey() + ": " + att.getValue() + "\r\n");
            }
            print.print("\r\n");
            print.flush();
            Attributes sfAttr = new Attributes();
            sfAttr.putValue(this.mDigestAlgorithm.entryAttributeName, new String(Base64.encode((byte[])md.digest()), "ASCII"));
            sf.getEntries().put(entry.getKey(), sfAttr);
        }
        CountOutputStream cout = new CountOutputStream(out);
        sf.write(cout);
        if (cout.size() % 1024 == 0) {
            cout.write(13);
            cout.write(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSignatureBlock(CMSTypedData data, X509Certificate publicKey) throws IOException, CertificateEncodingException, OperatorCreationException, CMSException {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(publicKey);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder(this.mSignatureAlgorithm.signatureAlgorithmName(this.mDigestAlgorithm)).build(this.mKey);
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).setDirectSignature(true).build(sha1Signer, publicKey));
        gen.addCertificates((Store)certs);
        CMSSignedData sigData = gen.generate(data, false);
        try (ASN1InputStream asn1 = new ASN1InputStream(sigData.getEncoded());){
            DEROutputStream dos = new DEROutputStream((OutputStream)this.mOutputJar);
            try {
                dos.writeObject((ASN1Encodable)asn1.readObject());
            }
            finally {
                dos.flush();
                dos.close();
            }
        }
    }

    @Override
    public void deleteFile(String apkPath) throws IOException {
        throw new UnsupportedOperationException("Cannot call deleteFile on a ApkCreator that does not support updates.");
    }

    private static class CountOutputStream
    extends FilterOutputStream {
        private int mCount = 0;

        public CountOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            ++this.mCount;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.mCount += len;
        }

        public int size() {
            return this.mCount;
        }
    }
}

