/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.dependency.HashCodeUtils;
import com.android.builder.symbols.Symbol;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.SourceVersion;

public class SymbolTable {
    private static final String DEFAULT_NAME = "R";
    private final ImmutableMap<String, Symbol> symbols;
    private final String tableName;
    private final String tablePackage;

    private SymbolTable(String tablePackage, String tableName, Map<String, Symbol> symbols) {
        this.symbols = ImmutableMap.copyOf(symbols);
        this.tableName = tableName;
        this.tablePackage = tablePackage;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTablePackage() {
        return this.tablePackage;
    }

    private static String key(Symbol symbol) {
        return SymbolTable.key(symbol.getResourceType(), symbol.getName());
    }

    private static String key(String resourceType, String name) {
        return resourceType + " " + name;
    }

    public boolean contains(String resourceType, String name) {
        return this.symbols.containsKey((Object)SymbolTable.key(resourceType, name));
    }

    public ImmutableCollection<Symbol> allSymbols() {
        return this.symbols.values();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SymbolTable)) {
            return false;
        }
        SymbolTable other = (SymbolTable)obj;
        return Objects.equals(this.symbols, other.symbols) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.tablePackage, other.tablePackage);
    }

    public int hashCode() {
        return HashCodeUtils.hashCode(this.symbols, this.tableName, this.tablePackage);
    }

    public SymbolTable filter(SymbolTable table) {
        Builder stb = SymbolTable.builder();
        stb.tableName(this.tableName);
        stb.tablePackage(this.tablePackage);
        for (Map.Entry e : this.symbols.entrySet()) {
            if (!table.symbols.containsKey(e.getKey())) continue;
            stb.symbols.put(e.getKey(), e.getValue());
        }
        return stb.build();
    }

    public SymbolTable merge(SymbolTable m) {
        return SymbolTable.merge(Arrays.asList(this, m));
    }

    public SymbolTable rename(String tablePackage, String tableName) {
        return SymbolTable.builder().tablePackage(tablePackage).tableName(tableName).addAll((Collection<Symbol>)this.allSymbols()).build();
    }

    public static SymbolTable merge(List<SymbolTable> tables) {
        Builder builder = SymbolTable.builder();
        boolean first = true;
        for (SymbolTable t : tables) {
            if (first) {
                builder.tablePackage(t.getTablePackage());
                builder.tableName(t.getTableName());
                first = false;
            }
            for (Symbol s : t.allSymbols()) {
                if (builder.contains(s)) continue;
                builder.add(s);
            }
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String tableName = "R";
        private String tablePackage = "";
        private Map<String, Symbol> symbols = new HashMap<String, Symbol>();

        private Builder() {
        }

        public Builder add(Symbol symbol) {
            String key = SymbolTable.key(symbol);
            if (this.symbols.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate symbol in table with resource type '" + symbol.getResourceType() + "' and symbol name '" + symbol.getName() + "'");
            }
            this.symbols.put(key, symbol);
            return this;
        }

        public Builder addAll(Collection<Symbol> symbols) {
            symbols.forEach(this::add);
            return this;
        }

        public Builder tableName(String tableName) {
            Preconditions.checkArgument((boolean)SourceVersion.isIdentifier(tableName));
            this.tableName = tableName;
            return this;
        }

        public Builder tablePackage(String tablePackage) {
            if (!tablePackage.isEmpty()) {
                Arrays.asList(tablePackage.split("\\.")).forEach(p -> Preconditions.checkArgument((boolean)SourceVersion.isIdentifier(p)));
            }
            this.tablePackage = tablePackage;
            return this;
        }

        public boolean contains(Symbol symbol) {
            return this.symbols.containsKey(SymbolTable.key(symbol));
        }

        public SymbolTable build() {
            return new SymbolTable(this.tablePackage, this.tableName, this.symbols);
        }
    }
}

