/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.android.vending.developer.signing.tools.extern.export;

import com.google.security.keymaster.lite.KeymaestroHybridEncrypter;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.KeystoreHelper;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Base64;
import java.util.Map;

public class ExportEncryptedPrivateKeyTool {
    private static final String FLAG_KEYSTORE = "keystore";
    private static final String FLAG_ALIAS = "alias";
    private static final String FLAG_ENCRYPTION_KEY = "encryptionkey";
    private static final String FLAG_OUTPUT = "output";
    private static final String HELP_PAGE = "help.txt";
    private final KeystoreHelper keystoreHelper;

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("--help")) {
            ExportEncryptedPrivateKeyTool.printUsage();
            return;
        }
        String keystoreFile = null;
        String alias = null;
        String encryptionPublicKeyHex = null;
        String outputFile = null;
        try {
            Map<String, String> parsedFlags = Utils.processArgs(args);
            keystoreFile = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_KEYSTORE);
            alias = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_ALIAS);
            encryptionPublicKeyHex = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_ENCRYPTION_KEY);
            outputFile = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_OUTPUT);
            if (!parsedFlags.isEmpty()) {
                String string = String.valueOf(parsedFlags);
                throw new IllegalArgumentException(new StringBuilder(20 + String.valueOf(string).length()).append("Unrecognized flags: ").append(string).toString());
            }
        }
        catch (Exception e) {
            String string = String.valueOf(e.getMessage());
            System.err.println(string.length() != 0 ? "Error: ".concat(string) : new String("Error: "));
            ExportEncryptedPrivateKeyTool.printUsage();
            System.exit(1);
        }
        try {
            ExportEncryptedPrivateKeyTool tool = new ExportEncryptedPrivateKeyTool(new KeystoreHelper());
            tool.run(keystoreFile, alias, encryptionPublicKeyHex, outputFile, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = String.valueOf(e.getMessage());
            System.err.println(string.length() != 0 ? "Error: ".concat(string) : new String("Error: "));
            System.exit(1);
        }
    }

    private static String getFlagValue(Map<String, String> parsedFlags, String flagName) {
        return Utils.checkNotNull(parsedFlags.remove(flagName), new StringBuilder(20 + String.valueOf(flagName).length()).append("--").append(flagName).append(" must be specified").toString());
    }

    ExportEncryptedPrivateKeyTool(KeystoreHelper keystoreHelper) {
        this.keystoreHelper = keystoreHelper;
    }

    public ExportEncryptedPrivateKeyTool() {
        this.keystoreHelper = new KeystoreHelper();
    }

    public void run(String keystoreFile, String alias, String encryptionPublicKeyHex, String outputFile, char[] storePass, char[] aliasKeyPass) throws Exception {
        PrivateKey privateKey = this.keystoreHelper.getPrivateKey(keystoreFile, alias, storePass, aliasKeyPass);
        byte[] privateKeyPem = ExportEncryptedPrivateKeyTool.privateKeyToPem(privateKey);
        byte[] encryptedPrivateKey = this.encryptPrivateKey(ExportEncryptedPrivateKeyTool.fromHex(encryptionPublicKeyHex), privateKeyPem);
        Files.write(Paths.get(outputFile, new String[0]), encryptedPrivateKey, new OpenOption[0]);
    }

    static byte[] privateKeyToPem(PrivateKey privateKey) {
        String string = Base64.getEncoder().encodeToString(privateKey.getEncoded());
        String pemString = new StringBuilder(55 + String.valueOf(string).length()).append("-----BEGIN PRIVATE KEY-----\n").append(string).append("\n-----END PRIVATE KEY-----\n").toString();
        return pemString.getBytes(StandardCharsets.US_ASCII);
    }

    private byte[] encryptPrivateKey(byte[] encryptionPublicKey, byte[] plaintext) throws GeneralSecurityException {
        return new KeymaestroHybridEncrypter(encryptionPublicKey).encrypt(plaintext);
    }

    private static byte[] fromHex(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException(new StringBuilder(102 + String.valueOf(s).length()).append("Hex encoded byte array must have even length but instead has length: ").append(len).append(". Hex encoded string: ").append(s).toString());
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private static void printUsage() {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(ExportEncryptedPrivateKeyTool.class.getResourceAsStream(HELP_PAGE), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read help.txt resource");
        }
    }
}

