/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistActionHandler;
import com.android.tools.idea.assistant.RecipeUtils;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.templates.recipe.Recipe;
import com.google.services.firebase.DependencyDialog;
import com.google.services.firebase.FirebaseAnalyticsProvider;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.FirebaseContextDetails;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class AddDependencyAction
implements AssistActionHandler {
    protected static final String ACTION_KEY = "firebase.add_dependencies";

    private static Logger getLog() {
        return Logger.getInstance(AssistActionHandler.class);
    }

    @NotNull
    public String getId() {
        if (ACTION_KEY == null) {
            AddDependencyAction.$$$reportNull$$$0(0);
        }
        return ACTION_KEY;
    }

    public void handleAction(@NotNull ActionData actionData, @NotNull Project project) {
        if (actionData == null) {
            AddDependencyAction.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AddDependencyAction.$$$reportNull$$$0(2);
        }
        if (actionData.getRecipe() == null) {
            AddDependencyAction.getLog().error("No instructions found to add dependencies for " + actionData.getLabel());
            return;
        }
        DependencyDialog dependencyDialog = new DependencyDialog(actionData, project);
        dependencyDialog.pack();
        if (!dependencyDialog.showAndGet()) {
            return;
        }
        Module module = dependencyDialog.getModule();
        AddDependencyAction.getLog().info("Performing action " + actionData.getLabel() + " for module " + module.getName());
        RecipeUtils.execute((Recipe)actionData.getRecipe(), (Module)module);
        for (String dependency : dependencyDialog.getDependenciesToBeApplied()) {
            new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_DEPENDENCY_ADDED).withProject(project).withDetails(FirebaseContextDetails.newBuilder().setPerformedOn(dependency)).log();
        }
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(module.getProject(), GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, new GradleSyncListener(){

            public void syncStarted(@NotNull Project project, boolean skipped, boolean sourcesGenerationRequested) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            public void setupStarted(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(4);
                }
            }

            public void syncSkipped(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(5);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/google/services/firebase/AddDependencyAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setupStarted";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSucceeded";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncFailed";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSkipped";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/AddDependencyAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/AddDependencyAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

