/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.RecipeMetadata;
import com.android.tools.idea.assistant.RecipeUtils;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.templates.recipe.Recipe;
import com.google.services.firebase.DependencyStateManager;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.view.ModuleComboBox;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyDialog
extends DialogWrapper {
    private final ProjectChangesPanel myContentPanel;
    private Module mySelectedModule;
    private List<String> myDependenciesToBeApplied;

    DependencyDialog(@NotNull ActionData actionData, @NotNull Project project) {
        if (actionData == null) {
            DependencyDialog.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DependencyDialog.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.myDependenciesToBeApplied = new ArrayList<String>();
        List modules = GradleProjectInfo.getInstance((Project)project).getAndroidModules();
        if (modules.size() == 1) {
            this.mySelectedModule = (Module)modules.iterator().next();
        } else {
            this.setOKActionEnabled(false);
        }
        this.myContentPanel = new ProjectChangesPanel(actionData, modules);
        this.myContentPanel.setLayout(new BoxLayout((Container)((Object)this.myContentPanel), 1));
        this.init();
        this.setTitle(actionData.getLabel());
        Action okAction = this.getOKAction();
        okAction.putValue("Name", "Accept Changes");
    }

    @NotNull
    public List<String> getDependenciesToBeApplied() {
        List<String> list = Collections.unmodifiableList(this.myDependenciesToBeApplied);
        if (list == null) {
            DependencyDialog.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public Module getModule() {
        Module module = this.mySelectedModule;
        if (module == null) {
            DependencyDialog.$$$reportNull$$$0(3);
        }
        return module;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/DependencyDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/DependencyDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependenciesToBeApplied";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class ProjectChangesPanel
    extends JBPanel {
        private Project myProject;
        private ComboBox myModuleBox;
        private JBPanel myProposedChangesPanel;
        private RecipeMetadata mySampleMetadata;
        private List<RecipeMetadata> myMetadataList;
        private RecipeMetadata mySelectedMetadata;

        public ProjectChangesPanel(@NotNull ActionData actionData, List<Module> modules) {
            if (actionData == null) {
                ProjectChangesPanel.$$$reportNull$$$0(0);
            }
            if (modules == null) {
                ProjectChangesPanel.$$$reportNull$$$0(1);
            }
            if (actionData.getRecipe() == null) {
                this.getLog().error("Missing dependency configuration data for: " + actionData);
                return;
            }
            Module sampleModule = modules.iterator().next();
            this.myProject = sampleModule.getProject();
            this.myMetadataList = RecipeUtils.getRecipeMetadata((Recipe)actionData.getRecipe(), (Project)this.myProject);
            this.mySampleMetadata = this.myMetadataList.get(0);
            if (DependencyDialog.this.mySelectedModule == null) {
                JPanel moduleWrapper = new JPanel(new FlowLayout(0, 0, 5));
                moduleWrapper.setOpaque(false);
                JBLabel moduleLabel = new JBLabel(FirebaseBundle.message("dependencies.add.selectModule.label", new Object[0]));
                moduleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
                moduleWrapper.add((Component)moduleLabel);
                ArrayList<Module> incompleteModules = new ArrayList<Module>();
                if (DependencyStateManager.getPendingClasspaths(this.myProject, this.mySampleMetadata).isEmpty()) {
                    for (RecipeMetadata metadata : this.myMetadataList) {
                        Module module = metadata.getModule();
                        if (!DependencyStateManager.getPendingPlugins(metadata).isEmpty()) {
                            incompleteModules.add(module);
                            continue;
                        }
                        if (DependencyStateManager.getPendingDependencies(metadata, GradleBuildModel.get((Module)module)).isEmpty()) continue;
                        incompleteModules.add(module);
                    }
                } else {
                    incompleteModules.addAll(modules);
                }
                this.myModuleBox = new ModuleComboBox(incompleteModules);
                moduleWrapper.add((Component)this.myModuleBox);
                moduleWrapper.setAlignmentX(0.0f);
                this.add(moduleWrapper);
                this.myModuleBox.addActionListener(this::selectModule);
            }
            this.updateMutableView();
        }

        private void updateMutableView() {
            List<String> pluginsToApply;
            if (this.myProposedChangesPanel != null) {
                this.remove((Component)this.myProposedChangesPanel);
                this.revalidate();
                this.repaint();
            }
            this.myProposedChangesPanel = new JBPanel();
            this.myProposedChangesPanel.setLayout((LayoutManager)new BoxLayout((Container)this.myProposedChangesPanel, 1));
            List<String> classpathEntriesToAdd = DependencyStateManager.getPendingClasspaths(this.myProject, this.mySampleMetadata);
            if (DependencyDialog.this.mySelectedModule != null) {
                for (RecipeMetadata metadata : this.myMetadataList) {
                    if (!metadata.getModule().equals(DependencyDialog.this.mySelectedModule)) continue;
                    this.mySelectedMetadata = metadata;
                }
            }
            GradleBuildModel gradleBuildModel = null;
            if (this.mySelectedMetadata == null) {
                pluginsToApply = this.mySampleMetadata.getPlugins();
                DependencyDialog.this.myDependenciesToBeApplied = this.mySampleMetadata.getDependencies();
            } else {
                pluginsToApply = DependencyStateManager.getPendingPlugins(this.mySelectedMetadata);
                gradleBuildModel = GradleBuildModel.get((Module)this.mySelectedMetadata.getModule());
                DependencyDialog.this.myDependenciesToBeApplied = DependencyStateManager.getPendingDependencies(this.mySelectedMetadata, gradleBuildModel);
            }
            JLabel summary = new JLabel();
            summary.setOpaque(false);
            summary.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            summary.setText(FirebaseBundle.message("dependencies.add.preface", new Object[0]));
            summary.setAlignmentX(0.0f);
            this.myProposedChangesPanel.add((Component)summary);
            StringBuilder detailsBuilder = new StringBuilder();
            String detailsCss = ".dependency { color: green; font-weight: bold; font-family: monospace; }\nbody {padding: 10px; }";
            String indent_1 = "    ";
            String indent_2 = "        ";
            if (!classpathEntriesToAdd.isEmpty()) {
                detailsBuilder.append("<pre><b>build.gradle (project-level)</b>\n\n").append(indent_1).append("Add Firebase Gradle buildscript dependency\n");
                for (String string : classpathEntriesToAdd) {
                    detailsBuilder.append(indent_2).append("classpath <font class=\"dependency\">'").append(string).append("'</font>\n");
                }
                detailsBuilder.append("</pre>");
                detailsBuilder.append("<div style=\"height: 1px; font-size: 0; background: #cccccc;\"></div><br>");
            }
            detailsBuilder.append("<pre><b>app/build.gradle</b>\n\n");
            if (!pluginsToApply.isEmpty()) {
                detailsBuilder.append(indent_1).append("Add Firebase plugin for Gradle\n");
                for (String string : pluginsToApply) {
                    detailsBuilder.append(indent_2).append("apply plugin: <font class=\"dependency\">'").append(string).append("'</font>\n");
                }
                detailsBuilder.append("\n");
            }
            boolean hasAnalytics = false;
            if (!DependencyDialog.this.myDependenciesToBeApplied.isEmpty()) {
                detailsBuilder.append(indent_1).append("<b>build.gradle</b> will include these new dependencies:\n");
                for (String dependency : DependencyDialog.this.myDependenciesToBeApplied) {
                    detailsBuilder.append(indent_2).append("compile <font class=\"dependency\">'").append(dependency).append("'</font>\n");
                    hasAnalytics |= dependency.contains("firebase-core");
                }
            }
            detailsBuilder.append("</pre>");
            JTextPane jTextPane = new JTextPane();
            UIUtils.setHtml((JEditorPane)jTextPane, (String)detailsBuilder.toString(), (String)detailsCss);
            jTextPane.setBackground(UIUtils.getBackgroundColor());
            jTextPane.setMargin((Insets)new JBInsets(10, 10, 10, 10));
            jTextPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIUtils.getSeparatorColor()));
            jTextPane.setAlignmentX(0.0f);
            this.myProposedChangesPanel.add((Component)jTextPane);
            if (!hasAnalytics && gradleBuildModel != null) {
                hasAnalytics = DependencyStateManager.hasAnalytics(gradleBuildModel);
            }
            if (!hasAnalytics) {
                JTextPane analyticsWarning = new JTextPane();
                analyticsWarning.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
                UIUtils.setHtml((JEditorPane)analyticsWarning, (String)FirebaseBundle.message("dependencies.add.analyticsWarning", new Object[0]));
                analyticsWarning.setAlignmentX(0.0f);
                this.myProposedChangesPanel.add((Component)analyticsWarning);
            }
            this.add((Component)this.myProposedChangesPanel);
            DependencyDialog.this.pack();
        }

        void selectModule(ActionEvent e) {
            DependencyDialog.this.mySelectedModule = (Module)this.myModuleBox.getSelectedItem();
            this.updateMutableView();
            DependencyDialog.this.setOKActionEnabled(true);
        }

        private Logger getLog() {
            return Logger.getInstance(ProjectChangesPanel.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modules";
                    break;
                }
            }
            objectArray[1] = "com/google/services/firebase/DependencyDialog$ProjectChangesPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

