/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.RecipeMetadata;
import com.android.tools.idea.assistant.RecipeUtils;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.templates.recipe.Recipe;
import com.google.services.firebase.FirebaseBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyStateManager
extends AssistActionStateManager {
    static final String ANALYTICS_DEP_NAME = "firebase-core";
    private final Map<ActionData, DefaultActionState> myStateMap = new HashMap<ActionData, DefaultActionState>();
    private final Map<ActionData, String> myStateMessageMap = new HashMap<ActionData, String>();
    private final Set<Project> myRegisteredProjects = new HashSet<Project>();

    private static Logger getLog() {
        return Logger.getInstance(DependencyStateManager.class);
    }

    @NotNull
    private DefaultActionState getDependencyState(@NotNull ActionData actionData, @NotNull Project project) {
        if (actionData == null) {
            DependencyStateManager.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DependencyStateManager.$$$reportNull$$$0(1);
        }
        this.myStateMessageMap.remove(actionData);
        Recipe recipe = actionData.getRecipe();
        if (recipe == null) {
            DependencyStateManager.getLog().error("Unable to retrieve dependency configuration");
            DefaultActionState defaultActionState = DefaultActionState.INCOMPLETE;
            if (defaultActionState == null) {
                DependencyStateManager.$$$reportNull$$$0(2);
            }
            return defaultActionState;
        }
        List recipeMetadata = RecipeUtils.getRecipeMetadata((Recipe)recipe, (Project)project);
        RecipeMetadata sampleMetadata = (RecipeMetadata)recipeMetadata.iterator().next();
        if (!DependencyStateManager.getPendingClasspaths(project, sampleMetadata).isEmpty()) {
            DefaultActionState defaultActionState = DefaultActionState.INCOMPLETE;
            if (defaultActionState == null) {
                DependencyStateManager.$$$reportNull$$$0(3);
            }
            return defaultActionState;
        }
        int numCompleted = 0;
        for (RecipeMetadata metadata : recipeMetadata) {
            GradleBuildModel gradleBuildModel = GradleBuildModel.get((Module)metadata.getModule());
            if (gradleBuildModel == null || !DependencyStateManager.getPendingPlugins(metadata).isEmpty() || !DependencyStateManager.getPendingDependencies(metadata, gradleBuildModel).isEmpty()) continue;
            ++numCompleted;
        }
        if (numCompleted == 0) {
            DefaultActionState defaultActionState = DefaultActionState.INCOMPLETE;
            if (defaultActionState == null) {
                DependencyStateManager.$$$reportNull$$$0(4);
            }
            return defaultActionState;
        }
        if (numCompleted != recipeMetadata.size()) {
            this.myStateMessageMap.put(actionData, FirebaseBundle.message("dependencies.add.partiallyCompleted", numCompleted, recipeMetadata.size()));
            DefaultActionState defaultActionState = DefaultActionState.PARTIALLY_COMPLETE;
            if (defaultActionState == null) {
                DependencyStateManager.$$$reportNull$$$0(5);
            }
            return defaultActionState;
        }
        DefaultActionState defaultActionState = DefaultActionState.COMPLETE;
        if (defaultActionState == null) {
            DependencyStateManager.$$$reportNull$$$0(6);
        }
        return defaultActionState;
    }

    @NotNull
    public String getId() {
        if ("firebase.add_dependencies" == null) {
            DependencyStateManager.$$$reportNull$$$0(7);
        }
        return "firebase.add_dependencies";
    }

    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        if (project == null) {
            DependencyStateManager.$$$reportNull$$$0(8);
        }
        if (actionData == null) {
            DependencyStateManager.$$$reportNull$$$0(9);
        }
        this.myStateMap.put(actionData, this.getDependencyState(actionData, project));
        if (this.myRegisteredProjects.contains(project)) {
            return;
        }
        this.myRegisteredProjects.add(project);
        GradleSyncState.subscribe((Project)project, (GradleSyncListener)new GradleSyncListener(){

            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                DependencyStateManager.this.refreshDependencyStateIfNeeded(project);
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(2);
                }
                DependencyStateManager.this.refreshDependencyStateIfNeeded(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/google/services/firebase/DependencyStateManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSucceeded";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncFailed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public DefaultActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        if (project == null) {
            DependencyStateManager.$$$reportNull$$$0(10);
        }
        if (actionData == null) {
            DependencyStateManager.$$$reportNull$$$0(11);
        }
        if (!this.myStateMap.containsKey(actionData)) {
            return DefaultActionState.INCOMPLETE;
        }
        return this.myStateMap.get(actionData);
    }

    @Nullable
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String successMessage) {
        if (project == null) {
            DependencyStateManager.$$$reportNull$$$0(12);
        }
        if (actionData == null) {
            DependencyStateManager.$$$reportNull$$$0(13);
        }
        String message = this.myStateMessageMap.containsKey(actionData) ? this.myStateMessageMap.get(actionData) : successMessage;
        return new StatefulButtonMessage(message, (AssistActionState)this.getState(project, actionData));
    }

    private void refreshDependencyStateIfNeeded(@NotNull Project project) {
        if (project == null) {
            DependencyStateManager.$$$reportNull$$$0(14);
        }
        DependencyStateManager.getLog().info("Refreshing dependency state");
        boolean stateChanged = false;
        for (Map.Entry<ActionData, DefaultActionState> entry : this.myStateMap.entrySet()) {
            String newMessage;
            DefaultActionState state = entry.getValue();
            ActionData actionData = entry.getKey();
            String oldMessage = this.myStateMessageMap.get(actionData);
            DefaultActionState newValue = this.getDependencyState(actionData, project);
            if (!state.equals((Object)newValue)) {
                entry.setValue(newValue);
                stateChanged = true;
            }
            if ((newMessage = this.myStateMessageMap.get(actionData)) == null || newMessage.equals(oldMessage)) continue;
            stateChanged = true;
        }
        if (!stateChanged) {
            return;
        }
        this.refreshDependencyState(project);
    }

    static List<String> getPendingDependencies(@NotNull RecipeMetadata metadata, @Nullable GradleBuildModel buildModel) {
        if (metadata == null) {
            DependencyStateManager.$$$reportNull$$$0(15);
        }
        if (buildModel == null) {
            return Collections.emptyList();
        }
        DependenciesModel dependenciesModel = buildModel.dependencies();
        if (dependenciesModel == null) {
            return Collections.emptyList();
        }
        return DependencyStateManager.findMissingDependencies(metadata.getDependencies(), dependenciesModel.artifacts());
    }

    @NotNull
    static List<String> getPendingClasspaths(@NotNull Project project, RecipeMetadata recipeMetadata) {
        GradleBuildModel projectGradleBuildModel;
        if (project == null) {
            DependencyStateManager.$$$reportNull$$$0(16);
        }
        if ((projectGradleBuildModel = GradleBuildModel.get((Project)project)) == null) {
            DependencyStateManager.getLog().warn("Unable to get gradle model to access current dependencies");
            List<String> list = Collections.emptyList();
            if (list == null) {
                DependencyStateManager.$$$reportNull$$$0(17);
            }
            return list;
        }
        DependenciesModel dependencies = projectGradleBuildModel.buildscript().dependencies();
        List<String> list = DependencyStateManager.findMissingDependencies(recipeMetadata.getClasspathEntries(), dependencies.artifacts("classpath"));
        if (list == null) {
            DependencyStateManager.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    private static List<String> findMissingDependencies(@NotNull List<String> depsToFind, @NotNull List<? extends ArtifactDependencyModel> existingDeps) {
        if (depsToFind == null) {
            DependencyStateManager.$$$reportNull$$$0(19);
        }
        if (existingDeps == null) {
            DependencyStateManager.$$$reportNull$$$0(20);
        }
        ArrayList<String> pendingDependencies = new ArrayList<String>();
        for (String dependencyValue : depsToFind) {
            ArtifactDependencySpec requiredDepSpec = ArtifactDependencySpec.create((String)dependencyValue);
            if (requiredDepSpec == null) {
                ArrayList<String> arrayList = pendingDependencies;
                if (arrayList == null) {
                    DependencyStateManager.$$$reportNull$$$0(21);
                }
                return arrayList;
            }
            boolean found = false;
            for (ArtifactDependencyModel artifactDependencyModel : existingDeps) {
                ArtifactDependencySpec foundDepSpec = ArtifactDependencySpec.create((ArtifactDependencyModel)artifactDependencyModel);
                if (!foundDepSpec.equalsIgnoreVersion((Object)requiredDepSpec) || VersionComparatorUtil.compare((String)foundDepSpec.getVersion(), (String)requiredDepSpec.getVersion()) < 0) continue;
                found = true;
            }
            if (found) continue;
            pendingDependencies.add(dependencyValue);
        }
        ArrayList<String> arrayList = pendingDependencies;
        if (arrayList == null) {
            DependencyStateManager.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @NotNull
    static List<String> getPendingPlugins(@NotNull RecipeMetadata metadata) {
        if (metadata == null) {
            DependencyStateManager.$$$reportNull$$$0(23);
        }
        ArrayList<String> pendingPlugins = new ArrayList<String>();
        GradleBuildModel gradleBuildModel = GradleBuildModel.get((Module)metadata.getModule());
        if (gradleBuildModel == null) {
            ArrayList<String> arrayList = pendingPlugins;
            if (arrayList == null) {
                DependencyStateManager.$$$reportNull$$$0(24);
            }
            return arrayList;
        }
        List plugins = PluginModel.extractNames((List)gradleBuildModel.plugins());
        for (String plugin : metadata.getPlugins()) {
            if (!plugins.contains(plugin)) {
                DependencyStateManager.getLog().info("did not find plugin: " + plugin);
                pendingPlugins.add(plugin);
                continue;
            }
            DependencyStateManager.getLog().debug("found plugin: " + plugin);
        }
        ArrayList<String> arrayList = pendingPlugins;
        if (arrayList == null) {
            DependencyStateManager.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    static boolean hasAnalytics(@Nullable GradleBuildModel buildModel) {
        if (buildModel == null) {
            return false;
        }
        DependenciesModel dependenciesModel = buildModel.dependencies();
        if (dependenciesModel == null) {
            return false;
        }
        for (ArtifactDependencyModel dependency : dependenciesModel.artifacts()) {
            if (!dependency.name().forceString().contains(ANALYTICS_DEP_NAME)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionData";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/DependencyStateManager";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depsToFind";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingDeps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/DependencyStateManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPendingClasspaths";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findMissingDependencies";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPendingPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyState";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStateDisplay";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "refreshDependencyStateIfNeeded";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPendingDependencies";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPendingClasspaths";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findMissingDependencies";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPendingPlugins";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

