/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.DefaultTutorialBundle;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.google.gct.login.GoogleLogin;
import com.google.services.firebase.FirebaseConnectStateManager;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.FirebaseContextDetails;
import com.google.wireless.android.sdk.stats.FirebaseErrorDetails;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class FirebaseAnalyticsProvider
implements AnalyticsProvider {
    private static final ActionData myFakeActionData = new DefaultTutorialBundle.Action();

    public void trackPanelOpened(@NotNull Project project) {
        if (project == null) {
            FirebaseAnalyticsProvider.$$$reportNull$$$0(0);
        }
        new Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_OPEN).withProject(project).log();
    }

    public void trackFeatureGroupExpanded(@NotNull String groupName, @NotNull Project project) {
        if (groupName == null) {
            FirebaseAnalyticsProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            FirebaseAnalyticsProvider.$$$reportNull$$$0(2);
        }
        new Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_FEATURE_EXPANDED).withProject(project).withDetails(FirebaseContextDetails.newBuilder().setPerformedOn(groupName)).log();
    }

    public void trackTutorialOpen(@NotNull String tutorialId, @NotNull Project project) {
        if (tutorialId == null) {
            FirebaseAnalyticsProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            FirebaseAnalyticsProvider.$$$reportNull$$$0(4);
        }
        new Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_TUTORIAL_OPENED).withProject(project).withDetails(FirebaseContextDetails.newBuilder().setPerformedOn(tutorialId)).log();
    }

    /*
     * WARNING - void declaration
     */
    public void trackTutorialClosed(@NotNull String tutorialId, long timeOpenMs, @NotNull Project project) {
        void project2;
        if (tutorialId == null) {
            FirebaseAnalyticsProvider.$$$reportNull$$$0(5);
        }
        if (project == null) {
            FirebaseAnalyticsProvider.$$$reportNull$$$0(6);
        }
        new Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_TUTORIAL_CLOSED).withProject((Project)project2).withDetails(FirebaseContextDetails.newBuilder().setPerformedOn(tutorialId).setDuration(timeOpenMs)).log();
    }

    private static boolean isLoggedIn() {
        return GoogleLogin.getInstance().isLoggedIn();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tutorialId";
                break;
            }
        }
        objectArray2[1] = "com/google/services/firebase/FirebaseAnalyticsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "trackPanelOpened";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "trackFeatureGroupExpanded";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "trackTutorialOpen";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "trackTutorialClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Logger {
        private AndroidStudioEvent.EventKind myKind;
        private Project myProject;
        private OnlineProject myOnlineProject;
        private FirebaseContextDetails.Builder myDetails;
        private FirebaseErrorDetails.Builder myErrorDetails;

        public Logger(@NotNull AndroidStudioEvent.EventKind kind) {
            if (kind == null) {
                Logger.$$$reportNull$$$0(0);
            }
            this.myKind = kind;
        }

        public Logger withProject(@NotNull Project project) {
            if (project == null) {
                Logger.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            return this;
        }

        public Logger withOnlineProject(@NotNull OnlineProject project) {
            if (project == null) {
                Logger.$$$reportNull$$$0(2);
            }
            this.myOnlineProject = project;
            return this;
        }

        public Logger withDetails(@NotNull FirebaseContextDetails.Builder details) {
            if (details == null) {
                Logger.$$$reportNull$$$0(3);
            }
            this.myDetails = details;
            return this;
        }

        public Logger withErrorDetails(@NotNull FirebaseErrorDetails.Builder errorDetails) {
            if (errorDetails == null) {
                Logger.$$$reportNull$$$0(4);
            }
            this.myErrorDetails = errorDetails;
            return this;
        }

        public void log() {
            if (this.myDetails == null) {
                this.myDetails = FirebaseContextDetails.newBuilder();
            }
            this.myDetails.setLoggedIn(FirebaseAnalyticsProvider.isLoggedIn());
            if (this.myOnlineProject != null) {
                this.myDetails.setProjectId(this.myOnlineProject.getProjectId()).setProjectNumber(this.myOnlineProject.getProjectNumber());
            }
            FirebaseConnectStateManager stateManager = null;
            for (AssistActionStateManager manager : (AssistActionStateManager[])AssistActionStateManager.EP_NAME.getExtensions()) {
                if (!(manager instanceof FirebaseConnectStateManager)) continue;
                stateManager = (FirebaseConnectStateManager)manager;
                break;
            }
            if (stateManager != null && this.myProject != null) {
                FirebaseContextDetails.ConnectStatus status;
                DefaultActionState state = stateManager.getState(this.myProject, myFakeActionData);
                switch (state) {
                    case COMPLETE: {
                        status = FirebaseContextDetails.ConnectStatus.CONNECTED;
                        break;
                    }
                    case INCOMPLETE: {
                        status = FirebaseContextDetails.ConnectStatus.NOT_CONNECTED;
                        break;
                    }
                    case PARTIALLY_COMPLETE: {
                        status = FirebaseContextDetails.ConnectStatus.PARTIALLY_CONNECTED;
                        break;
                    }
                    default: {
                        status = FirebaseContextDetails.ConnectStatus.UNKNOWN_CONNECT_STATUS;
                    }
                }
                this.myDetails.setConnectStatus(status);
            }
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.FIREBASE_ASSISTANT).setKind(this.myKind).setFirebaseContextDetails(this.myDetails);
            if (this.myErrorDetails != null) {
                event.setFirebaseErrorDetails(this.myErrorDetails);
            }
            UsageTracker.getInstance().log(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "details";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorDetails";
                    break;
                }
            }
            objectArray2[1] = "com/google/services/firebase/FirebaseAnalyticsProvider$Logger";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withProject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withOnlineProject";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withDetails";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withErrorDetails";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

