/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.assistant.DefaultTutorialBundle;
import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.google.services.firebase.FirebaseAnalyticsProvider;
import com.google.services.firebase.FirebaseTutorialBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirebaseBundleCreator
implements AssistantBundleCreator {
    private static final String TUTORIAL_CONFIG_FILENAME = "/firebase_tutorial_bundle.xml";
    private FirebaseTutorialBundle myBundle = null;

    private static Logger getLog() {
        return Logger.getInstance(FirebaseBundleCreator.class);
    }

    @NotNull
    public String getBundleId() {
        if ("DeveloperServices.Firebase" == null) {
            FirebaseBundleCreator.$$$reportNull$$$0(0);
        }
        return "DeveloperServices.Firebase";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TutorialBundleData getBundle(@NotNull Project project) {
        if (project == null) {
            FirebaseBundleCreator.$$$reportNull$$$0(1);
        }
        if (this.myBundle != null) {
            FirebaseTutorialBundle firebaseTutorialBundle = this.myBundle;
            if (firebaseTutorialBundle == null) {
                FirebaseBundleCreator.$$$reportNull$$$0(2);
            }
            return firebaseTutorialBundle;
        }
        URL resource = this.getClass().getResource(TUTORIAL_CONFIG_FILENAME);
        if (resource == null) {
            throw new RuntimeException(String.format("Could not find service file %1$s", TUTORIAL_CONFIG_FILENAME));
        }
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            this.myBundle = (FirebaseTutorialBundle)((Object)DefaultTutorialBundle.parse((InputStream)inputStream, FirebaseTutorialBundle.class));
        }
        catch (IOException | JAXBException e) {
            FirebaseBundleCreator.getLog().error("Unable to parse /firebase_tutorial_bundle.xml to read services configuration.", e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                FirebaseBundleCreator.getLog().warn((Throwable)e);
            }
        }
        FirebaseTutorialBundle firebaseTutorialBundle = this.myBundle;
        if (firebaseTutorialBundle == null) {
            FirebaseBundleCreator.$$$reportNull$$$0(3);
        }
        return firebaseTutorialBundle;
    }

    @Nullable
    public URL getConfig() {
        return null;
    }

    @NotNull
    public AnalyticsProvider getAnalyticsProvider() {
        FirebaseAnalyticsProvider firebaseAnalyticsProvider = new FirebaseAnalyticsProvider();
        if (firebaseAnalyticsProvider == null) {
            FirebaseBundleCreator.$$$reportNull$$$0(4);
        }
        return firebaseAnalyticsProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/FirebaseBundleCreator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/FirebaseBundleCreator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalyticsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBundle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

