/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.google.gct.login.GoogleLogin;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.FirebaseConnectAction;
import com.google.services.firebase.ModuleAsyncStateManager;
import com.google.services.firebase.config.FirebaseConfig;
import com.google.services.firebase.config.FirebaseLocalConfig;
import com.google.services.firebase.mobilesdk.MobileSdkCommException;
import com.google.services.firebase.mobilesdk.MobileSdkUtil;
import com.google.services.firebase.mobilesdk.MobileSdkWrapper;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirebaseConnectStateManager
extends ModuleAsyncStateManager {
    private final Set<Project> myRegisteredProjects = new HashSet<Project>();

    private static Logger getLog() {
        return Logger.getInstance(FirebaseConnectAction.class);
    }

    public static void setCompletableState(@NotNull Module module, boolean stateOverride) {
        if (module == null) {
            FirebaseConnectStateManager.$$$reportNull$$$0(0);
        }
        for (AssistActionStateManager stateManager : (AssistActionStateManager[])AssistActionStateManager.EP_NAME.getExtensions()) {
            if (!stateManager.getId().equals("firebase.connect")) continue;
            ((FirebaseConnectStateManager)stateManager).updateModuleState(module, stateOverride);
        }
    }

    @Override
    boolean calculateState(@NotNull Module module) {
        List<OnlineProject> existingProjects;
        MobileSdkWrapper mobileSdkWrapper;
        if (module == null) {
            FirebaseConnectStateManager.$$$reportNull$$$0(1);
        }
        try {
            mobileSdkWrapper = MobileSdkUtil.getNewMobileSdkWrapper(GoogleLogin.getInstance());
        }
        catch (MobileSdkCommException exception) {
            FirebaseConnectStateManager.getLog().info("Not connected to Firebase because there is an issue making backend api calls");
            return true;
        }
        try {
            if (mobileSdkWrapper.getPendingTosUrl() != null) {
                FirebaseConnectStateManager.getLog().info("Not connected to Firebase because ToS is pending");
                return true;
            }
        }
        catch (MobileSdkCommException exception) {
            FirebaseConnectStateManager.getLog().info("Not connected to Firebase because ToS status couldn't be determined.");
            return true;
        }
        try {
            existingProjects = mobileSdkWrapper.getExistingProjects();
        }
        catch (MobileSdkCommException exception) {
            FirebaseConnectStateManager.getLog().info("Not connected to Firebase because couldn't list existing projects.");
            return true;
        }
        try {
            FirebaseConfig firebaseConfig = new FirebaseConfig(module, existingProjects);
            if (firebaseConfig.isMultipleOnlineProjectsResolvedToAndroidClientMappings()) {
                FirebaseConnectStateManager.getLog().info("Not connected to Firebase because multiple project mappings found.");
                return true;
            }
            FirebaseConnectStateManager.getLog().info("IsConnected: " + firebaseConfig.isConnected());
            return !firebaseConfig.isConnected();
        }
        catch (FirebaseLocalConfig.InvalidLocalConfigException exception) {
            FirebaseConnectStateManager.getLog().info("Not connected to Firebase because there was an invalid Firebase configuration");
            return true;
        }
    }

    @Override
    String getTaskDisplayName() {
        return FirebaseBundle.message("firebase.service.action.label.refresh.state.action", new Object[0]);
    }

    @NotNull
    public String getId() {
        if ("firebase.connect" == null) {
            FirebaseConnectStateManager.$$$reportNull$$$0(2);
        }
        return "firebase.connect";
    }

    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        if (project == null) {
            FirebaseConnectStateManager.$$$reportNull$$$0(3);
        }
        if (actionData == null) {
            FirebaseConnectStateManager.$$$reportNull$$$0(4);
        }
        if (this.myRegisteredProjects.contains(project)) {
            return;
        }
        this.myRegisteredProjects.add(project);
        GradleSyncState.subscribe((Project)project, (GradleSyncListener)new GradleSyncListener(){

            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                FirebaseConnectStateManager.this.updateAllModuleStates(project);
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(2);
                }
                FirebaseConnectStateManager.this.updateAllModuleStates(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/google/services/firebase/FirebaseConnectStateManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSucceeded";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncFailed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String successMessage) {
        if (project == null) {
            FirebaseConnectStateManager.$$$reportNull$$$0(5);
        }
        if (actionData == null) {
            FirebaseConnectStateManager.$$$reportNull$$$0(6);
        }
        String message = this.myStateMessageMap.containsKey(project) ? (String)this.myStateMessageMap.get(project) : successMessage;
        return new StatefulButtonMessage(message, (AssistActionState)this.getState(project, actionData));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/FirebaseConnectStateManager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/FirebaseConnectStateManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setCompletableState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateState";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStateDisplay";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

