/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.StatefulButtonNotifier;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.google.services.firebase.FirebaseBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.EdtInvocationManager;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleAsyncStateManager
extends AssistActionStateManager {
    protected final Map<Project, String> myStateMessageMap = new HashMap<Project, String>();
    private final HashMap<Integer, ModuleState> myModuleStates = new HashMap();

    private static Logger getLog() {
        return Logger.getInstance(ModuleAsyncStateManager.class);
    }

    public void updateAllModuleStates(@NotNull Project project) {
        Module[] modules;
        if (project == null) {
            ModuleAsyncStateManager.$$$reportNull$$$0(0);
        }
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            if (!this.myModuleStates.containsKey(module.hashCode())) continue;
            this.requestModuleStatusUpdate(module);
        }
    }

    public DefaultActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        if (project == null) {
            ModuleAsyncStateManager.$$$reportNull$$$0(1);
        }
        if (actionData == null) {
            ModuleAsyncStateManager.$$$reportNull$$$0(2);
        }
        this.myStateMessageMap.remove(project);
        List modules = GradleProjectInfo.getInstance((Project)project).getAndroidModules();
        ModuleAsyncStateManager.getLog().debug("getState called for: " + project.getName());
        int numCompleted = 0;
        for (Module module : modules) {
            if (this.myModuleStates.containsKey(module.hashCode())) {
                if (this.myModuleStates.get(module.hashCode()).isCompletable()) continue;
                ++numCompleted;
                continue;
            }
            this.requestModuleStatusUpdate(module);
            return DefaultActionState.IN_PROGRESS;
        }
        if (numCompleted == 0) {
            return DefaultActionState.INCOMPLETE;
        }
        if (numCompleted != modules.size()) {
            this.myStateMessageMap.put(project, FirebaseBundle.message("stateManager.userNote.partiallyCompleted", numCompleted, modules.size()));
            return DefaultActionState.PARTIALLY_COMPLETE;
        }
        return DefaultActionState.COMPLETE;
    }

    protected void requestModuleStatusUpdate(@NotNull Module module) {
        if (module == null) {
            ModuleAsyncStateManager.$$$reportNull$$$0(3);
        }
        ModuleState currentState = this.getModuleState(module);
        currentState.startRefreshTask(module);
    }

    void updateModuleState(Module module, boolean newIsCompletableState) {
        ModuleAsyncStateManager.getLog().debug("Updating module state: " + newIsCompletableState);
        ModuleState moduleState = this.getModuleState(module);
        if (moduleState.isCompletable() != newIsCompletableState) {
            ModuleAsyncStateManager.getLog().debug("Sending refresh notification Stateful button.");
            moduleState.setCompletable(newIsCompletableState);
            MessageBus bus = module.getMessageBus();
            StatefulButtonNotifier publisher = (StatefulButtonNotifier)bus.syncPublisher(StatefulButtonNotifier.BUTTON_STATE_TOPIC);
            publisher.stateUpdated();
        } else {
            ModuleAsyncStateManager.getLog().debug("Module state did not change.");
        }
    }

    @NotNull
    private ModuleState getModuleState(Module module) {
        ModuleState moduleState = this.myModuleStates.get(module.hashCode());
        if (moduleState == null) {
            moduleState = new ModuleState();
            this.myModuleStates.put(module.hashCode(), moduleState);
        }
        ModuleState moduleState2 = moduleState;
        if (moduleState2 == null) {
            ModuleAsyncStateManager.$$$reportNull$$$0(4);
        }
        return moduleState2;
    }

    abstract boolean calculateState(@NotNull Module var1);

    abstract String getTaskDisplayName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/ModuleAsyncStateManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/ModuleAsyncStateManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateAllModuleStates";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "requestModuleStatusUpdate";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ModuleState {
        @NotNull
        private final Object myTaskLock = new Object();
        @Nullable
        private WeakReference<Task.Backgroundable> myModuleUpdateTask;
        private int myNumRequestedStateUpdates;
        private boolean myIsCompletable = true;

        ModuleState() {
        }

        boolean isCompletable() {
            return this.myIsCompletable;
        }

        void setCompletable(boolean completable) {
            this.myIsCompletable = completable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void startRefreshTask(Module module) {
            Object object = this.myTaskLock;
            synchronized (object) {
                ++this.myNumRequestedStateUpdates;
                if (this.myModuleUpdateTask == null || this.myModuleUpdateTask.get() == null) {
                    this.myModuleUpdateTask = new WeakReference<Task.Backgroundable>(this.runRefreshStateTask(module));
                }
            }
        }

        @NotNull
        private Task.Backgroundable runRefreshStateTask(final Module module) {
            ModuleAsyncStateManager.getLog().debug("Performing refresh task on module: " + module.getName());
            Task.Backgroundable refreshTask = new Task.Backgroundable(module.getProject(), ModuleAsyncStateManager.this.getTaskDisplayName()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        int numStateUpdates;
                        int numLoops = 0;
                        do {
                            ++numLoops;
                            Object object = ModuleState.this.myTaskLock;
                            synchronized (object) {
                                ModuleState.this.myNumRequestedStateUpdates = 0;
                            }
                            ModuleAsyncStateManager.getLog().debug("Running calculateState");
                            try {
                                ModuleAsyncStateManager.this.updateModuleState(module, ModuleAsyncStateManager.this.calculateState(module));
                            }
                            catch (IllegalStateException e) {
                                ModuleAsyncStateManager.getLog().warn("Gradle model not available, please check your gradle scripts and resync them with Android Studio using the Build menu.", (Throwable)e);
                            }
                            object = ModuleState.this.myTaskLock;
                            synchronized (object) {
                                numStateUpdates = ModuleState.this.myNumRequestedStateUpdates;
                            }
                        } while (numStateUpdates > 0 && numLoops < 5);
                    }
                    finally {
                        Object object = ModuleState.this.myTaskLock;
                        synchronized (object) {
                            ModuleState.this.myModuleUpdateTask = null;
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/google/services/firebase/ModuleAsyncStateManager$ModuleState$1", "run"));
                }
            };
            EdtInvocationManager.getInstance().invokeLater(() -> ProgressManager.getInstance().run((Task)refreshTask));
            Task.Backgroundable backgroundable = refreshTask;
            if (backgroundable == null) {
                ModuleState.$$$reportNull$$$0(0);
            }
            return backgroundable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/services/firebase/ModuleAsyncStateManager$ModuleState", "runRefreshStateTask"));
        }
    }
}

