/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.intellij.openapi.util.InvalidDataException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidClient {
    @NotNull
    private final String mySha1;
    @NotNull
    private final String myPackageName;
    private final boolean myAttemptRegistration;

    AndroidClient(@NotNull String packageName, @NotNull String sha1) throws InvalidDataException {
        if (packageName == null) {
            AndroidClient.$$$reportNull$$$0(0);
        }
        if (sha1 == null) {
            AndroidClient.$$$reportNull$$$0(1);
        }
        this(packageName, sha1, true);
    }

    AndroidClient(@NotNull String packageName, @NotNull String sha1, boolean attemptRegistration) throws InvalidDataException {
        if (packageName == null) {
            AndroidClient.$$$reportNull$$$0(2);
        }
        if (sha1 == null) {
            AndroidClient.$$$reportNull$$$0(3);
        }
        if (Strings.isNullOrEmpty((String)packageName)) {
            throw new InvalidDataException("Invalid packageName: " + packageName);
        }
        if (Strings.isNullOrEmpty((String)sha1)) {
            throw new InvalidDataException("Invalid sha1: " + sha1);
        }
        this.myPackageName = packageName;
        this.mySha1 = AndroidClient.normalizeSha1(sha1);
        this.myAttemptRegistration = attemptRegistration;
    }

    @Nullable
    public static AndroidClient createClient(@NotNull String packageName, @NotNull String sha1, boolean attemptRegistration) {
        if (packageName == null) {
            AndroidClient.$$$reportNull$$$0(4);
        }
        if (sha1 == null) {
            AndroidClient.$$$reportNull$$$0(5);
        }
        try {
            return new AndroidClient(packageName, sha1, attemptRegistration);
        }
        catch (InvalidDataException exception) {
            return null;
        }
    }

    @NotNull
    private static String normalizeSha1(@NotNull String sha1) {
        if (sha1 == null) {
            AndroidClient.$$$reportNull$$$0(6);
        }
        String string = sha1.replaceAll(":", "").toLowerCase(Locale.ENGLISH);
        if (string == null) {
            AndroidClient.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static boolean isSha1Equal(@NotNull String left, @NotNull String right) {
        if (left == null) {
            AndroidClient.$$$reportNull$$$0(8);
        }
        if (right == null) {
            AndroidClient.$$$reportNull$$$0(9);
        }
        return AndroidClient.normalizeSha1(left).equals(AndroidClient.normalizeSha1(right));
    }

    @NotNull
    public String getSha1() {
        String string = this.mySha1;
        if (string == null) {
            AndroidClient.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getPackageName() {
        String string = this.myPackageName;
        if (string == null) {
            AndroidClient.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean isAttemptRegistration() {
        return this.myAttemptRegistration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidClient that = (AndroidClient)o;
        if (!AndroidClient.isSha1Equal(this.mySha1, that.mySha1)) {
            return false;
        }
        return this.myPackageName.equals(that.myPackageName);
    }

    public String toString() {
        return "AndroidClient{myPackageName='" + this.myPackageName + '\'' + ", mySha1='" + this.mySha1 + '\'' + '}';
    }

    public int hashCode() {
        int result = this.mySha1.hashCode();
        result = 31 * result + this.myPackageName.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sha1";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/config/AndroidClient";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/config/AndroidClient";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeSha1";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSha1";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createClient";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "normalizeSha1";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSha1Equal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

