/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.client.util.Sets;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.config.FirebaseLocalConfig;
import com.google.services.firebase.config.FirebaseOnlineConfig;
import com.google.services.firebase.config.GradleConfig;
import com.google.services.firebase.config.InvalidConfigException;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirebaseConfig {
    @Nullable
    private OnlineProject myResolvedProject;
    @Nullable
    private final FirebaseLocalConfig myFirebaseLocalConfig;
    private final Set<AndroidClient> myUnregisteredClients;
    private final Set<AndroidClient> myRegisterableClients;
    private final Map<AndroidClient, OnlineProject> myRegisteredClients;
    @NotNull
    private final List<InvalidConfigException> myConfigExceptions;

    public FirebaseConfig(@NotNull Module androidApplicationModule, @Nullable Collection<OnlineProject> userAccessibleProjects) throws FirebaseLocalConfig.InvalidLocalConfigException {
        if (androidApplicationModule == null) {
            FirebaseConfig.$$$reportNull$$$0(0);
        }
        this(FirebaseLocalConfig.fromModule(androidApplicationModule), GradleConfig.fromModule(androidApplicationModule), userAccessibleProjects == null ? null : new FirebaseOnlineConfig(userAccessibleProjects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    FirebaseConfig(@Nullable FirebaseLocalConfig fileConfig, @NotNull GradleConfig gradleConfig, @Nullable FirebaseOnlineConfig onlineConfig) throws FirebaseLocalConfig.InvalidLocalConfigException {
        if (gradleConfig == null) {
            FirebaseConfig.$$$reportNull$$$0(1);
        }
        this.myFirebaseLocalConfig = fileConfig;
        HashSet<AndroidClient> unregisteredClients = new HashSet<AndroidClient>();
        HashMap<AndroidClient, OnlineProject> registeredClients = new HashMap<AndroidClient, OnlineProject>();
        ImmutableList.Builder configExceptionBuilder = new ImmutableList.Builder();
        try {
            Pair<AndroidClient, OnlineProject> matchedClientProjectPair;
            if (this.myFirebaseLocalConfig != null && this.myFirebaseLocalConfig.getConfigErrors() != null) {
                configExceptionBuilder.addAll(this.myFirebaseLocalConfig.getConfigErrors());
            }
            if (onlineConfig != null) {
                Map<AndroidClient, OnlineProject> onlineClientMap = onlineConfig.getClientToProjectMap();
                for (AndroidClient variant : gradleConfig.getVariants()) {
                    if (onlineClientMap.containsKey(variant)) {
                        FirebaseConfig.getLog().info("Found registered client: " + variant);
                        if (registeredClients.containsKey(variant)) {
                            FirebaseConfig.getLog().warn("Registered client (" + variant.toString() + ") found on multiple Firebase projects, ignoring.");
                            continue;
                        }
                        registeredClients.put(variant, onlineClientMap.get(variant));
                        continue;
                    }
                    FirebaseConfig.getLog().info("Found unregistered client: " + variant);
                    if (unregisteredClients.add(variant)) continue;
                    FirebaseConfig.getLog().warn("Unregistered client (" + variant.toString() + ") found on multiple Firebase projects, ignoring.");
                }
            }
            this.myUnregisteredClients = ImmutableSet.copyOf(unregisteredClients);
            this.myRegisterableClients = this.myUnregisteredClients.stream().filter(AndroidClient::isAttemptRegistration).collect(Collectors.toSet());
            this.myRegisteredClients = ImmutableMap.copyOf(registeredClients);
            if (this.myFirebaseLocalConfig != null && onlineConfig != null && !Strings.isNullOrEmpty((String)this.myFirebaseLocalConfig.getProjectNumber())) {
                this.myResolvedProject = onlineConfig.getProject(this.myFirebaseLocalConfig.getProjectNumber());
                if (this.myResolvedProject == null) {
                    configExceptionBuilder.add((Object)new UnknownProjectIdSpecifiedException(this.myFirebaseLocalConfig.getConfigFile(), this.myFirebaseLocalConfig.getProjectId()));
                    return;
                }
            }
            if (this.myResolvedProject == null && (matchedClientProjectPair = this.getFirstMatchedClientAndProject()) != null) {
                this.myResolvedProject = (OnlineProject)matchedClientProjectPair.getSecond();
            }
        }
        finally {
            this.myConfigExceptions = configExceptionBuilder.build();
        }
    }

    @NotNull
    public List<InvalidConfigException> getConfigErrors() {
        List<InvalidConfigException> list = this.myConfigExceptions;
        if (list == null) {
            FirebaseConfig.$$$reportNull$$$0(2);
        }
        return list;
    }

    public Collection<OnlineProject> getConnectedOnlineProjects() {
        return ImmutableSet.copyOf(this.myRegisteredClients.values());
    }

    private static Logger getLog() {
        return Logger.getInstance(FirebaseConfig.class);
    }

    public boolean isMultipleOnlineProjectsResolvedToAndroidClientMappings() {
        HashSet onlineProjects = Sets.newHashSet();
        onlineProjects.addAll(this.myRegisteredClients.values());
        return onlineProjects.size() > 1;
    }

    public boolean isLocalConfigPresent() {
        return this.myFirebaseLocalConfig != null;
    }

    @Nullable
    public Pair<AndroidClient, OnlineProject> getFirstMatchedClientAndProject() {
        if (this.myRegisteredClients.isEmpty()) {
            return null;
        }
        Map.Entry<AndroidClient, OnlineProject> firstEntry = this.myRegisteredClients.entrySet().iterator().next();
        return Pair.create((Object)firstEntry.getKey(), (Object)firstEntry.getValue());
    }

    @Nullable
    public File getLocalFirebaseConfigFile() {
        return this.myFirebaseLocalConfig != null ? this.myFirebaseLocalConfig.getConfigFile() : null;
    }

    @Nullable
    public String getLocalFirebaseConfigProjectId() {
        return this.myFirebaseLocalConfig != null ? this.myFirebaseLocalConfig.getProjectId() : null;
    }

    @Nullable
    public OnlineProject getResolvedProject() {
        return this.myResolvedProject;
    }

    @NotNull
    public Set<AndroidClient> getRegisterableAndroidClients() {
        Set<AndroidClient> set = this.myRegisterableClients;
        if (set == null) {
            FirebaseConfig.$$$reportNull$$$0(3);
        }
        return set;
    }

    public boolean isConnected() {
        return this.myResolvedProject != null && !this.myResolvedProject.isRequiredFirebaseMigration() && this.myUnregisteredClients.isEmpty() && !this.myRegisteredClients.isEmpty() && this.myFirebaseLocalConfig != null && this.myFirebaseLocalConfig.getConfigErrors() == null && this.myResolvedProject.getProjectNumber().equals(this.myFirebaseLocalConfig.getProjectNumber());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidApplicationModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleConfig";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/config/FirebaseConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/config/FirebaseConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigErrors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisterableAndroidClients";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UnknownProjectIdSpecifiedException
    extends InvalidConfigException {
        UnknownProjectIdSpecifiedException(@NotNull File configFile, @NotNull String projectId) {
            if (configFile == null) {
                UnknownProjectIdSpecifiedException.$$$reportNull$$$0(0);
            }
            if (projectId == null) {
                UnknownProjectIdSpecifiedException.$$$reportNull$$$0(1);
            }
            super("firebaseService.userError.existingConfigButNoMatchFound", configFile, projectId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "projectId";
                    break;
                }
            }
            objectArray[1] = "com/google/services/firebase/config/FirebaseConfig$UnknownProjectIdSpecifiedException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

